/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.FilePredictionHandler;
import com.intellij.filePrediction.FilePredictionSessionManager;
import com.intellij.filePrediction.features.history.FilePredictionHistory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/filePrediction/FilePredictionHandler;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "manager", "Lcom/intellij/filePrediction/FilePredictionSessionManager;", "dispose", "", "onFileSelected", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.filePrediction"})
public final class FilePredictionHandler
implements Disposable {
    private final ExecutorService executor;
    private final FilePredictionSessionManager manager;
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    public final void onFileSelected(@NotNull VirtualFile newFile) {
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        if (ProjectManagerImpl.isLight((Project)this.project)) {
            return;
        }
        this.executor.submit(new Runnable(this, newFile){
            final /* synthetic */ FilePredictionHandler this$0;
            final /* synthetic */ VirtualFile $newFile;

            public final void run() {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.this$0, (Runnable)new Runnable(this){
                    final /* synthetic */ onFileSelected.1 this$0;

                    public final void run() {
                        long start = System.currentTimeMillis();
                        FilePredictionHistory filePredictionHistory = FilePredictionHistory.Companion.getInstance(FilePredictionHandler.access$getProject$p(this.this$0.this$0));
                        String string = this.this$0.$newFile.getUrl();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newFile.url");
                        filePredictionHistory.onFileSelected(string);
                        FilePredictionHandler.access$getManager$p(this.this$0.this$0).onSessionStarted(FilePredictionHandler.access$getProject$p(this.this$0.this$0), this.this$0.$newFile);
                        if (FilePredictionHandler.access$getLOG$cp().isTraceEnabled()) {
                            FilePredictionHandler.access$getLOG$cp().trace("Candidates calculation took " + (System.currentTimeMillis() - start) + "ms");
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = filePredictionHandler;
                this.$newFile = virtualFile;
            }
        });
    }

    public void dispose() {
        this.executor.shutdown();
    }

    public FilePredictionHandler(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"NextFilePrediction");
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"SequentialTaskExecutor.c\u2026tor(\"NextFilePrediction\")");
        this.executor = executorService;
        double percent = Registry.get((String)"filePrediction.calculate.candidates.percent").asDouble();
        this.manager = new FilePredictionSessionManager(50, 3, 5, percent);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FilePredictionHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(FileP\u2026ctionHandler::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Project access$getProject$p(FilePredictionHandler $this) {
        return $this.project;
    }

    public static final /* synthetic */ FilePredictionSessionManager access$getManager$p(FilePredictionHandler $this) {
        return $this.manager;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/filePrediction/FilePredictionHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/filePrediction/FilePredictionHandler;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.filePrediction"})
    public static final class Companion {
        @Nullable
        public final FilePredictionHandler getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (FilePredictionHandler)ServiceManager.getService((Project)project, FilePredictionHandler.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

