/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring.extractTemplate;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Query;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringUtil;
import org.intellij.lang.xpath.xslt.refactoring.XsltRefactoringActionBase;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltExtractTemplateAction
extends XsltRefactoringActionBase {
    @Override
    public String getRefactoringName() {
        return "Extract Template";
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            XsltExtractTemplateAction.$$$reportNull$$$0(0);
        }
        if (!this.invokeImpl(editor, file)) {
            super.invoke(project, editor, file, dataContext);
        }
    }

    private boolean invokeImpl(Editor editor, PsiFile file) {
        return this.invokeImpl(editor, file, null);
    }

    public boolean invokeImpl(Editor editor, PsiFile file, String newName) {
        int endOffset;
        PsiElement end;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return false;
        }
        int startOffset = selectionModel.getSelectionStart();
        PsiElement start = file.findElementAt(startOffset);
        if (start instanceof PsiWhiteSpace && (start = PsiTreeUtil.nextLeaf((PsiElement)start)) != null) {
            startOffset = start.getTextOffset();
        }
        if ((end = file.findElementAt((endOffset = selectionModel.getSelectionEnd()) - 1)) instanceof PsiWhiteSpace && (end = PsiTreeUtil.prevLeaf((PsiElement)end)) != null) {
            endOffset = end.getTextRange().getEndOffset();
        }
        if (start == null || end == null) {
            return false;
        }
        PsiElement parent = start.getParent();
        if (!(parent instanceof XmlTag) && !(parent instanceof XmlComment)) {
            return false;
        }
        if (start == end) {
            if (start.getTextRange().getStartOffset() != startOffset) {
                return false;
            }
            if (end.getTextRange().getEndOffset() != endOffset) {
                return false;
            }
            if (this.extractFrom(start, end, newName)) {
                selectionModel.removeSelection();
                return true;
            }
        } else {
            XmlElement startTag = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)start, (Class[])new Class[]{XmlTag.class, XmlComment.class});
            if (startTag == null) {
                return false;
            }
            if (startTag.getTextRange().getStartOffset() != startOffset) {
                return false;
            }
            XmlElement endTag = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)end, (Class[])new Class[]{XmlTag.class, XmlComment.class});
            if (endTag == null) {
                return false;
            }
            if (endTag.getTextRange().getEndOffset() != endOffset) {
                return false;
            }
            if (startTag != endTag && startTag.getParent() != endTag.getParent()) {
                return false;
            }
            if (this.extractFrom((PsiElement)startTag, (PsiElement)endTag, newName)) {
                selectionModel.removeSelection();
                return true;
            }
        }
        return false;
    }

    private boolean extractFrom(@NotNull PsiElement start, PsiElement end, String newName) {
        String s;
        XmlTag outerTemplate;
        if (start == null) {
            XsltExtractTemplateAction.$$$reportNull$$$0(1);
        }
        if ((outerTemplate = XsltCodeInsightUtil.getTemplateTag(start, false)) == null) {
            return false;
        }
        XmlTag parentScope = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)start, XmlTag.class, (boolean)true);
        if (parentScope == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder("\n");
        LinkedHashSet<String> vars = new LinkedHashSet<String>();
        int startOffset = start.getTextRange().getStartOffset();
        int endOffset = end.getTextRange().getEndOffset();
        for (PsiElement e = start; e != null; e = e.getNextSibling()) {
            XmlTag tag;
            if (e instanceof XmlTag && XsltSupport.isVariable(tag = (XmlTag)e)) {
                XsltVariable variable = XsltElementFactory.getInstance().wrapElement(tag, XsltVariable.class);
                LocalSearchScope searchScope = new LocalSearchScope((PsiElement)parentScope);
                Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope);
                for (PsiReference reference : query) {
                    XmlElement context = (XmlElement)PsiTreeUtil.getContextOfType((PsiElement)reference.getElement(), XmlElement.class, (boolean)true);
                    if (context != null && context.getTextRange().getStartOffset() <= endOffset) continue;
                    return false;
                }
            }
            sb.append(e.getText());
            List<XPathVariableReference> references = RefactoringUtil.collectVariableReferences(e);
            for (XPathVariableReference reference : references) {
                XPathVariable variable = reference.resolve();
                if (variable instanceof XsltVariable) {
                    XmlTag var = ((XsltVariable)variable).getTag();
                    if (var.getTextRange().getStartOffset() >= startOffset || XsltCodeInsightUtil.getTemplateTag(variable, false) == null) continue;
                    vars.add(variable.getName());
                    continue;
                }
                if (variable != null) continue;
                vars.add(reference.getReferencedName());
            }
            if (e == end) break;
        }
        sb.append("\n");
        String string = s = newName == null ? Messages.showInputDialog((Project)start.getProject(), (String)"Template Name: ", (String)this.getRefactoringName(), (Icon)Messages.getQuestionIcon()) : newName;
        if (s != null) {
            WriteCommandAction.runWriteCommandAction((Project)start.getProject(), () -> {
                PsiFile containingFile = start.getContainingFile();
                XmlTag templateTag = parentScope.createChildTag("template", "http://www.w3.org/1999/XSL/Transform", sb.toString(), false);
                templateTag.setAttribute("name", s);
                XmlText dummy = XmlElementFactory.getInstance((Project)start.getProject()).createDisplayText(" ");
                PsiElement outerParent = outerTemplate.getParent();
                PsiElement element = outerParent.addAfter((PsiElement)dummy, (PsiElement)outerTemplate);
                templateTag = (XmlTag)outerParent.addAfter((PsiElement)templateTag, element);
                TextRange adjust = templateTag.getTextRange();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)start.getProject());
                Document doc = psiDocumentManager.getDocument(containingFile);
                assert (doc != null);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(doc);
                CodeStyleManager.getInstance((Project)start.getManager().getProject()).adjustLineIndent(containingFile, adjust);
                PsiElement parent = start.getParent();
                XmlTag callTag = parentScope.createChildTag("call-template", "http://www.w3.org/1999/XSL/Transform", null, false);
                callTag.setAttribute("name", s);
                if (start instanceof XmlToken && ((XmlToken)start).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
                    assert (start == end);
                    callTag = (XmlTag)start.replace((PsiElement)callTag);
                } else {
                    callTag = (XmlTag)parent.addBefore((PsiElement)callTag, start);
                    parent.deleteChildRange(start, end);
                }
                for (String var : vars) {
                    XmlTag param = templateTag.createChildTag("param", "http://www.w3.org/1999/XSL/Transform", null, false);
                    param.setAttribute("name", var);
                    RefactoringUtil.addParameter(templateTag, param);
                    XmlTag arg = RefactoringUtil.addWithParam(callTag);
                    arg.setAttribute("name", var);
                    arg.setAttribute("select", "$" + var);
                }
            });
        }
        return true;
    }

    @Override
    protected boolean actionPerformedImpl(PsiFile file, Editor editor, XmlAttribute context, int offset) {
        return false;
    }

    @Override
    @Nullable
    public String getErrorMessage(Editor editor, PsiFile file, XmlAttribute context) {
        if (!editor.getSelectionModel().hasSelection()) {
            return "Please select the code that should be extracted.";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/xpath/xslt/refactoring/extractTemplate/XsltExtractTemplateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

