/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.TracingData;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
extends FileBasedIndexExtension<Integer, IntArrayList> {
    static boolean ourEnabled = SystemProperties.getBooleanProperty((String)"idea.enable.duplicates.online.calculation", (boolean)true);
    static final boolean ourEnabledLightProfiles = true;
    private static boolean ourEnabledOldProfiles = false;
    @NonNls
    public static final ID<Integer, IntArrayList> NAME = ID.create((String)"DuplicatesIndex");
    private static final int myBaseVersion = 25;
    private final FileBasedIndex.InputFilter myInputFilter = file -> {
        if (!ourEnabled || !file.isInLocalFileSystem()) {
            return false;
        }
        DuplicatesProfile duplicatesProfile = DuplicatesIndex.findDuplicatesProfile(file.getFileType());
        if (duplicatesProfile instanceof LightDuplicateProfile) {
            return ((LightDuplicateProfile)((Object)duplicatesProfile)).acceptsFile(file);
        }
        return duplicatesProfile != null;
    };
    private final DataExternalizer<IntArrayList> myValueExternalizer = new DataExternalizer<IntArrayList>(){

        public void save(@NotNull DataOutput out, IntArrayList list) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            if (list.size() == 2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getInt(0));
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getInt(1));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-list.size()));
                int prev = 0;
                int len = list.size();
                for (int i = 0; i < len; i += 2) {
                    int value = list.getInt(i);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)(value - prev));
                    prev = value;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getInt(i + 1));
                }
            }
        }

        public IntArrayList read(@NotNull DataInput in) throws IOException {
            int capacityOrValue;
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((capacityOrValue = DataInputOutputUtil.readINT((DataInput)in)) >= 0) {
                IntArrayList list = new IntArrayList(2);
                list.add(capacityOrValue);
                list.add(DataInputOutputUtil.readINT((DataInput)in));
                return list;
            }
            IntArrayList list = new IntArrayList(capacityOrValue);
            int prev = 0;
            for (capacityOrValue = -capacityOrValue; capacityOrValue > 0; capacityOrValue -= 2) {
                int value = DataInputOutputUtil.readINT((DataInput)in) + prev;
                list.add(value);
                prev = value;
                list.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DataIndexer<Integer, IntArrayList, FileContent> myIndexer = new DataIndexer<Integer, IntArrayList, FileContent>(){

        @NotNull
        public Int2ObjectMap<IntArrayList> map(@NotNull FileContent inputData) {
            PsiDependentFileContent fileContent;
            FileType type;
            DuplicatesProfile profile;
            block9: {
                Int2ObjectOpenHashMap int2ObjectOpenHashMap;
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((profile = DuplicatesIndex.findDuplicatesProfile(type = inputData.getFileType())) == null || !profile.acceptsContentForIndexing(inputData)) {
                    Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                    if (int2ObjectMap == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return int2ObjectMap;
                }
                try {
                    fileContent = (PsiDependentFileContent)inputData;
                    if (!(profile instanceof LightDuplicateProfile)) break block9;
                    final Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
                    LighterAST ast = fileContent.getLighterAST();
                    ((LightDuplicateProfile)((Object)profile)).process(ast, new LightDuplicateProfile.Callback(){

                        @Override
                        public void process(int hash, int hash2, @NotNull LighterAST ast, LighterASTNode ... nodes) {
                            IntArrayList list;
                            if (ast == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (nodes == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if ((list = (IntArrayList)result.get(hash)) == null) {
                                list = new IntArrayList(2);
                                result.put(hash, (Object)list);
                            }
                            list.add(nodes[0].getStartOffset());
                            list.add(hash2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "ast";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "nodes";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/dupLocator/index/DuplicatesIndex$2$1";
                            objectArray[2] = "process";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    int2ObjectOpenHashMap = result;
                }
                catch (StackOverflowError ae) {
                    Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                    if (int2ObjectMap == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return int2ObjectMap;
                }
                if (int2ObjectOpenHashMap == null) {
                    2.$$$reportNull$$$0(2);
                }
                return int2ObjectOpenHashMap;
            }
            MyFragmentsCollector collector = new MyFragmentsCollector(profile, ((LanguageFileType)type).getLanguage());
            DuplocateVisitor visitor = profile.createVisitor(collector, true);
            visitor.visitNode((PsiElement)fileContent.getPsiFile());
            Int2ObjectOpenHashMap<IntArrayList> int2ObjectOpenHashMap = collector.getMap();
            if (int2ObjectOpenHashMap == null) {
                2.$$$reportNull$$$0(3);
            }
            return int2ObjectOpenHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/index/DuplicatesIndex$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesIndex$2";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final TracingData myTracingData = null;

    @Nullable
    public static DuplicatesProfile findDuplicatesProfile(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        DuplicatesProfile profile = DuplicatesProfile.findProfileForLanguage(language);
        return profile != null && (ourEnabledOldProfiles && profile.supportDuplicatesIndex() || profile instanceof LightDuplicateProfile) ? profile : null;
    }

    public int getVersion() {
        return 25 + (ourEnabled ? 255 : 0) + 128 + (ourEnabledOldProfiles ? 33 : 0);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<Integer, IntArrayList> getName() {
        ID<Integer, IntArrayList> iD = NAME;
        if (iD == null) {
            DuplicatesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, IntArrayList, FileContent> getIndexer() {
        DataIndexer<Integer, IntArrayList, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            DuplicatesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<IntArrayList> getValueExternalizer() {
        DataExternalizer<IntArrayList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            DuplicatesIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            DuplicatesIndex.$$$reportNull$$$0(3);
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            DuplicatesIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    static boolean isIndexedFragment(@Nullable PsiFragment frag, int cost, DuplicatesProfile profile, DuplocatorState duplocatorState) {
        if (frag == null) {
            return false;
        }
        return profile.shouldPutInIndex(frag, cost, duplocatorState);
    }

    public static boolean setEnabled(boolean value) {
        boolean old = ourEnabled;
        ourEnabled = value;
        return old;
    }

    public static boolean setEnabledOldProfiles(boolean value) {
        boolean old = ourEnabledOldProfiles;
        ourEnabledOldProfiles = value;
        return old;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/dupLocator/index/DuplicatesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class MyFragmentsCollector
    implements FragmentsCollector {
        private final Int2ObjectOpenHashMap<IntArrayList> myMap = new Int2ObjectOpenHashMap();
        private final DuplicatesProfile myProfile;
        private final DuplocatorState myDuplocatorState;

        MyFragmentsCollector(DuplicatesProfile profile, Language language) {
            this.myProfile = profile;
            this.myDuplocatorState = profile.getDuplocatorState(language);
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            IntArrayList list;
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, this.myProfile, this.myDuplocatorState)) {
                return;
            }
            if (myTracingData != null) {
                myTracingData.record(hash, cost, frag);
            }
            if ((list = (IntArrayList)this.myMap.get(hash)) == null) {
                list = new IntArrayList();
                this.myMap.put(hash, (Object)list);
            }
            list.add(frag.getStartOffset());
            list.add(0);
        }

        public Int2ObjectOpenHashMap<IntArrayList> getMap() {
            return this.myMap;
        }
    }
}

