/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00072\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0015J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0018R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;", "Ljava/io/Closeable;", "()V", "contentHashEnumerator", "Lcom/intellij/util/hash/ContentHashEnumerator;", "handles", "", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "lock", "Ljava/util/concurrent/locks/Lock;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "state", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$State;", "close", "", "createHashEnumeratorHandle", "requestorIndexId", "Lcom/intellij/util/indexing/ID;", "flush", "initialize", "", "Companion", "HashEnumeratorHandle", "State", "intellij.platform.lang.impl"})
public final class SnapshotHashEnumeratorService
implements Closeable {
    @NotNull
    private final Logger log;
    private volatile State state;
    private volatile ContentHashEnumerator contentHashEnumerator;
    private final Set<HashEnumeratorHandle> handles;
    private final Lock lock;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initialize() throws IOException {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            if (this.state == State.CLOSED) {
                File hashEnumeratorFile = new File(IndexInfrastructure.getPersistentIndexRoot(), "textContentHashes");
                this.state = State.OPEN;
                Object object = IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<T, IOException>(hashEnumeratorFile){
                    final /* synthetic */ File $hashEnumeratorFile;

                    @NotNull
                    public final ContentHashEnumerator compute() {
                        return new ContentHashEnumerator(this.$hashEnumeratorFile.toPath());
                    }
                    {
                        this.$hashEnumeratorFile = file2;
                    }
                }, (Runnable)new Runnable(hashEnumeratorFile, this){
                    final /* synthetic */ File $hashEnumeratorFile;
                    final /* synthetic */ SnapshotHashEnumeratorService this$0;
                    {
                        this.$hashEnumeratorFile = file2;
                        this.this$0 = snapshotHashEnumeratorService;
                    }

                    public final void run() {
                        IOUtil.deleteAllFilesStartingWith((File)this.$hashEnumeratorFile);
                        SnapshotHashEnumeratorService.access$setState$p(this.this$0, State.OPEN_AND_CLEAN);
                    }
                });
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                this.contentHashEnumerator = (ContentHashEnumerator)((Object)object);
            }
            this.log.assertTrue(this.state != State.CLOSED);
            boolean bl3 = this.state == State.OPEN;
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            if (this.state == State.OPEN) {
                ContentHashEnumerator contentHashEnumerator = this.contentHashEnumerator;
                if (contentHashEnumerator == null) {
                    Intrinsics.throwNpe();
                }
                contentHashEnumerator.close();
                this.state = State.CLOSED;
                this.log.assertTrue(this.handles.isEmpty(), (Object)("enumerator handles are still held: " + this.handles));
                this.handles.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            if (this.state == State.OPEN) {
                ContentHashEnumerator contentHashEnumerator = this.contentHashEnumerator;
                if (contentHashEnumerator == null) {
                    Intrinsics.throwNpe();
                }
                contentHashEnumerator.force();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashEnumeratorHandle createHashEnumeratorHandle(@NotNull ID<?, ?> requestorIndexId) {
        Intrinsics.checkParameterIsNotNull(requestorIndexId, (String)"requestorIndexId");
        HashEnumeratorHandle handle2 = new HashEnumeratorHandle(this, requestorIndexId){
            final /* synthetic */ SnapshotHashEnumeratorService this$0;
            final /* synthetic */ ID $requestorIndexId;

            public int enumerateHash(@NotNull byte[] digest) {
                Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
                ContentHashEnumerator contentHashEnumerator = SnapshotHashEnumeratorService.access$getContentHashEnumerator$p(this.this$0);
                if (contentHashEnumerator == null) {
                    Intrinsics.throwNpe();
                }
                return contentHashEnumerator.enumerate(digest);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void release() {
                Lock lock = SnapshotHashEnumeratorService.access$getLock$p(this.this$0);
                boolean bl = false;
                lock.lock();
                try {
                    boolean bl2 = false;
                    SnapshotHashEnumeratorService.access$getHandles$p(this.this$0).remove(this);
                    boolean bl3 = this.this$0.getLog().assertTrue(SnapshotHashEnumeratorService.access$getState$p(this.this$0) != State.CLOSED, (Object)"handle is released for closed enumerator");
                }
                finally {
                    lock.unlock();
                }
            }

            @NotNull
            public String toString() {
                return "handle for " + this.$requestorIndexId.getName();
            }
            {
                this.this$0 = $outer;
                this.$requestorIndexId = $captured_local_variable$1;
            }
        };
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            boolean bl3 = this.handles.add(handle2);
        }
        finally {
            lock.unlock();
        }
        return handle2;
    }

    public SnapshotHashEnumeratorService() {
        Logger logger;
        SnapshotHashEnumeratorService snapshotHashEnumeratorService = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SnapshotHashEnumeratorService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        snapshotHashEnumeratorService.log = logger = logger2;
        this.state = State.CLOSED;
        this.handles = (Set)new THashSet();
        this.lock = new ReentrantLock();
        FlushingDaemon.everyFiveSeconds(new Runnable(){

            @Override
            public final void run() {
                this.flush();
            }
        });
    }

    public static final /* synthetic */ State access$getState$p(SnapshotHashEnumeratorService $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(SnapshotHashEnumeratorService $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ ContentHashEnumerator access$getContentHashEnumerator$p(SnapshotHashEnumeratorService $this) {
        return $this.contentHashEnumerator;
    }

    public static final /* synthetic */ void access$setContentHashEnumerator$p(SnapshotHashEnumeratorService $this, ContentHashEnumerator contentHashEnumerator) {
        $this.contentHashEnumerator = contentHashEnumerator;
    }

    public static final /* synthetic */ Lock access$getLock$p(SnapshotHashEnumeratorService $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Set access$getHandles$p(SnapshotHashEnumeratorService $this) {
        return $this.handles;
    }

    @JvmStatic
    @NotNull
    public static final SnapshotHashEnumeratorService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$State;", "", "(Ljava/lang/String;I)V", "OPEN", "OPEN_AND_CLEAN", "CLOSED", "intellij.platform.lang.impl"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State OPEN;
        public static final /* enum */ State OPEN_AND_CLEAN;
        public static final /* enum */ State CLOSED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = OPEN = new State();
            stateArray[1] = OPEN_AND_CLEAN = new State();
            stateArray[2] = CLOSED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "", "enumerateHash", "", "digest", "", "release", "", "intellij.platform.lang.impl"})
    public static interface HashEnumeratorHandle {
        public int enumerateHash(@NotNull byte[] var1) throws IOException;

        public void release();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$Companion;", "", "()V", "getInstance", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SnapshotHashEnumeratorService getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(SnapshotHashEnumeratorService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (SnapshotHashEnumeratorService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

