/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;

public class BegTableUI
extends BasicTableUI {
    private final KeyAdapter myAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27 && BegTableUI.this.table.isEditing()) {
                e.consume();
                BegTableUI.this.table.removeEditor();
                if (e.getSource() != BegTableUI.this.table) {
                    ((JComponent)e.getSource()).removeKeyListener(this);
                }
            }
        }
    };
    @NonNls
    public static final String START_EDITING_ACTION_KEY = "startEditing";

    public static ComponentUI createUI(JComponent c) {
        return new BegTableUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.getActionMap().put(START_EDITING_ACTION_KEY, new StartEditingAction());
        c.getInputMap(1).put(KeyStroke.getKeyStroke("pressed ESCAPE"), "cancel");
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        int rowHeight = UIManager.getInt("Table.rowHeight");
        if (rowHeight > 0) {
            LookAndFeel.installProperty(this.table, "rowHeight", rowHeight);
        }
    }

    @Override
    protected KeyListener createKeyListener() {
        return this.myAdapter;
    }

    private class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            if (!table.hasFocus()) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)table, true));
                return;
            }
            ListSelectionModel rsm = table.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            ListSelectionModel csm = table.getColumnModel().getSelectionModel();
            int anchorColumn = csm.getAnchorSelectionIndex();
            table.editCellAt(anchorRow, anchorColumn, e);
            Component editorComp = table.getEditorComponent();
            if (editorComp != null) {
                editorComp.addKeyListener(BegTableUI.this.myAdapter);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(editorComp, true));
            }
        }
    }
}

