/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabbedContentTabLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.BaseButtonBehavior;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TabContentLayout
extends ContentLayout
implements MorePopupAware {
    static final int MORE_ICON_BORDER = 6;
    public static final int TAB_LAYOUT_START = 4;
    LayoutData myLastLayout;
    ArrayList<ContentTabLabel> myTabs;
    final Map<Content, ContentTabLabel> myContent2Tabs;
    List<AnAction> myDoubleClickActions;
    private final JBTabPainter tabPainter;

    TabContentLayout(@NotNull ToolWindowContentUi ui) {
        if (ui == null) {
            TabContentLayout.$$$reportNull$$$0(0);
        }
        super(ui);
        this.myTabs = new ArrayList();
        this.myContent2Tabs = new HashMap<Content, ContentTabLabel>();
        this.myDoubleClickActions = new ArrayList<AnAction>();
        this.tabPainter = JBTabPainter.getTOOL_WINDOW();
        new BaseButtonBehavior(this.myUi.getTabComponent()){

            protected void execute(MouseEvent e) {
                if (!TabContentLayout.this.myUi.isCurrent(TabContentLayout.this)) {
                    return;
                }
                Rectangle moreRect = TabContentLayout.this.getMoreRect();
                if (moreRect != null) {
                    TabContentLayout.this.showMorePopup();
                }
            }
        };
    }

    @Override
    public void init(@NotNull ContentManager contentManager2) {
        if (contentManager2 == null) {
            TabContentLayout.$$$reportNull$$$0(1);
        }
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false){

            @Override
            protected boolean allowEngravement() {
                return this.myUi.window.isActive();
            }
        };
        for (int i2 = 0; i2 < contentManager2.getContentCount(); ++i2) {
            this.contentAdded(new ContentManagerEvent((Object)this, contentManager2.getContent(i2), i2));
        }
    }

    @Override
    public void reset() {
        this.myTabs.clear();
        this.myContent2Tabs.clear();
        this.myIdLabel = null;
    }

    void setTabDoubleClickActions(@NotNull List<AnAction> actions) {
        if (actions == null) {
            TabContentLayout.$$$reportNull$$$0(2);
        }
        this.myDoubleClickActions = actions;
    }

    private Rectangle getMoreRect() {
        if (this.myLastLayout == null) {
            return null;
        }
        return this.myLastLayout.moreRect;
    }

    public void dropCaches() {
        this.myLastLayout = null;
    }

    public boolean canShowMorePopup() {
        return this.getMoreRect() != null;
    }

    public void showMorePopup() {
        Rectangle rect = this.getMoreRect();
        if (rect == null) {
            return;
        }
        List tabs = ContainerUtil.filter(this.myTabs, this.myLastLayout.toDrop::contains);
        List contentsToShow = ContainerUtil.map((Collection)tabs, ContentTabLabel::getContent);
        SelectContentStep step = new SelectContentStep(contentsToShow);
        RelativePoint point = new RelativePoint((Component)this.myUi.getTabComponent(), new Point(rect.x, rect.y + rect.height));
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).show(point);
    }

    @Override
    public void layout() {
        boolean toolbarUpdateNeeded;
        Rectangle bounds2 = this.myUi.getTabComponent().getBounds();
        ContentManager manager = this.myUi.getContentManager();
        LayoutData data2 = new LayoutData(this.myUi);
        data2.eachX = 4;
        data2.eachY = 0;
        if (this.isIdVisible()) {
            this.myIdLabel.setBounds(data2.eachX, data2.eachY, this.myIdLabel.getPreferredSize().width, bounds2.height);
            data2.eachX += this.myIdLabel.getPreferredSize().width;
        }
        int tabsStart = data2.eachX;
        if (manager.getContentCount() == 0) {
            return;
        }
        Content selected2 = manager.getSelectedContent();
        if (selected2 == null) {
            selected2 = manager.getContents()[0];
        }
        if (this.myLastLayout != null && this.myLastLayout.layoutSize.equals(bounds2.getSize()) && this.myLastLayout.contentCount == manager.getContentCount() && ContainerUtil.all(this.myTabs, Component::isValid)) {
            for (ContentTabLabel each : this.myTabs) {
                if (each.getContent() != selected2 || each.getBounds().width == 0) continue;
                data2 = this.myLastLayout;
                data2.fullLayout = false;
            }
        }
        if (data2.fullLayout) {
            for (ContentTabLabel eachTab : this.myTabs) {
                Dimension eachSize = eachTab.getPreferredSize();
                data2.requiredWidth += eachSize.width;
                data2.toLayout.add(eachTab);
            }
            data2.toFitWidth = bounds2.getSize().width - data2.eachX;
            ContentTabLabel selectedTab = this.myContent2Tabs.get(selected2);
            while (data2.requiredWidth > data2.toFitWidth && data2.toLayout.size() > 1) {
                if (data2.toLayout.get(0) != selectedTab) {
                    TabContentLayout.dropTab(data2, data2.toLayout.remove(0));
                    continue;
                }
                if (data2.toLayout.get(data2.toLayout.size() - 1) == selectedTab) break;
                TabContentLayout.dropTab(data2, data2.toLayout.remove(data2.toLayout.size() - 1));
            }
            boolean reachedBounds = false;
            data2.moreRect = null;
            boolean toDrawTabs = this.isToDrawTabs();
            for (ContentTabLabel each : data2.toLayout) {
                if (!toDrawTabs) {
                    each.setBounds(0, 0, 0, 0);
                    continue;
                }
                data2.eachY = 0;
                Dimension eachSize = each.getPreferredSize();
                if (data2.eachX + eachSize.width < data2.toFitWidth + tabsStart) {
                    each.setBounds(data2.eachX, data2.eachY, eachSize.width, bounds2.height - data2.eachY);
                    data2.eachX += eachSize.width;
                    continue;
                }
                if (!reachedBounds) {
                    int width = bounds2.width - data2.eachX;
                    each.setBounds(data2.eachX, data2.eachY, width, bounds2.height - data2.eachY);
                    data2.eachX += width;
                } else {
                    each.setBounds(0, 0, 0, 0);
                }
                reachedBounds = true;
            }
            for (ContentTabLabel each : data2.toDrop) {
                each.setBounds(0, 0, 0, 0);
            }
        }
        if (data2.toDrop.size() > 0) {
            toolbarUpdateNeeded = this.myLastLayout != null && this.myLastLayout.moreRect == null;
            data2.moreRect = new Rectangle(data2.eachX + 6, 0, 16, bounds2.height);
        } else {
            toolbarUpdateNeeded = this.myLastLayout != null && this.myLastLayout.moreRect != null;
            data2.moreRect = null;
        }
        Rectangle moreRect = data2.moreRect == null ? null : new Rectangle(data2.eachX, 0, 22, bounds2.height);
        this.myUi.isResizableArea = p -> moreRect == null || !moreRect.contains((Point)p);
        this.myLastLayout = data2;
        if (toolbarUpdateNeeded) {
            ActionToolbarImpl.updateAllToolbarsImmediately();
        }
    }

    @Override
    public int getMinimumWidth() {
        ContentManager contentManager2;
        Content selected2;
        int result2 = 0;
        if (this.myIdLabel != null) {
            result2 += this.myIdLabel.getPreferredSize().width;
            Insets insets = this.myIdLabel.getInsets();
            if (insets != null) {
                result2 += insets.left + insets.right;
            }
        }
        if ((selected2 = (contentManager2 = this.myUi.getContentManager()).getSelectedContent()) == null && contentManager2.getContents().length > 0) {
            selected2 = contentManager2.getContents()[0];
        }
        return result2 += selected2 != null ? this.myContent2Tabs.get((Object)selected2).getMinimumSize().width : 0;
    }

    static void dropTab(LayoutData data2, ContentTabLabel toDropLabel) {
        data2.requiredWidth -= toDropLabel.getPreferredSize().width + 1;
        data2.toDrop.add(toDropLabel);
    }

    boolean isToDrawTabs() {
        int size = this.myTabs.size();
        if (size > 1) {
            return true;
        }
        if (size == 1) {
            return !StringUtil.isEmpty((String)this.myTabs.get(0).getContent().getToolwindowTitle());
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawTabs()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        for (ContentTabLabel each : this.myTabs) {
            int borderThickness = JBUIScale.scale((int)1);
            Rectangle r = each.getBounds();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (each.isSelected()) {
                this.tabPainter.paintSelectedTab(JBTabsPosition.top, g2d, r, borderThickness, null, this.myUi.window.isActive(), each.isHovered());
                continue;
            }
            this.tabPainter.paintTab(JBTabsPosition.top, g2d, r, borderThickness, null, this.myUi.window.isActive(), each.isHovered());
        }
        g2d.dispose();
    }

    @Override
    public void update() {
        for (ContentTabLabel each : this.myTabs) {
            each.update();
        }
        this.updateIdLabel(this.myIdLabel);
    }

    @Override
    public void rebuild() {
        this.myUi.getTabComponent().removeAll();
        this.myUi.getTabComponent().add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi, true);
        for (ContentTabLabel each : this.myTabs) {
            this.myUi.getTabComponent().add(each);
            ToolWindowContentUi.initMouseListeners(each, this.myUi, false);
        }
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
        Content content2 = event.getContent();
        ContentTabLabel tab = content2 instanceof TabbedContent ? new TabbedContentTabLabel((TabbedContent)content2, this) : new ContentTabLabel(content2, this);
        this.myTabs.add(event.getIndex(), tab);
        this.myContent2Tabs.put(content2, tab);
        DnDTarget target2 = TabContentLayout.getDnDTarget(content2);
        if (target2 != null) {
            DnDSupport.createBuilder((JComponent)tab).setDropHandler((DnDDropHandler)target2).setTargetChecker((DnDTargetChecker)target2).setCleanUpOnLeaveCallback(() -> target2.cleanUpOnLeave()).install();
        }
    }

    @Nullable
    private static DnDTarget getDnDTarget(Content content2) {
        DnDTarget target2 = (DnDTarget)content2.getUserData(Content.TAB_DND_TARGET_KEY);
        if (target2 != null) {
            return target2;
        }
        return (DnDTarget)ObjectUtils.tryCast((Object)content2, DnDTarget.class);
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
        ContentTabLabel tab = this.myContent2Tabs.get(event.getContent());
        if (tab != null) {
            this.myTabs.remove(tab);
            this.myContent2Tabs.remove(event.getContent());
        }
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        Content selected2 = this.myUi.getContentManager().getSelectedContent();
        if (selected2 != null) {
            ContentTabLabel tab = this.myContent2Tabs.get(selected2);
            listPopup.showUnderneathOf((Component)tab);
        } else {
            listPopup.showUnderneathOf((Component)this.myIdLabel);
        }
    }

    @Override
    public @NlsActions.ActionText String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    @Override
    public @NlsActions.ActionText String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    @Override
    public @NlsActions.ActionText String getPreviousContentActionName() {
        return UIBundle.message((String)"tabbed.pane.select.previous.tab", (Object[])new Object[0]);
    }

    @Override
    public @NlsActions.ActionText String getNextContentActionName() {
        return UIBundle.message((String)"tabbed.pane.select.next.tab", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/content/TabContentLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTabDoubleClickActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LayoutData {
        int toFitWidth;
        int requiredWidth;
        Dimension layoutSize;
        boolean fullLayout = true;
        ArrayList<ContentTabLabel> toLayout = new ArrayList();
        Collection<ContentTabLabel> toDrop = new HashSet<ContentTabLabel>();
        Rectangle moreRect;
        public int eachX;
        public int eachY;
        public int contentCount;

        LayoutData(ToolWindowContentUi ui) {
            this.layoutSize = ui.getTabComponent().getSize();
            this.contentCount = ui.getContentManager().getContentCount();
        }
    }
}

