/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.FontFallbackIterator;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.FontMapper;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.TokenType;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SyntaxInfoBuilder {
    private SyntaxInfoBuilder() {
    }

    @NotNull
    static MyMarkupIterator createMarkupIterator(@NotNull EditorHighlighter highlighter, @NotNull CharSequence text, @NotNull EditorColorsScheme schemeToUse, @Nullable MarkupModel markupModel, int startOffsetToUse, int endOffset) {
        if (highlighter == null) {
            SyntaxInfoBuilder.$$$reportNull$$$0(0);
        }
        if (text == null) {
            SyntaxInfoBuilder.$$$reportNull$$$0(1);
        }
        if (schemeToUse == null) {
            SyntaxInfoBuilder.$$$reportNull$$$0(2);
        }
        CompositeRangeIterator iterator2 = new CompositeRangeIterator(schemeToUse, new HighlighterRangeIterator(highlighter, startOffsetToUse, endOffset), new MarkupModelRangeIterator(markupModel, schemeToUse, startOffsetToUse, endOffset));
        return new MyMarkupIterator(text, iterator2, schemeToUse);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "highlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "schemeToUse";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder";
        objectArray[2] = "createMarkupIterator";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Context {
        private final SyntaxInfo.Builder builder;
        @NotNull
        private final CharSequence myText;
        @NotNull
        private final Color myDefaultForeground;
        @NotNull
        private final Color myDefaultBackground;
        @Nullable
        private Color myBackground;
        @Nullable
        private Color myForeground;
        @Nullable
        private String myFontFamilyName;
        private final int myIndentSymbolsToStrip;
        private int myFontStyle;
        private int myStartOffset;
        private int myOffsetShift;
        private int myIndentSymbolsToStripAtCurrentLine;

        Context(@NotNull CharSequence charSequence, @NotNull EditorColorsScheme scheme, int indentSymbolsToStrip) {
            if (charSequence == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (scheme == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.myFontStyle = -1;
            this.myStartOffset = -1;
            this.myOffsetShift = 0;
            this.myText = charSequence;
            this.myDefaultForeground = scheme.getDefaultForeground();
            this.myDefaultBackground = scheme.getDefaultBackground();
            int javaFontSize = scheme.getEditorFontSize();
            float fontSize = SystemInfo.isMac || ApplicationManager.getApplication().isHeadlessEnvironment() ? (float)javaFontSize : (float)javaFontSize * 0.75f / UISettings.getDefFontScale();
            this.builder = new SyntaxInfo.Builder(this.myDefaultForeground, this.myDefaultBackground, fontSize);
            this.myIndentSymbolsToStrip = indentSymbolsToStrip;
        }

        public void reset(int offsetShiftDelta) {
            this.myStartOffset = -1;
            this.myOffsetShift += offsetShiftDelta;
            this.myIndentSymbolsToStripAtCurrentLine = 0;
        }

        public void iterate(MyMarkupIterator iterator2, int endOffset) {
            while (!iterator2.atEnd()) {
                iterator2.advance();
                int startOffset = iterator2.getStartOffset();
                if (startOffset >= endOffset) break;
                if (this.myStartOffset < 0) {
                    this.myStartOffset = startOffset;
                }
                boolean whiteSpacesOnly = CharArrayUtil.isEmptyOrSpaces((CharSequence)this.myText, (int)startOffset, (int)iterator2.getEndOffset());
                this.processBackground(startOffset, iterator2.getBackgroundColor());
                if (whiteSpacesOnly) continue;
                this.processForeground(startOffset, iterator2.getForegroundColor());
                this.processFontFamilyName(startOffset, iterator2.getFontFamilyName());
                this.processFontStyle(startOffset, iterator2.getFontStyle());
            }
            this.addTextIfPossible(endOffset);
        }

        private void processFontStyle(int startOffset, int fontStyle) {
            if (fontStyle != this.myFontStyle) {
                this.addTextIfPossible(startOffset);
                this.builder.addFontStyle(fontStyle);
                this.myFontStyle = fontStyle;
            }
        }

        private void processFontFamilyName(int startOffset, String fontName) {
            String fontFamilyName = FontMapper.getPhysicalFontName(fontName);
            if (!fontFamilyName.equals(this.myFontFamilyName)) {
                this.addTextIfPossible(startOffset);
                this.builder.addFontFamilyName(fontFamilyName);
                this.myFontFamilyName = fontFamilyName;
            }
        }

        private void processForeground(int startOffset, Color foreground) {
            if (this.myForeground == null && foreground != null) {
                this.addTextIfPossible(startOffset);
                this.myForeground = foreground;
                this.builder.addForeground(foreground);
            } else if (this.myForeground != null) {
                Color c;
                Color color = c = foreground == null ? this.myDefaultForeground : foreground;
                if (!this.myForeground.equals(c)) {
                    this.addTextIfPossible(startOffset);
                    this.builder.addForeground(c);
                    this.myForeground = c;
                }
            }
        }

        private void processBackground(int startOffset, Color background) {
            if (this.myBackground == null && background != null && !this.myDefaultBackground.equals(background)) {
                this.addTextIfPossible(startOffset);
                this.myBackground = background;
                this.builder.addBackground(background);
            } else if (this.myBackground != null) {
                Color c;
                Color color = c = background == null ? this.myDefaultBackground : background;
                if (!this.myBackground.equals(c)) {
                    this.addTextIfPossible(startOffset);
                    this.builder.addBackground(c);
                    this.myBackground = c;
                }
            }
        }

        private void addTextIfPossible(int endOffset) {
            if (endOffset <= this.myStartOffset) {
                return;
            }
            block5: for (int i2 = this.myStartOffset; i2 < endOffset; ++i2) {
                char c = this.myText.charAt(i2);
                switch (c) {
                    case '\r': {
                        if (i2 + 1 < this.myText.length() && this.myText.charAt(i2 + 1) == '\n') {
                            this.myIndentSymbolsToStripAtCurrentLine = this.myIndentSymbolsToStrip;
                            this.builder.addText(this.myStartOffset + this.myOffsetShift, i2 + this.myOffsetShift + 1);
                            this.myStartOffset = i2 + 2;
                            --this.myOffsetShift;
                            ++i2;
                            continue block5;
                        }
                    }
                    case '\n': {
                        this.myIndentSymbolsToStripAtCurrentLine = this.myIndentSymbolsToStrip;
                        this.builder.addText(this.myStartOffset + this.myOffsetShift, i2 + this.myOffsetShift + 1);
                        this.myStartOffset = i2 + 1;
                        continue block5;
                    }
                    case '\t': 
                    case ' ': {
                        if (this.myIndentSymbolsToStripAtCurrentLine > 0) {
                            --this.myIndentSymbolsToStripAtCurrentLine;
                            ++this.myStartOffset;
                            continue block5;
                        }
                    }
                    default: {
                        this.myIndentSymbolsToStripAtCurrentLine = 0;
                    }
                }
            }
            if (this.myStartOffset < endOffset) {
                this.builder.addText(this.myStartOffset + this.myOffsetShift, endOffset + this.myOffsetShift);
                this.myStartOffset = endOffset;
            }
        }

        void addCharacter(int position) {
            this.builder.addText(position + this.myOffsetShift, position + this.myOffsetShift + 1);
        }

        @NotNull
        public SyntaxInfo finish() {
            SyntaxInfo syntaxInfo = this.builder.build();
            if (syntaxInfo == null) {
                Context.$$$reportNull$$$0(2);
            }
            return syntaxInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charSequence";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder$Context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finish";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SegmentIterator {
        private final FontFallbackIterator myIterator = new FontFallbackIterator();
        private final CharSequence myCharSequence;
        private int myEndOffset;
        private boolean myAdvanceCalled;

        private SegmentIterator(CharSequence charSequence, FontPreferences fontPreferences) {
            this.myCharSequence = charSequence;
            this.myIterator.setPreferredFonts(fontPreferences);
        }

        public void reset(int startOffset, int endOffset, int fontStyle) {
            this.myIterator.setFontStyle(fontStyle);
            this.myIterator.start(this.myCharSequence, startOffset, endOffset);
            this.myEndOffset = endOffset;
            this.myAdvanceCalled = false;
        }

        public boolean atEnd() {
            return this.myIterator.atEnd() || this.myIterator.getEnd() == this.myEndOffset;
        }

        public void advance() {
            if (!this.myAdvanceCalled) {
                this.myAdvanceCalled = true;
                return;
            }
            this.myIterator.advance();
        }

        public int getCurrentStartOffset() {
            return this.myIterator.getStart();
        }

        public int getCurrentEndOffset() {
            return this.myIterator.getEnd();
        }

        public String getCurrentFontFamilyName() {
            return this.myIterator.getFont().getFamily();
        }
    }

    static class HighlighterRangeIterator
    implements RangeIterator {
        private static final TextAttributes EMPTY_ATTRIBUTES = new TextAttributes();
        private final EditorHighlighter myHighlighter;
        private final HighlighterIterator myIterator;
        private final int myStartOffset;
        private final int myEndOffset;
        private int myCurrentStart;
        private int myCurrentEnd;
        private TextAttributes myCurrentAttributes;

        HighlighterRangeIterator(@NotNull EditorHighlighter highlighter, int startOffset, int endOffset) {
            if (highlighter == null) {
                HighlighterRangeIterator.$$$reportNull$$$0(0);
            }
            this.myHighlighter = highlighter;
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myIterator = highlighter.createIterator(startOffset);
        }

        @Override
        public boolean atEnd() {
            return this.myIterator.atEnd() || this.getCurrentStart() >= this.myEndOffset;
        }

        private int getCurrentStart() {
            return Math.max(this.myIterator.getStart(), this.myStartOffset);
        }

        private int getCurrentEnd() {
            return Math.min(this.myIterator.getEnd(), this.myEndOffset);
        }

        @Override
        public void advance() {
            int prevEnd = this.myCurrentEnd;
            this.myCurrentStart = this.getCurrentStart();
            this.myCurrentEnd = this.getCurrentEnd();
            assert (prevEnd <= this.myCurrentStart && this.myCurrentStart <= this.myCurrentEnd) : "Unexpected range returned by highlighter: " + this.myIterator.getStart() + ":" + this.myIterator.getEnd() + ", prevEnd: " + prevEnd + ", scanned range: " + this.myStartOffset + ":" + this.myEndOffset + ", resulting range: " + this.myCurrentStart + ":" + this.myCurrentEnd + ", highlighter: " + this.myHighlighter;
            this.myCurrentAttributes = this.myIterator.getTokenType() == TokenType.BAD_CHARACTER ? EMPTY_ATTRIBUTES : this.myIterator.getTextAttributes();
            this.myIterator.advance();
        }

        @Override
        public int getRangeStart() {
            return this.myCurrentStart;
        }

        @Override
        public int getRangeEnd() {
            return this.myCurrentEnd;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return this.myCurrentAttributes;
        }

        @Override
        public void dispose() {
        }

        public String toString() {
            return "HighlighterRangeIterator[" + this.myHighlighter + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder$HighlighterRangeIterator", "<init>"));
        }
    }

    private static class MarkupModelRangeIterator
    implements RangeIterator {
        private final boolean myUnsupportedModel;
        private final int myStartOffset;
        private final int myEndOffset;
        private final EditorColorsScheme myColorsScheme;
        private final Color myDefaultForeground;
        private final Color myDefaultBackground;
        private final MarkupIterator<RangeHighlighterEx> myIterator;
        private int myCurrentStart;
        private int myCurrentEnd;
        private TextAttributes myCurrentAttributes;
        private int myNextStart;
        private int myNextEnd;
        private TextAttributes myNextAttributes;

        private MarkupModelRangeIterator(@Nullable MarkupModel markupModel, @NotNull EditorColorsScheme colorsScheme, int startOffset, int endOffset) {
            if (colorsScheme == null) {
                MarkupModelRangeIterator.$$$reportNull$$$0(0);
            }
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myColorsScheme = colorsScheme;
            this.myDefaultForeground = colorsScheme.getDefaultForeground();
            this.myDefaultBackground = colorsScheme.getDefaultBackground();
            boolean bl = this.myUnsupportedModel = !(markupModel instanceof MarkupModelEx);
            if (this.myUnsupportedModel) {
                this.myIterator = null;
                return;
            }
            this.myIterator = ((MarkupModelEx)markupModel).overlappingIterator(startOffset, endOffset);
            try {
                this.findNextSuitableRange();
            }
            catch (Error | RuntimeException e) {
                this.myIterator.dispose();
                throw e;
            }
        }

        @Override
        public boolean atEnd() {
            return this.myUnsupportedModel || this.myNextAttributes == null;
        }

        @Override
        public void advance() {
            this.myCurrentStart = this.myNextStart;
            this.myCurrentEnd = this.myNextEnd;
            this.myCurrentAttributes = this.myNextAttributes;
            this.findNextSuitableRange();
        }

        private void findNextSuitableRange() {
            this.myNextAttributes = null;
            while (this.myIterator.hasNext()) {
                RangeHighlighterEx highlighter = (RangeHighlighterEx)this.myIterator.next();
                if (highlighter == null || !highlighter.isValid() || !MarkupModelRangeIterator.isInterestedInLayer(highlighter.getLayer())) continue;
                this.myNextStart = Math.max(highlighter.getStartOffset(), this.myStartOffset);
                this.myNextEnd = Math.min(highlighter.getEndOffset(), this.myEndOffset);
                if (this.myNextStart >= this.myEndOffset) break;
                if (this.myNextStart < this.myCurrentEnd) continue;
                TextAttributes attributes = null;
                HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
                if (info != null) {
                    TextAttributesKey key = info.forcedTextAttributesKey;
                    if (key == null) {
                        HighlightInfoType type = info.type;
                        key = type.getAttributesKey();
                    }
                    attributes = this.myColorsScheme.getAttributes(key);
                }
                if (attributes == null) continue;
                Color foreground = attributes.getForegroundColor();
                Color background = attributes.getBackgroundColor();
                if (!(foreground != null && !this.myDefaultForeground.equals(foreground) || background != null && !this.myDefaultBackground.equals(background) || attributes.getFontType() != 0)) continue;
                this.myNextAttributes = attributes;
                assert (this.myNextStart <= this.myNextEnd) : "Unexpected range: " + this.myNextStart + ":" + this.myNextEnd + ", target range: " + this.myStartOffset + ":" + this.myEndOffset + ", highlighter: " + highlighter.getStartOffset() + ":" + highlighter.getEndOffset();
                break;
            }
        }

        private static boolean isInterestedInLayer(int layer) {
            return layer != 2000 && layer != 6000 && layer != 5000 && layer != 4000 && layer != 5500;
        }

        @Override
        public int getRangeStart() {
            return this.myCurrentStart;
        }

        @Override
        public int getRangeEnd() {
            return this.myCurrentEnd;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return this.myCurrentAttributes;
        }

        @Override
        public void dispose() {
            if (this.myIterator != null) {
                this.myIterator.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder$MarkupModelRangeIterator", "<init>"));
        }
    }

    static class CompositeRangeIterator
    implements RangeIterator {
        @NotNull
        private final Color myDefaultForeground;
        @NotNull
        private final Color myDefaultBackground;
        private final IteratorWrapper[] myIterators;
        private final TextAttributes myMergedAttributes;
        private int overlappingRangesCount;
        private int myCurrentStart;
        private int myCurrentEnd;
        private final Comparator<IteratorWrapper> RANGE_SORTER;

        CompositeRangeIterator(@NotNull EditorColorsScheme colorsScheme, RangeIterator ... iterators) {
            if (colorsScheme == null) {
                CompositeRangeIterator.$$$reportNull$$$0(0);
            }
            this.myMergedAttributes = new TextAttributes();
            this.RANGE_SORTER = new Comparator<IteratorWrapper>(){

                @Override
                public int compare(IteratorWrapper o1, IteratorWrapper o2) {
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    int startDiff = Math.max(o1.iterator.getRangeStart(), myCurrentEnd) - Math.max(o2.iterator.getRangeStart(), myCurrentEnd);
                    if (startDiff != 0) {
                        return startDiff;
                    }
                    return o2.order - o1.order;
                }
            };
            this.myDefaultForeground = colorsScheme.getDefaultForeground();
            this.myDefaultBackground = colorsScheme.getDefaultBackground();
            this.myIterators = new IteratorWrapper[iterators.length];
            for (int i2 = 0; i2 < iterators.length; ++i2) {
                this.myIterators[i2] = new IteratorWrapper(iterators[i2], i2);
            }
        }

        @Override
        public boolean atEnd() {
            boolean validIteratorExists = false;
            for (int i2 = 0; i2 < this.myIterators.length; ++i2) {
                RangeIterator iterator2;
                IteratorWrapper wrapper2 = this.myIterators[i2];
                if (wrapper2 == null || (iterator2 = wrapper2.iterator).atEnd() && (this.overlappingRangesCount <= 0 || i2 < this.overlappingRangesCount && iterator2.getRangeEnd() <= this.myCurrentEnd)) continue;
                validIteratorExists = true;
            }
            return !validIteratorExists;
        }

        @Override
        public void advance() {
            IteratorWrapper wrapper2;
            RangeIterator iterator2;
            IteratorWrapper wrapper3;
            int i2;
            int max = this.overlappingRangesCount == 0 ? this.myIterators.length : this.overlappingRangesCount;
            for (i2 = 0; i2 < max; ++i2) {
                wrapper3 = this.myIterators[i2];
                if (wrapper3 == null) continue;
                iterator2 = wrapper3.iterator;
                if (this.overlappingRangesCount > 0 && iterator2.getRangeEnd() > this.myCurrentEnd) continue;
                if (iterator2.atEnd()) {
                    iterator2.dispose();
                    this.myIterators[i2] = null;
                    continue;
                }
                iterator2.advance();
            }
            Arrays.sort(this.myIterators, this.RANGE_SORTER);
            this.myCurrentStart = Math.max(this.myIterators[0].iterator.getRangeStart(), this.myCurrentEnd);
            this.myCurrentEnd = Integer.MAX_VALUE;
            for (i2 = 0; i2 < this.myIterators.length && (wrapper3 = this.myIterators[i2]) != null; ++i2) {
                iterator2 = wrapper3.iterator;
                int nearestBound = iterator2.getRangeStart() > this.myCurrentStart ? iterator2.getRangeStart() : iterator2.getRangeEnd();
                this.myCurrentEnd = Math.min(this.myCurrentEnd, nearestBound);
            }
            assert (this.myCurrentStart <= this.myCurrentEnd) : "Unexpected range: " + this.myCurrentStart + ":" + this.myCurrentEnd + ", iterators: " + Arrays.toString(this.myIterators) + ", overlappingRanges: " + this.overlappingRangesCount;
            this.overlappingRangesCount = 1;
            while (this.overlappingRangesCount < this.myIterators.length && (wrapper2 = this.myIterators[this.overlappingRangesCount]) != null && wrapper2.iterator.getRangeStart() <= this.myCurrentStart) {
                ++this.overlappingRangesCount;
            }
        }

        @Override
        public int getRangeStart() {
            return this.myCurrentStart;
        }

        @Override
        public int getRangeEnd() {
            return this.myCurrentEnd;
        }

        @Override
        public TextAttributes getTextAttributes() {
            TextAttributes ta = this.myIterators[0].iterator.getTextAttributes();
            this.myMergedAttributes.setAttributes(ta.getForegroundColor(), ta.getBackgroundColor(), null, null, null, ta.getFontType());
            for (int i2 = 1; i2 < this.overlappingRangesCount; ++i2) {
                this.merge(this.myIterators[i2].iterator.getTextAttributes());
            }
            return this.myMergedAttributes;
        }

        private void merge(TextAttributes attributes) {
            Color myForeground;
            Color myBackground = this.myMergedAttributes.getBackgroundColor();
            if (myBackground == null || this.myDefaultBackground.equals(myBackground)) {
                this.myMergedAttributes.setBackgroundColor(attributes.getBackgroundColor());
            }
            if ((myForeground = this.myMergedAttributes.getForegroundColor()) == null || this.myDefaultForeground.equals(myForeground)) {
                this.myMergedAttributes.setForegroundColor(attributes.getForegroundColor());
            }
            if (this.myMergedAttributes.getFontType() == 0) {
                this.myMergedAttributes.setFontType(attributes.getFontType());
            }
        }

        @Override
        public void dispose() {
            for (IteratorWrapper wrapper2 : this.myIterators) {
                if (wrapper2 == null) continue;
                wrapper2.iterator.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder$CompositeRangeIterator", "<init>"));
        }

        private static class IteratorWrapper {
            private final RangeIterator iterator;
            private final int order;

            private IteratorWrapper(RangeIterator iterator2, int order) {
                this.iterator = iterator2;
                this.order = order;
            }

            public String toString() {
                return this.iterator + " (" + this.iterator.getRangeStart() + ":" + this.iterator.getRangeEnd() + ")";
            }
        }
    }

    static class MyMarkupIterator {
        private final SegmentIterator mySegmentIterator;
        private final RangeIterator myRangeIterator;
        private int myCurrentFontStyle;
        private Color myCurrentForegroundColor;
        private Color myCurrentBackgroundColor;

        MyMarkupIterator(@NotNull CharSequence charSequence, @NotNull RangeIterator rangeIterator, @NotNull EditorColorsScheme colorsScheme) {
            if (charSequence == null) {
                MyMarkupIterator.$$$reportNull$$$0(0);
            }
            if (rangeIterator == null) {
                MyMarkupIterator.$$$reportNull$$$0(1);
            }
            if (colorsScheme == null) {
                MyMarkupIterator.$$$reportNull$$$0(2);
            }
            this.myRangeIterator = rangeIterator;
            this.mySegmentIterator = new SegmentIterator(charSequence, colorsScheme.getFontPreferences());
        }

        public boolean atEnd() {
            return this.myRangeIterator.atEnd() && this.mySegmentIterator.atEnd();
        }

        public void advance() {
            if (this.mySegmentIterator.atEnd()) {
                this.myRangeIterator.advance();
                TextAttributes textAttributes = this.myRangeIterator.getTextAttributes();
                this.myCurrentFontStyle = textAttributes == null ? 0 : textAttributes.getFontType();
                this.myCurrentForegroundColor = textAttributes == null ? null : textAttributes.getForegroundColor();
                this.myCurrentBackgroundColor = textAttributes == null ? null : textAttributes.getBackgroundColor();
                this.mySegmentIterator.reset(this.myRangeIterator.getRangeStart(), this.myRangeIterator.getRangeEnd(), this.myCurrentFontStyle);
            }
            this.mySegmentIterator.advance();
        }

        public int getStartOffset() {
            return this.mySegmentIterator.getCurrentStartOffset();
        }

        public int getEndOffset() {
            return this.mySegmentIterator.getCurrentEndOffset();
        }

        public int getFontStyle() {
            return this.myCurrentFontStyle;
        }

        @NotNull
        public String getFontFamilyName() {
            String string = this.mySegmentIterator.getCurrentFontFamilyName();
            if (string == null) {
                MyMarkupIterator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public Color getForegroundColor() {
            return this.myCurrentForegroundColor;
        }

        @Nullable
        public Color getBackgroundColor() {
            return this.myCurrentBackgroundColor;
        }

        public void dispose() {
            this.myRangeIterator.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charSequence";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeIterator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorsScheme";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder$MyMarkupIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/richcopy/SyntaxInfoBuilder$MyMarkupIterator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFontFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface RangeIterator {
        public boolean atEnd();

        public void advance();

        public int getRangeStart();

        public int getRangeEnd();

        public TextAttributes getTextAttributes();

        public void dispose();
    }
}

