/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.laf.darcula.ui.DarculaSliderUI;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.SplitButtonAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.cellvalidators.CellTooltipManager;
import com.intellij.openapi.ui.cellvalidators.StatefulValidatingCellEditor;
import com.intellij.openapi.ui.cellvalidators.ValidatingTableCellRendererWrapper;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelTestAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ComponentPanelTestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) != null) {
            new ComponentPanelTest(project).show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction", "actionPerformed"));
    }

    private static class MyToggleAction
    extends MyAction
    implements Toggleable {
        protected boolean selected;

        private MyToggleAction(String name, Icon icon2) {
            super(name, icon2);
        }
    }

    private static class MyAction
    extends DumbAwareAction {
        private MyAction(@Nullable @NlsActions.ActionText String name, @Nullable Icon icon2) {
            super(name, null, icon2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAction.$$$reportNull$$$0(0);
            }
            System.out.println(e.getPresentation().getDescription());
        }

        public MyAction withDefaultDescription() {
            this.getTemplatePresentation().setDescription(this.getTemplateText() + " description");
            return this;
        }

        public MyAction withDescription(@Nullable @NlsActions.ActionDescription String description) {
            this.getTemplatePresentation().setDescription(description);
            return this;
        }

        public MyAction withShortCut(@NotNull String shortCut) {
            if (shortCut == null) {
                MyAction.$$$reportNull$$$0(1);
            }
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{shortCut}));
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortCut";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/ui/ComponentPanelTestAction$MyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withShortCut";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ComponentPanelTest
    extends DialogWrapper {
        private static final Set<String> ALLOWED_VALUES = ContainerUtil.set((Object[])new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "abracadabra"});
        private static final String[] STRING_VALUES = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
        private static final SimpleTextAttributes WARNING_CELL_ATTRIBUTES = new SimpleTextAttributes(8, null);
        private static final ValidationInfo NULL_VALUE_ERROR = new ValidationInfo("Null value");
        private static final ValidationInfo NAN_VALUE_ERROR = new ValidationInfo("Not a number");
        private static final String LONG_TEXT1 = "In advance of the dogs, on wide snowshoes, toiled a man. At the rear of the sled toiled a second man.<p/>On the sled, in the box, lay a third man whose toil was over, - a man whom the Wild had conquered and beaten down until he would never move nor struggle again.";
        private static final String LONG_TEXT2 = "It is not the way of the Wild to like movement.<p/>Life is an offence to it, for life is movement; and the Wild aims always to destroy movement.";
        private static final String LONG_TEXT3 = "<p>Help JetBrains improve its products by sending anonymous data about features and plugins used, hardware and software configuration, statistics on types of files, number of files per project, etc.</p><br style=\"font-size:8;\"/><p>Please note that this will not include personal data or any sensitive information, such as source code, file names, etc. The data sent complies with the <a href=\"#sometag\">JetBrains Privacy Policy</a></p>";
        private final Alarm myAlarm = new Alarm(this.getDisposable());
        private ProgressTimerRequest progressTimerRequest;
        private JTabbedPane pane;
        private final Project project;
        private static final String INNER_COMMENT = "<p>By default IntelliJ IDEA uses Gradle to build the project and run the tasks.</p><br style=\"font-size: 8;\"/><p>In a pure Java/Kotlin project, building and running by means of IDE might be faster, thanks to optimizations. Note, that the IDE doesn't support all Gradle plugins and the project might not be built correctly with some of them.</p>";
        private int counter = 5;

        private ComponentPanelTest(Project project) {
            super(project);
            this.project = project;
            this.init();
            this.setTitle("Component Panel Test Action");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            this.pane = new JBTabbedPane(1);
            this.pane.addTab("Component", this.createComponentPanel());
            this.pane.addTab("Component Grid", this.createComponentGridPanel());
            this.pane.addTab("Titled Border", this.createTiledBorderPanel());
            this.pane.addTab("Progress Grid", this.createProgressGridPanel());
            this.pane.addTab("Validators", this.createValidatorsPanel());
            this.pane.addTab("Multilines", this.createMultilinePanel());
            this.pane.addTab("JSliderUI", this.createJSliderTab());
            this.pane.addTab("ComboBox", this.createComboBoxTab());
            this.pane.addChangeListener(e -> {
                if (this.pane.getSelectedIndex() == 2) {
                    this.myAlarm.addRequest((Runnable)this.progressTimerRequest, 200, ModalityState.any());
                } else {
                    this.myAlarm.cancelRequest((Runnable)this.progressTimerRequest);
                }
            });
            BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)this.pane);
            panel2.addToTop((Component)this.createToolbar());
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new BoxLayout(southPanel, 0));
            JCheckBox enabledCB = new JCheckBox("Enable TabPane", true);
            enabledCB.addActionListener(e -> this.pane.setEnabled(enabledCB.isSelected()));
            southPanel.add(enabledCB);
            southPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
            ComboBox placementCombo = new ComboBox((Object[])Placement.values());
            placementCombo.setSelectedIndex(0);
            placementCombo.addActionListener(arg_0 -> this.lambda$createCenterPanel$2((JComboBox)placementCombo, arg_0));
            southPanel.add((Component)placementCombo);
            southPanel.add(new Box.Filler((Dimension)JBUI.size((int)0), (Dimension)JBUI.size((int)0), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)0)));
            panel2.addToBottom((Component)southPanel);
            return panel2;
        }

        private JComponent createComponentPanel() {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, (Insets)JBInsets.create((int)5, (int)0), 0, 0);
            JTextField text1 = new JTextField();
            new ComponentValidator(this.getDisposable()).withHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Text1 link clicked. Desc = " + e.getDescription());
                }
            }).withValidator(() -> {
                String tt = text1.getText();
                if (StringUtil.isNotEmpty((String)tt)) {
                    try {
                        Integer.parseInt(tt);
                        return null;
                    }
                    catch (NumberFormatException nex) {
                        return new ValidationInfo("Warning, expecting a number.<br/>Visit the <a href=\"#link.one\">information link</a><br/>Or <a href=\"#link.two\">another link</a>", (JComponent)text1).asWarning();
                    }
                }
                return null;
            }).withFocusValidator(() -> {
                String tt = text1.getText();
                if (StringUtil.isNotEmpty((String)tt)) {
                    try {
                        int i2 = Integer.parseInt(tt);
                        return i2 == 555 ? new ValidationInfo("Wrong number", (JComponent)text1).asWarning() : null;
                    }
                    catch (NumberFormatException nex) {
                        return new ValidationInfo("Warning, expecting a number.", (JComponent)text1).asWarning();
                    }
                }
                return null;
            }).andRegisterOnDocumentListener((JTextComponent)text1).installOn((JComponent)text1);
            Dimension d = text1.getPreferredSize();
            text1.setPreferredSize(new Dimension(JBUIScale.scale((int)100), d.height));
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)text1).withLabel("&Textfield:").withComment("Textfield description").moveCommentRight().createPanel(), gc);
            JTextField text2 = new JTextField();
            new ComponentValidator(this.getDisposable()).withHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Text2 link clicked. Desc = " + e.getDescription());
                }
            }).withValidator(() -> {
                String tt = text2.getText();
                return StringUtil.isEmpty((String)tt) || tt.length() < 5 ? new ValidationInfo("Message is too short.<br/>Should contain at least 5 symbols <a href=\"#check.rules\">check rules.</a>", (JComponent)text2) : null;
            }).andStartOnFocusLost().andRegisterOnDocumentListener((JTextComponent)text2).installOn((JComponent)text2);
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)text2).withLabel("&Path:").createPanel(), gc);
            JCheckBox cb1 = new JCheckBox("Scroll tab layout");
            cb1.addActionListener(e -> this.pane.setTabLayoutPolicy(cb1.isSelected() ? 1 : 0));
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)cb1).withComment("Set tabbed pane tabs layout property to SCROLL_TAB_LAYOUT").createPanel(), gc);
            JCheckBox cb2 = new JCheckBox("Full border");
            cb2.addActionListener(e -> this.pane.putClientProperty("JTabbedPane.hasFullBorder", cb2.isSelected()));
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)cb2).withTooltip("Enable full border around the tabbed pane").createPanel(), gc);
            JCheckBox cb3 = new JCheckBox("Send usage statistics when using EAP versions");
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)cb3).withComment(LONG_TEXT3).withCommentHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Long text link activated: " + e.getDescription());
                }
            }).createPanel(), gc);
            ++gc.gridy;
            JButton button2 = new JButton("Abracadabra");
            new HelpTooltip().setDescription(LONG_TEXT2).installOn((JComponent)button2);
            topPanel.add((Component)UI.PanelFactory.panel((JComponent)button2).withComment("Abracadabra comment").resizeX(false).createPanel(), gc);
            ++gc.gridy;
            topPanel.add((Component)UI.PanelFactory.panel(new JComboBox<String>(STRING_VALUES)).resizeX(false).withComment("Combobox comment").createPanel(), gc);
            JBScrollPane pane2 = new JBScrollPane((Component)this.createTable());
            pane2.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
            pane2.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
            BorderLayoutPanel mainPanel = JBUI.Panels.simplePanel((Component)UI.PanelFactory.panel((JComponent)pane2).withLabel("Table label:").moveLabelOnTop().withComment("&lt;Project&gt; is content roots of all modules, all immediate descendants<br/>of the projects base directory, and .idea directory contents").resizeY(true).createPanel());
            mainPanel.addToTop((Component)topPanel);
            return mainPanel;
        }

        private JComponent createTable() {
            final String[] columns = new String[]{"First column", "Second column"};
            final String[][] data2 = new String[][]{{"one", "1"}, {"two", "2"}, {"three", "3"}, {"four", "4"}, {"five", "5"}, {"six", "6"}, {"seven", "7"}, {"eight", "8"}, {"nine", "9"}, {"ten", "10"}, {"eleven", "11"}, {"twelve", "12"}, {"thirteen", "13"}, {"fourteen", "14"}, {"fifteen", "15"}, {"sixteen", "16"}};
            JBTable table = new JBTable((TableModel)new DefaultTableModel(){

                @Override
                public String getColumnName(int column) {
                    return columns[column];
                }

                @Override
                public int getRowCount() {
                    return data2.length;
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    return col == 0 ? data2[row][col] : Integer.valueOf(data2[row][col]);
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return true;
                }

                @Override
                public void setValueAt(Object value2, int row, int col) {
                    if (col == 0 || col == 1) {
                        data2[row][col] = value2.toString();
                        this.fireTableCellUpdated(row, col);
                    }
                }
            });
            HyperlinkListener hyperlinkListener = e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Table cell tooltip link clicked. Desc = " + e.getDescription());
                }
            };
            BiFunction<String, JComponent, ValidationInfo> validationInfoGenerator = (text, component2) -> new ValidationInfo("Illegal value: " + text + " <a href=\"#check.cell.rules\">check rules.</a>", component2);
            new CellTooltipManager(this.getDisposable()).withCellComponentProvider(CellComponentProvider.forTable((JTable)table)).withHyperlinkListener(hyperlinkListener).installOn((JComponent)table);
            ExtendableTextField cellEditor = new ExtendableTextField();
            ExtendableTextComponent.Extension browseExtension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.OpenDisk, (Icon)AllIcons.General.OpenDiskHover, (String)"Open file", () -> System.out.println("Table browse clicked"));
            cellEditor.addExtension(browseExtension);
            cellEditor.putClientProperty((Object)"JComponent.compactHeight", (Object)Boolean.TRUE);
            new ComponentValidator(this.getDisposable()).withValidator(() -> {
                boolean isAllowed = ALLOWED_VALUES.contains(cellEditor.getText());
                ValidationUtils.setExtension((ExtendableTextComponent)cellEditor, (ExtendableTextComponent.Extension)ValidationUtils.ERROR_EXTENSION, (!isAllowed ? 1 : 0) != 0);
                return isAllowed ? null : (ValidationInfo)validationInfoGenerator.apply(cellEditor.getText(), (JComponent)cellEditor);
            }).withHyperlinkListener(hyperlinkListener).andRegisterOnDocumentListener((JTextComponent)cellEditor).installOn((JComponent)cellEditor);
            TableColumn col = table.getColumnModel().getColumn(0);
            col.setCellEditor(new DefaultCellEditor((JTextField)cellEditor));
            col.setCellRenderer((TableCellRenderer)new ValidatingTableCellRendererWrapper((TableCellRenderer)new DefaultTableCellRenderer()).bindToEditorSize(() -> cellEditor.getPreferredSize()).withCellValidator((value2, row, column) -> value2 == null ? new ValidationInfo("Null value") : (ALLOWED_VALUES.contains(value2.toString()) ? null : (ValidationInfo)validationInfoGenerator.apply(value2.toString(), null))));
            ComboBox rightEditor = new ComboBox((Object[])((Integer[])Arrays.stream(data2).map(i2 -> Integer.valueOf(i2[1])).toArray(Integer[]::new)));
            col = table.getColumnModel().getColumn(1);
            col.setCellEditor((TableCellEditor)new StatefulValidatingCellEditor((JComboBox)rightEditor, this.getDisposable()));
            col.setCellRenderer((TableCellRenderer)new ValidatingTableCellRendererWrapper((TableCellRenderer)new ColoredTableCellRenderer(){
                {
                    this.setIpad((Insets)JBUI.emptyInsets());
                }

                protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                    if (value2 == null) {
                        this.append("No data", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else {
                        try {
                            int iv = Integer.parseInt(value2.toString());
                            this.append("value ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                            this.append(value2.toString(), iv <= 8 ? SimpleTextAttributes.REGULAR_ATTRIBUTES : WARNING_CELL_ATTRIBUTES);
                        }
                        catch (NumberFormatException nfe) {
                            this.append(value2.toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    }
                }
            }).bindToEditorSize(((JComboBox)rightEditor)::getPreferredSize).withCellValidator((value2, row, column) -> {
                if (value2 == null) {
                    return NULL_VALUE_ERROR;
                }
                try {
                    int iv = Integer.parseInt(value2.toString());
                    return iv <= 8 ? null : new ValidationInfo("Value " + value2.toString() + " is not preferred").asWarning();
                }
                catch (NumberFormatException nfe) {
                    return NAN_VALUE_ERROR;
                }
            }));
            return table;
        }

        private JComponent createComponentGridPanel() {
            ComboboxWithBrowseButton cbb = new ComboboxWithBrowseButton(new JComboBox<String>(new String[]{"One", "Two", "Three", "Four"}));
            cbb.addActionListener(e -> System.out.println("Browse for combobox"));
            JBScrollPane pane2 = new JBScrollPane((Component)new JTextArea(3, 40));
            pane2.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
            DropDownLink linkLabel = new DropDownLink((Object)"Drop down link label", Arrays.asList("Label 1", "Label 2 long long long long long long label", "Label 3", "Label 4", "Label 5", "Label 6"), t -> System.out.println("[" + t + "] selected"), false);
            JPanel p1 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JTextField()).withLabel("&Port:").withComment("Port comment")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JTextField()).withLabel("&Host:").withComment("Host comment")).add((PanelBuilder)UI.PanelFactory.panel(new JComboBox<String>(new String[]{"HTTP", "HTTPS", "FTP", "SSL"})).withLabel("P&rotocol:").withTooltip("Protocol selection").withTooltipLink("Check here for more info", () -> System.out.println("More info"))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new ComponentWithBrowseButton((JComponent)new JTextField(), e -> System.out.println("Browse for text"))).withLabel("&Text field:").withComment("Text field comment <a href=\"https://www.google.com\">with link</a>")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)cbb).withLabel("&Combobox selection:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox")).withComment("Checkbox comment text")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)pane2).withLabel("Text area:").anchorLabelOn(UI.Anchor.Top).withComment("Text area comment").moveLabelOnTop().withTopRightComponent((JComponent)linkLabel)).createPanel();
            JCheckBox cb1 = new JCheckBox("Build project automatically");
            JCheckBox cb2 = new JCheckBox("Compile independent modules in parallel");
            JCheckBox cb3 = new JCheckBox("Checkbox 3");
            ButtonGroup bg = new ButtonGroup();
            JRadioButton rb1 = new JRadioButton("Normal");
            JRadioButton rb2 = new JRadioButton("Warning");
            JRadioButton rb3 = new JRadioButton("Error");
            bg.add(rb1);
            bg.add(rb2);
            bg.add(rb3);
            rb1.setSelected(true);
            new ComponentValidator(this.getDisposable()).withValidator(() -> {
                if (rb1.isSelected()) {
                    return null;
                }
                if (rb2.isSelected()) {
                    return new ValidationInfo("Checkbox warning <a href=\"#warning\">with link</a>", (JComponent)cb3).asWarning();
                }
                if (rb3.isSelected()) {
                    return new ValidationInfo("Checkbox error <a href=\"#error\">with link</a>", (JComponent)cb3);
                }
                return null;
            }).withHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    System.out.println("Checkbox validator tooltip clicked: desc = " + e.getDescription());
                }
            }).installOn((JComponent)cb3);
            ActionListener al = e -> ComponentValidator.getInstance((JComponent)cb3).ifPresent(ComponentValidator::revalidate);
            rb1.addActionListener(al);
            rb2.addActionListener(al);
            rb3.addActionListener(al);
            JPanel p2 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)cb1).resizeX(false).withComment("Works while not running / debugging").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)cb2).resizeX(false).withComment("May require larger heap size").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)cb3).resizeX(false).withTooltip(LONG_TEXT1)).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb1).resizeX(false).withComment("No validation").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb2).resizeX(false).withComment("Warning checkbox validation").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb3).resizeX(false).withComment("Error checkbox validation").moveCommentRight()).createPanel();
            JPanel p3 = UI.PanelFactory.grid().splitColumns().add((PanelBuilder)UI.PanelFactory.panel(new JComboBox<String>(new String[]{"Default", "Non default"})).withLabel("Plugin update policy:").withComment("Ignore by Maven 3+").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JTextField()).withLabel("Thread count:").withComment("-T option").moveCommentRight()).createPanel();
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            panel2.add(p1);
            panel2.add(Box.createVerticalStrut(JBUIScale.scale((int)5)));
            panel2.add(p2);
            panel2.add(Box.createVerticalStrut(JBUIScale.scale((int)5)));
            panel2.add(p3);
            panel2.add(new Box.Filler((Dimension)JBUI.size((int)100, (int)20), (Dimension)JBUI.size((int)200, (int)30), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE)));
            return panel2;
        }

        private JComponent createTiledBorderPanel() {
            JPanel innerGrid = UI.PanelFactory.grid().splitColumns().add((PanelBuilder)UI.PanelFactory.panel(new JComboBox<String>(new String[]{"IntelliJ IDEA", "Gradle"})).resizeX(false).withLabel("Build and run with:")).add((PanelBuilder)UI.PanelFactory.panel(new JComboBox<String>(new String[]{"IntelliJ IDEA", "Gradle"})).resizeX(false).withLabel("Run tests with:")).createPanel();
            JPanel panel2 = UI.PanelFactory.panel((JComponent)innerGrid).withComment(INNER_COMMENT).createPanel();
            panel2.setBorder(IdeBorderFactory.createTitledBorder((String)"Build and Run"));
            return JBUI.Panels.simplePanel().addToTop((Component)panel2);
        }

        private JComponent createValidatorsPanel() {
            final TextFieldWithBrowseButton tfbb = new TextFieldWithBrowseButton(e -> System.out.println("JTextField browse button pressed"));
            new ComponentValidator(this.getDisposable()).withValidator(() -> tfbb.getText().length() != 5 ? new ValidationInfo("Enter 5 symbols", (JComponent)tfbb) : null).withOutlineProvider(ComponentValidator.CWBB_PROVIDER).andStartOnFocusLost().installOn((JComponent)tfbb);
            tfbb.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ComponentValidator.getInstance((JComponent)tfbb).ifPresent(ComponentValidator::revalidate);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$3", "textChanged"));
                }
            });
            EditorTextField editor = new EditorTextField();
            final ComponentWithBrowseButton etfbb = new ComponentWithBrowseButton((JComponent)((Object)editor), e -> System.out.println("JTextField browse button pressed"));
            new ComponentValidator(this.getDisposable()).withValidator(() -> {
                try {
                    new URL(((EditorTextField)((Object)etfbb.getChildComponent())).getDocument().getText());
                    return null;
                }
                catch (MalformedURLException mex) {
                    return new ValidationInfo("Enter a valid URL", (JComponent)etfbb);
                }
            }).withOutlineProvider(ComponentValidator.CWBB_PROVIDER).andStartOnFocusLost().installOn((JComponent)etfbb);
            ((EditorTextField)((Object)etfbb.getChildComponent())).getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    ComponentValidator.getInstance((JComponent)etfbb).ifPresent(ComponentValidator::revalidate);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$4", "documentChanged"));
                }
            });
            ComboBox comboBox2 = new ComboBox((Object[])STRING_VALUES);
            EditorComboBoxEditor cbEditor = new EditorComboBoxEditor(this.project, (FileType)FileTypes.PLAIN_TEXT);
            comboBox2.setEditor((ComboBoxEditor)cbEditor);
            comboBox2.addActionListener(l -> ComponentValidator.getInstance((JComponent)comboBox2).ifPresent(ComponentValidator::revalidate));
            new ComponentValidator(this.getDisposable()).withValidator(() -> comboBox2.getSelectedIndex() % 2 == 0 ? new ValidationInfo("Can't select odd items", (JComponent)comboBox2) : null).installOn((JComponent)comboBox2);
            final ExtendableTextComponent.Extension browseExtension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.OpenDisk, (Icon)AllIcons.General.OpenDiskHover, (String)"Open file", () -> System.out.println("Browse file clicked"));
            ComboBox eComboBox = new ComboBox((Object[])STRING_VALUES);
            eComboBox.setEditable(true);
            eComboBox.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

                @Override
                protected JTextField createEditorComponent() {
                    ExtendableTextField ecbEditor = new ExtendableTextField();
                    ecbEditor.addExtension(browseExtension);
                    ecbEditor.setBorder(null);
                    return ecbEditor;
                }
            });
            new ComponentValidator(this.getDisposable()).withValidator(() -> "Two".equals(eComboBox.getSelectedItem()) ? new ValidationInfo("Two is not preferred", (JComponent)eComboBox).asWarning() : null).installOn((JComponent)eComboBox);
            ComboBox animatedIconComboBox = new ComboBox();
            animatedIconComboBox.setEditable(true);
            animatedIconComboBox.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

                @Override
                protected JTextField createEditorComponent() {
                    ExtendableTextField cbEditor = new ExtendableTextField();
                    cbEditor.addExtension(new ExtendableTextComponent.Extension(){
                        private final Icon icon = new AnimatedIcon.FS();

                        public Icon getIcon(boolean hovered2) {
                            return !hovered2 ? this.icon : AllIcons.Process.FS.Step_passive;
                        }

                        public String getTooltip() {
                            return "Refresh";
                        }
                    });
                    cbEditor.setEditable(false);
                    cbEditor.setBorder(null);
                    return cbEditor;
                }
            });
            return UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)tfbb).withLabel("Default directory:").withComment("Preselected in \"Open ...\" and \"New | Project\" dialogs")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)etfbb).withLabel("&EditorTextField:").withComment("EditorTextField with browse button")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)comboBox2).withLabel("&ComboBoxEditorTextField:").withComment("EditorComboBox editor")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)eComboBox).withLabel("ComboBox &extendable:").withComment("ComboBox with ExtendableTextEditor")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)animatedIconComboBox).withLabel("&Animated combobox:").withComment("ComboBox with animated icon")).createPanel();
        }

        private JComponent createMultilinePanel() {
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)4), 0, 0);
            panel2.add((Component)new JLabel("Label one:"), gc);
            ++gc.gridx;
            panel2.add((Component)new JCheckBox("<html>Multiline<br/>html<br/>checkbox</html>"), gc);
            ++gc.gridx;
            panel2.add((Component)new JCheckBox("<html>Single line html checkbox</html>"), gc);
            ++gc.gridx;
            panel2.add((Component)new JCheckBox("Single line checkbox"), gc);
            ++gc.gridx;
            panel2.add((Component)new JButton("Button 1"), gc);
            ++gc.gridy;
            gc.gridx = 0;
            panel2.add((Component)new JLabel("Label two:"), gc);
            ButtonGroup bg = new ButtonGroup();
            JRadioButton rb = new JRadioButton("<html>Multiline<br/>html<br/>radiobutton</html>");
            bg.add(rb);
            rb.setSelected(true);
            ++gc.gridx;
            panel2.add((Component)rb, gc);
            rb = new JRadioButton("<html>Single line html radiobutton</html>");
            bg.add(rb);
            ++gc.gridx;
            panel2.add((Component)rb, gc);
            rb = new JRadioButton("Single line radiobutton");
            bg.add(rb);
            ++gc.gridx;
            panel2.add((Component)rb, gc);
            ++gc.gridx;
            panel2.add((Component)new JButton("Button 2"), gc);
            ++gc.gridy;
            gc.gridx = 0;
            gc.anchor = 20;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.gridwidth = 5;
            panel2.add((Component)new JPanel(), gc);
            return JBUI.Panels.simplePanel().addToTop((Component)panel2);
        }

        private JComponent createProgressGridPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            JProgressBar pb1 = new JProgressBar(0, 100);
            JProgressBar pb2 = new JProgressBar(0, 100);
            this.progressTimerRequest = new ProgressTimerRequest(pb1);
            ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)pb1);
            if (progressPanel != null) {
                progressPanel.setCommentText(Integer.toString(0));
            }
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb1).withLabel("Label 1.1").withCancel(() -> this.myAlarm.cancelRequest((Runnable)this.progressTimerRequest)).andCancelText("Stop")).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb2).withLabel("Label 1.2").withPause(() -> System.out.println("Pause action #2")).withResume(() -> System.out.println("Resume action #2"))).resize().createPanel());
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb1)).setCommentText("Long long long long long long long text");
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb2)).setCommentText("Short text");
            JProgressBar pb3 = new JProgressBar(0, 100);
            JProgressBar pb4 = new JProgressBar(0, 100);
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb3).withLabel("Label 2.1").moveLabelLeft().withCancel(() -> System.out.println("Cancel action #3"))).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb4).withTopSeparator().withLabel("Label 2.2").moveLabelLeft().withPause(() -> System.out.println("Pause action #4")).withResume(() -> System.out.println("Resume action #4"))).resize().createPanel());
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb3)).setCommentText("Long long long long long long text");
            Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)pb4)).setCommentText("Short text");
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withTopSeparator().withoutComment().andCancelAsButton().withCancel(() -> System.out.println("Cancel action #11"))).createPanel());
            return JBUI.Panels.simplePanel().addToTop((Component)panel2);
        }

        private JComponent createToolbar() {
            AnAction[] actionsArray;
            actionsArray = new AnAction[]{new MyAction("Play", AllIcons.Actions.Execute){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (--counter == 0) {
                        e.getPresentation().setEnabled(false);
                    }
                    System.out.println(e.getPresentation().getDescription() + ", counter = " + counter);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$7", "actionPerformed"));
                }
            }, new MyAction("Stop", AllIcons.Actions.Suspend){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    counter = 5;
                    actionsArray[0].getTemplatePresentation().setEnabled(true);
                    System.out.println(e.getPresentation().getDescription() + ", counter = " + counter);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$8", "actionPerformed"));
                }
            }, new MyToggleAction("Mute", AllIcons.Debugger.MuteBreakpoints){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    boolean bl = this.selected = !this.selected;
                    if (this.selected) {
                        System.out.println("Unmute buttons");
                        actionsArray[0].getTemplatePresentation().setEnabled(true);
                        actionsArray[1].getTemplatePresentation().setEnabled(true);
                    } else {
                        System.out.println("Mute buttons");
                        actionsArray[0].getTemplatePresentation().setEnabled(false);
                        actionsArray[1].getTemplatePresentation().setEnabled(false);
                    }
                    Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.selected);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$9", "actionPerformed"));
                }
            }};
            DefaultActionGroup actions = DefaultActionGroup.createFlatGroup(() -> "Simple group");
            actions.addAll(actionsArray);
            DefaultActionGroup subActions = DefaultActionGroup.createPopupGroup(() -> "Ratings");
            subActions.getTemplatePresentation().setIcon(AllIcons.Ide.Rating);
            subActions.addAll(new AnAction[]{new MyAction("Rating one", AllIcons.Ide.Rating1).withDefaultDescription(), new MyAction("Rating two", AllIcons.Ide.Rating2).withDefaultDescription(), new MyAction("Rating three", AllIcons.Ide.Rating3).withDefaultDescription(), new MyAction("Rating four", AllIcons.Ide.Rating4).withDefaultDescription()});
            actions.add((AnAction)subActions);
            DefaultActionGroup toolbarActions = new DefaultActionGroup();
            toolbarActions.add((AnAction)new SplitButtonAction((ActionGroup)actions));
            toolbarActions.add((AnAction)new MyAction("Short", AllIcons.Ide.Rating1).withShortCut("control K"));
            toolbarActions.add((AnAction)new MyAction("Short", AllIcons.Ide.Rating2).withShortCut("control N"));
            toolbarActions.add((AnAction)new MyAction(null, AllIcons.Ide.Rating3).withShortCut("control P"));
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)toolbarActions, true);
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
            return toolbarComponent;
        }

        private JComponent createJSliderTab() {
            JPanel panel2 = new JPanel((LayoutManager)new MigLayout("fillx, ins 0, gap 10, flowy"));
            JSlider hSlider = new JSlider(0){

                @Override
                public void updateUI() {
                    this.setUI(DarculaSliderUI.createUI(this));
                    this.updateLabelUIs();
                }
            };
            JSlider vSlider = new JSlider(1){

                @Override
                public void updateUI() {
                    this.setUI(DarculaSliderUI.createUI(this));
                    this.updateLabelUIs();
                }
            };
            JSlider hSliderBase = new JSlider(0);
            JPanel pane1 = new JPanel((LayoutManager)new MigLayout("fillx, debug, ins 0, gap 5"));
            pane1.add((Component)new JLabel("A color key and IntelliJ: "), "baseline");
            pane1.add((Component)hSliderBase, "baseline");
            this.setupSlider(hSlider);
            this.setupSlider(vSlider);
            this.setupSlider(hSliderBase);
            panel2.add((Component)this.wrap(hSlider), "growx");
            panel2.add((Component)this.wrap(hSliderBase), "growx");
            panel2.add(this.wrap(vSlider));
            return panel2;
        }

        @NotNull
        private JComponent createComboBoxTab() {
            JPanel pane2 = new JPanel((LayoutManager)new MigLayout("fillx, debug, novisualpadding, ins 0, gap 5"));
            pane2.add((Component)new JLabel("Shows a combobox with custom JBPopup and multiple layers of items"), "baseline, wrap");
            ImmutableList.Builder builder2 = ImmutableList.builder();
            class Item {
                final Icon myIcon;
                final String myText;
                final ImmutableList<Item> myChildren;
                final /* synthetic */ ComponentPanelTest this$0;

                Item(@NotNull ComponentPanelTest this$0, @NotNull @NlsContexts.ListItem Icon icon2, String text) {
                    if (icon2 == null) {
                        Item.$$$reportNull$$$0(0);
                    }
                    if (text == null) {
                        Item.$$$reportNull$$$0(1);
                    }
                    this(this$0, icon2, text, (List<Item>)ImmutableList.of());
                }

                Item(@NotNull ComponentPanelTest this$0, @NotNull @NlsContexts.ListItem Icon icon2, @NotNull String text, List<Item> myChildren) {
                    if (icon2 == null) {
                        Item.$$$reportNull$$$0(2);
                    }
                    if (text == null) {
                        Item.$$$reportNull$$$0(3);
                    }
                    if (myChildren == null) {
                        Item.$$$reportNull$$$0(4);
                    }
                    this.this$0 = this$0;
                    this.myIcon = icon2;
                    this.myText = text;
                    this.myChildren = ImmutableList.copyOf(myChildren);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "icon";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[0] = "myChildren";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$1Item";
                    objectArray[2] = "<init>";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            builder2.add((Object)new Item(this, AllIcons.General.Add, "Add"));
            builder2.add((Object)new Item(this, AllIcons.General.ArrowDown, "ArrowDown"));
            builder2.add((Object)new Item(this, AllIcons.General.Balloon, "Balloon"));
            builder2.add((Object)new Item(this, AllIcons.General.Filter, "Filter"));
            builder2.add((Object)new Item(this, AllIcons.General.Remove, "Remove"));
            ImmutableList level2 = builder2.build();
            ImmutableList.Builder builder1 = ImmutableList.builder();
            builder1.add((Object)new Item(this, AllIcons.Icons.Ide.NextStep, "Next"));
            builder1.add((Object)new Item(this, AllIcons.Vcs.Patch_applied, "Patch"));
            builder1.add((Object)new Item(this, AllIcons.General.Settings, "SubList", (List<Item>)level2));
            builder1.add((Object)new Item(this, AllIcons.General.Remove, "Remove"));
            class Model
            extends DefaultComboBoxModel<Item>
            implements ComboBoxPopupState<Item> {
                Model(List<Item> items) {
                    super(items.toArray(new Item[0]));
                }

                @Nullable
                public ListModel<Item> onChosen(Item selectedValue) {
                    if (selectedValue.myChildren.isEmpty()) {
                        return null;
                    }
                    return new Model((List<Item>)selectedValue.myChildren);
                }

                public boolean hasSubstep(Item selectedValue) {
                    return !selectedValue.myChildren.isEmpty();
                }

                @Override
                public void setSelectedItem(Object anObject) {
                    super.setSelectedItem(anObject);
                }
            }
            ComboBox comboBox2 = new ComboBox((ComboBoxModel)new Model((List<Item>)builder1.build()));
            comboBox2.setSwingPopup(false);
            ColoredListCellRenderer<Item> renderer = new ColoredListCellRenderer<Item>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Item> list2, Item value2, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        12.$$$reportNull$$$0(0);
                    }
                    this.setIcon(value2.myIcon);
                    this.append(value2.myText);
                    this.append(" ");
                    this.append("this text is gray", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.append(" ");
                    this.append("error", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    if (!value2.myChildren.isEmpty()) {
                        this.append(" ->");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest$12", "customizeCellRenderer"));
                }
            };
            comboBox2.setRenderer((ListCellRenderer)renderer);
            pane2.add((Component)new JLabel("The ComboBox:"), "baseline");
            pane2.add((Component)comboBox2, "baseline");
            JPanel jPanel2 = pane2;
            if (jPanel2 == null) {
                ComponentPanelTest.$$$reportNull$$$0(0);
            }
            return jPanel2;
        }

        private JComponent wrap(JComponent component2) {
            JPanel pane2 = new JPanel((LayoutManager)new MigLayout("fillx, debug, novisualpadding, ins 0, gap 5", "[min!][]"));
            pane2.add((Component)new JLabel("A color key and IntelliJ: "), "baseline");
            pane2.add((Component)component2, "baseline, growx");
            return pane2;
        }

        private void setupSlider(JSlider slider) {
            slider.setMajorTickSpacing(25);
            slider.setMinorTickSpacing(5);
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            Hashtable<Integer, JLabel> position = new Hashtable<Integer, JLabel>();
            position.put(0, new JLabel("Hashtable"));
            position.put(25, new JLabel("Hash"));
            position.put(50, new JLabel("Ha"));
            position.put(75, new JLabel("HashtableHashtable"));
            position.put(100, new JLabel("100"));
            slider.setLabelTable(position);
        }

        private /* synthetic */ void lambda$createCenterPanel$2(JComboBox placementCombo, ActionEvent e) {
            Placement p = (Placement)((Object)placementCombo.getSelectedItem());
            if (p != null) {
                this.pane.setTabPlacement(p.placement());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/ui/ComponentPanelTestAction$ComponentPanelTest", "createComboBoxTab"));
        }

        private class ProgressTimerRequest
        implements Runnable {
            private final JProgressBar myProgressBar;

            private ProgressTimerRequest(JProgressBar progressBar) {
                this.myProgressBar = progressBar;
            }

            @Override
            public void run() {
                if (this.canPlay()) {
                    int v = this.myProgressBar.getValue() + 1;
                    if (v > this.myProgressBar.getMaximum()) {
                        v = this.myProgressBar.getMinimum();
                    }
                    this.myProgressBar.setValue(v);
                    ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                    if (progressPanel != null) {
                        progressPanel.setCommentText(Integer.toString(v));
                    }
                    ComponentPanelTest.this.myAlarm.addRequest((Runnable)this, 200, ModalityState.any());
                }
            }

            private boolean canPlay() {
                ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                return progressPanel != null && progressPanel.getState() == ProgressPanel.State.PLAYING;
            }
        }
    }

    private static enum Placement {
        Top(1, "Top"),
        Bottom(3, "Bottom"),
        Left(2, "Left"),
        Right(4, "Right");

        private final String name;
        private final int placement;

        private Placement(int placement, String name) {
            this.name = name;
            this.placement = placement;
        }

        public String toString() {
            return this.name;
        }

        public int placement() {
            return this.placement;
        }
    }
}

