/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardInteractionType;
import com.intellij.ide.customize.CustomizeIDEWizardInteractions;
import com.intellij.ide.customize.IdSet;
import com.intellij.ide.customize.PluginGroups;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public final class CustomizePluginsStepPanel
extends AbstractCustomizeWizardStep
implements LinkListener<String> {
    private static final String MAIN = "main";
    private static final String CUSTOMIZE = "customize";
    private static final int COLS = 3;
    private static final TextProvider CUSTOMIZE_TEXT_PROVIDER = new TextProvider(){

        @Override
        public String getText() {
            return "Customize...";
        }
    };
    private static final String SWITCH_COMMAND = "Switch";
    private static final String CUSTOMIZE_COMMAND = "Customize";
    private final JBCardLayout myCardLayout;
    private final IdSetPanel myCustomizePanel;
    private final PluginGroups myPluginGroups;

    public CustomizePluginsStepPanel(@NotNull PluginGroups pluginGroups) {
        if (pluginGroups == null) {
            CustomizePluginsStepPanel.$$$reportNull$$$0(0);
        }
        this.myPluginGroups = pluginGroups;
        this.myCardLayout = new JBCardLayout();
        this.setLayout((LayoutManager)this.myCardLayout);
        JPanel gridPanel = new JPanel(new GridLayout(0, 3));
        this.myCustomizePanel = new IdSetPanel();
        JBScrollPane scrollPane = CustomizePluginsStepPanel.createScrollPane(gridPanel);
        this.add((Component)scrollPane, MAIN);
        this.add((Component)this.myCustomizePanel, CUSTOMIZE);
        List<PluginGroups.Group> groups = pluginGroups.getTree();
        for (PluginGroups.Group g : groups) {
            final String group = g.getName();
            if ("Core".equals(group) || this.myPluginGroups.getSets(group).isEmpty()) continue;
            JPanel groupPanel = new JPanel(new GridBagLayout()){

                @Override
                public Color getBackground() {
                    Color color = UIManager.getColor("Panel.background");
                    return CustomizePluginsStepPanel.this.isGroupEnabled(group) ? color : ColorUtil.darker((Color)color, (int)1);
                }
            };
            gridPanel.setOpaque(true);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            JLabel titleLabel = new JLabel("<html><body><h2 style=\"text-align:center;\">" + group + "</h2></body></html>", 0){

                @Override
                public boolean isEnabled() {
                    return CustomizePluginsStepPanel.this.isGroupEnabled(group);
                }
            };
            groupPanel.add((Component)new JLabel(g.getIcon()), gbc);
            groupPanel.add((Component)titleLabel, gbc);
            JLabel descriptionLabel = new JLabel(pluginGroups.getDescription(group), 0){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = Math.min(size.width, 200);
                    return size;
                }

                @Override
                public boolean isEnabled() {
                    return CustomizePluginsStepPanel.this.isGroupEnabled(group);
                }

                @Override
                public Color getForeground() {
                    return ColorUtil.withAlpha((Color)UIManager.getColor("Label.foreground"), (double)0.75);
                }
            };
            groupPanel.add((Component)descriptionLabel, gbc);
            gbc.weighty = 1.0;
            groupPanel.add(Box.createVerticalGlue(), gbc);
            gbc.weighty = 0.0;
            JPanel buttonsPanel = new JPanel(new FlowLayout(1, 10, 5));
            buttonsPanel.setOpaque(false);
            if (pluginGroups.getSets(group).size() != 1) {
                buttonsPanel.add((Component)this.createLink("Customize:" + group, CUSTOMIZE_TEXT_PROVIDER));
            }
            buttonsPanel.add((Component)this.createLink("Switch:" + group, this.getGroupSwitchTextProvider(group)));
            groupPanel.add((Component)buttonsPanel, gbc);
            gridPanel.add(groupPanel);
        }
        int cursor = 0;
        Component[] components = gridPanel.getComponents();
        int rowCount = components.length / 3;
        if (components.length % 3 == 0) {
            --rowCount;
        }
        for (Component component2 : components) {
            ((JComponent)component2).setBorder(new CompoundBorder((Border)new CustomLineBorder(ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2), 0, 0, cursor / 3 <= rowCount - 1 ? 1 : 0, cursor % 3 != 2 ? 1 : 0){

                protected Color getColor() {
                    return ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2);
                }
            }, BorderFactory.createEmptyBorder(10, 20, 10, 20)));
            ++cursor;
        }
    }

    static JBScrollPane createScrollPane(JPanel gridPanel) {
        JBScrollPane scrollPane = new JBScrollPane((Component)gridPanel, 20, 31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        return scrollPane;
    }

    public void linkSelected(LinkLabel<String> linkLabel, String command) {
        if (command == null || !command.contains(":")) {
            return;
        }
        int semicolonPosition = command.indexOf(":");
        String group = command.substring(semicolonPosition + 1);
        if (SWITCH_COMMAND.equals(command = command.substring(0, semicolonPosition))) {
            boolean enabled = this.isGroupEnabled(group);
            CustomizeIDEWizardInteractions.INSTANCE.record(enabled ? CustomizeIDEWizardInteractionType.BundledPluginGroupDisabled : CustomizeIDEWizardInteractionType.BundledPluginGroupEnabled, null, group);
            List<IdSet> sets = this.myPluginGroups.getSets(group);
            for (IdSet idSet : sets) {
                for (PluginId id2 : idSet.getIds()) {
                    this.myPluginGroups.setPluginEnabledWithDependencies(id2, !enabled);
                }
            }
            this.repaint();
            return;
        }
        if (CUSTOMIZE_COMMAND.equals(command)) {
            CustomizeIDEWizardInteractions.INSTANCE.record(CustomizeIDEWizardInteractionType.BundledPluginGroupCustomized, null, group);
            this.myCustomizePanel.update(group);
            this.myCardLayout.show((Container)this, CUSTOMIZE);
            this.setButtonsVisible(false);
        }
    }

    private void setButtonsVisible(boolean visible) {
        DialogWrapper window = DialogWrapper.findInstance((Component)this);
        if (window instanceof CustomizeIDEWizardDialog) {
            ((CustomizeIDEWizardDialog)window).setButtonsVisible(visible);
        }
    }

    @NotNull
    private LinkLabel<String> createLink(String command, final TextProvider provider) {
        return new LinkLabel<String>("", null, (LinkListener)this, command){

            public String getText() {
                return provider.getText();
            }
        };
    }

    TextProvider getGroupSwitchTextProvider(final String group) {
        return new TextProvider(){

            @Override
            public String getText() {
                return (CustomizePluginsStepPanel.this.isGroupEnabled(group) ? "Disable" : "Enable") + (CustomizePluginsStepPanel.this.myPluginGroups.getSets(group).size() > 1 ? " All" : "");
            }
        };
    }

    private boolean isGroupEnabled(String group) {
        List<IdSet> sets = this.myPluginGroups.getSets(group);
        for (IdSet idSet : sets) {
            for (PluginId id2 : idSet.getIds()) {
                if (!this.myPluginGroups.isPluginEnabled(id2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTitle() {
        return IdeBundle.message((String)"step.title.default.plugins", (Object[])new Object[0]);
    }

    @Override
    public String getHTMLHeader() {
        return IdeBundle.message((String)"label.tune.0.to.your.tasks", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), ApplicationNamesInfo.getInstance().getFullProductName()});
    }

    @Override
    public boolean beforeOkAction() {
        try {
            DisabledPluginsState.saveDisabledPlugins(this.myPluginGroups.getDisabledPluginIds(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginGroups", "com/intellij/ide/customize/CustomizePluginsStepPanel", "<init>"));
    }

    private static interface TextProvider {
        public String getText();
    }

    private final class IdSetPanel
    extends JPanel
    implements LinkListener<String> {
        private final JLabel myTitleLabel = new JLabel();
        private final JPanel myContentPanel = new JPanel(new GridLayout(0, 3, 5, 5));
        private String myGroup;

        private IdSetPanel() {
            this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 20, true, false));
            this.add(this.myTitleLabel);
            this.add(this.myContentPanel);
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets.right = 25;
            gbc.gridy = 0;
            JButton saveButton = new JButton(IdeBundle.message((String)"button.save.changes.and.go.back", (Object[])new Object[0]));
            buttonPanel.add((Component)saveButton, gbc);
            buttonPanel.add((Component)new LinkLabel(IdeBundle.message((String)"link.enable.all", (Object[])new Object[0]), null, (LinkListener)this, (Object)"enable"), gbc);
            buttonPanel.add((Component)new LinkLabel(IdeBundle.message((String)"link.disable.all", (Object[])new Object[0]), null, (LinkListener)this, (Object)"disable"), gbc);
            gbc.weightx = 1.0;
            buttonPanel.add(Box.createHorizontalGlue(), gbc);
            this.add(buttonPanel);
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomizePluginsStepPanel.this.myCardLayout.show((Container)CustomizePluginsStepPanel.this, CustomizePluginsStepPanel.MAIN);
                    CustomizePluginsStepPanel.this.setButtonsVisible(true);
                }
            });
        }

        public void linkSelected(LinkLabel<String> aSource, String command) {
            if (this.myGroup == null) {
                return;
            }
            boolean enable = "enable".equals(command);
            List<IdSet> idSets = CustomizePluginsStepPanel.this.myPluginGroups.getSets(this.myGroup);
            for (IdSet set : idSets) {
                CustomizePluginsStepPanel.this.myPluginGroups.setIdSetEnabled(set, enable);
            }
            CustomizePluginsStepPanel.this.repaint();
        }

        void update(String group) {
            this.myGroup = group;
            this.myTitleLabel.setText("<html><body><h2 style=\"text-align:left;\">" + group + "</h2></body></html>");
            this.myContentPanel.removeAll();
            List<IdSet> idSets = CustomizePluginsStepPanel.this.myPluginGroups.getSets(group);
            for (final IdSet set : idSets) {
                final JCheckBox checkBox2 = new JCheckBox(set.getTitle(), CustomizePluginsStepPanel.this.myPluginGroups.isIdSetAllEnabled(set));
                checkBox2.setModel(new JToggleButton.ToggleButtonModel(){

                    @Override
                    public boolean isSelected() {
                        return CustomizePluginsStepPanel.this.myPluginGroups.isIdSetAllEnabled(set);
                    }
                });
                checkBox2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomizePluginsStepPanel.this.myPluginGroups.setIdSetEnabled(set, !checkBox2.isSelected());
                        CustomizePluginsStepPanel.this.repaint();
                    }
                });
                this.myContentPanel.add(checkBox2);
            }
        }
    }
}

