/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.hprof.analysis.AnalysisConfig;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.AnalyzeDisposer;
import com.intellij.diagnostic.hprof.analysis.AnalyzeGraph$WhenMappings;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.PartialProgressIndicator;
import com.intellij.diagnostic.hprof.util.UByteList;
import com.intellij.diagnostic.hprof.visitors.HistogramVisitor;
import com.intellij.openapi.progress.ProgressIndicator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph;", "", "analysisContext", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;", "(Lcom/intellij/diagnostic/hprof/analysis/AnalysisContext;)V", "config", "Lcom/intellij/diagnostic/hprof/analysis/AnalysisConfig;", "nominatedInstances", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "Lgnu/trove/TIntHashSet;", "Lkotlin/collections/HashMap;", "parentList", "Lcom/intellij/diagnostic/hprof/util/IntList;", "softWeakRefHistogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "strongRefHistogram", "addIdToListAndSetParentIfOrphan", "", "list", "Lgnu/trove/TIntArrayList;", "id", "", "parentId", "addIdToSetIfOrphan", "set", "analyze", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAndClearSoftWeakHistogram", "getAndClearStrongRefHistogram", "getParentIdForObjectId", "", "objectId", "prepareHistogramSection", "preparePerClassSection", "Lcom/intellij/diagnostic/hprof/util/PartialProgressIndicator;", "setParentForObjectId", "", "traverseInstanceGraph", "WalkGraphPhase", "intellij.platform.ide.impl"})
public final class AnalyzeGraph {
    private Histogram strongRefHistogram;
    private Histogram softWeakRefHistogram;
    private final IntList parentList;
    private final HashMap<ClassDefinition, TIntHashSet> nominatedInstances;
    private final AnalysisConfig config;
    private final AnalysisContext analysisContext;

    private final void setParentForObjectId(long objectId, long parentId) {
        this.parentList.set((int)objectId, (int)parentId);
    }

    private final long getParentIdForObjectId(long objectId) {
        return this.parentList.get((int)objectId);
    }

    @NotNull
    public final String analyze(@NotNull ProgressIndicator progress2) {
        boolean bl;
        CharSequence charSequence;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)progress2, (String)"progress");
        StringBuilder sb = new StringBuilder();
        Collection collection = this.analysisContext.getConfig().getPerClassOptions().getClassNames();
        boolean bl2 = false;
        boolean includePerClassSection = !collection.isEmpty();
        ProgressIndicator traverseProgress = includePerClassSection ? (ProgressIndicator)new PartialProgressIndicator(progress2, 0.0, 0.5) : progress2;
        this.traverseInstanceGraph(traverseProgress);
        AnalyzeDisposer analyzeDisposer = new AnalyzeDisposer(this.analysisContext);
        analyzeDisposer.computeDisposedObjectsIDs();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        if (histogramOptions.getIncludeByCount() || histogramOptions.getIncludeBySize()) {
            stringBuilder = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Histogram");
            bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            sb.append(this.prepareHistogramSection());
        }
        if (includePerClassSection) {
            PartialProgressIndicator perClassProgress = new PartialProgressIndicator(progress2, 0.5, 0.5);
            charSequence = sb;
            String string = HeapReportUtils.INSTANCE.sectionHeader("Instances of each nominated class");
            boolean bl3 = false;
            StringBuilder stringBuilder3 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            sb.append(this.preparePerClassSection(perClassProgress));
        }
        if (this.config.getDisposerOptions().getIncludeDisposerTree()) {
            stringBuilder = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Disposer tree");
            bl = false;
            StringBuilder stringBuilder4 = stringBuilder.append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            sb.append(analyzeDisposer.prepareDisposerTreeSection());
        }
        if (this.config.getDisposerOptions().getIncludeDisposedObjectsSummary() || this.config.getDisposerOptions().getIncludeDisposedObjectsDetails()) {
            stringBuilder = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Disposed objects");
            bl = false;
            StringBuilder stringBuilder5 = stringBuilder.append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            sb.append(analyzeDisposer.prepareDisposedObjectsSection());
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String preparePerClassSection(PartialProgressIndicator progress2) {
        Object entry;
        StringBuilder sb = new StringBuilder();
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.PerClassOptions perClassOptions = this.analysisContext.getConfig().getPerClassOptions();
        if (perClassOptions.getIncludeClassList()) {
            StringBuilder stringBuilder = sb;
            String string = "Nominated classes:";
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            Iterable $this$forEach$iv = perClassOptions.getClassNames();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void totalInstances;
                void classDefinition;
                HistogramEntry histogramEntry;
                Object v1;
                Object object;
                block7: {
                    String name = (String)element$iv;
                    boolean bl2 = false;
                    object = histogram.getEntries();
                    boolean bl3 = false;
                    Object object2 = object;
                    boolean bl4 = false;
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        entry = (HistogramEntry)t;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)((HistogramEntry)entry).getClassDefinition().getName(), (Object)name)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                if ((HistogramEntry)v1 == null) {
                    continue;
                }
                ClassDefinition classDefinition2 = histogramEntry.component1();
                long l = histogramEntry.component2();
                long totalBytes = histogramEntry.component3();
                String prettyName = classDefinition.getPrettyName();
                object = sb;
                String string2 = " --> [" + HeapReportUtils.INSTANCE.toShortStringAsCount((long)totalInstances) + '/' + HeapReportUtils.INSTANCE.toShortStringAsSize(totalBytes) + "] " + prettyName;
                boolean bl6 = false;
                StringBuilder stringBuilder3 = ((StringBuilder)object).append(string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
            StringsKt.appendln((StringBuilder)sb);
        }
        ObjectNavigator nav = this.analysisContext.getNavigator();
        int counter = 0;
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TIntHashSet set;
            String className = (String)element$iv;
            boolean bl = false;
            ClassDefinition classDefinition = nav.getClassStore().get(className);
            if (this.nominatedInstances.get(classDefinition) == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"nominatedInstances[classDefinition]!!");
            progress2.setFraction((double)counter / (double)this.nominatedInstances.size());
            progress2.setText2("Processing: " + set.size() + ' ' + classDefinition.getPrettyName());
            stopwatch.reset().start();
            entry = sb;
            CharSequence charSequence = "CLASS: " + classDefinition.getPrettyName() + " (" + set.size() + " objects)";
            boolean bl7 = false;
            StringBuilder stringBuilder = ((StringBuilder)entry).append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            GCRootPathsTree referenceRegistry = new GCRootPathsTree(this.analysisContext, perClassOptions.getTreeDisplayOptions(), classDefinition);
            set.forEach(new TIntProcedure(referenceRegistry){
                final /* synthetic */ GCRootPathsTree $referenceRegistry;

                public final boolean execute(int objectId) {
                    this.$referenceRegistry.registerObject(objectId);
                    return true;
                }
                {
                    this.$referenceRegistry = gCRootPathsTree;
                }
            });
            set.clear();
            sb.append(referenceRegistry.printTree());
            if (this.config.getMetaInfoOptions().getInclude()) {
                charSequence = sb;
                String string = "Report for " + classDefinition.getPrettyName() + " created in " + stopwatch;
                boolean bl8 = false;
                StringBuilder stringBuilder4 = ((StringBuilder)charSequence).append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
            }
            StringsKt.appendln((StringBuilder)sb);
            int n = counter;
            counter = n + 1;
        }
        progress2.setFraction(1.0);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String prepareHistogramSection() {
        StringBuilder result2 = new StringBuilder();
        Histogram strongRefHistogram = this.getAndClearStrongRefHistogram();
        Histogram softWeakRefHistogram = this.getAndClearSoftWeakHistogram();
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        result2.append(Histogram.Companion.prepareMergedHistogramReport(histogram, "All", strongRefHistogram, "Strong-ref", histogramOptions));
        long unreachableObjectsCount = histogram.getInstanceCount() - strongRefHistogram.getInstanceCount() - softWeakRefHistogram.getInstanceCount();
        long unreachableObjectsSize = histogram.getBytesCount() - strongRefHistogram.getBytesCount() - softWeakRefHistogram.getBytesCount();
        StringBuilder stringBuilder = result2;
        String string = "Unreachable objects: " + HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(unreachableObjectsCount) + "  " + HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(unreachableObjectsSize);
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        String string2 = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String traverseInstanceGraph(ProgressIndicator progress2) {
        Iterable $this$sortedByDescending$iv;
        HistogramEntry histogramEntry;
        Collection<HistogramEntry> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        int id22;
        int n;
        void toVisit;
        StringBuilder result2 = new StringBuilder();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        ClassStore classStore = this.analysisContext.getClassStore();
        IntList sizesList = this.analysisContext.getSizesList();
        IntList visitedList = this.analysisContext.getVisitedList();
        UByteList refIndexList = this.analysisContext.getRefIndexList();
        Iterator<ObjectNavigator.RootObject> roots = nav.createRootsIterator();
        this.nominatedInstances.clear();
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Map)this.nominatedInstances).put(classStore.get(it), new TIntHashSet());
        }
        progress2.setText2("Collect all object roots");
        $this$forEach$iv = new Ref.ObjectRef();
        ((Ref.ObjectRef)$this$forEach$iv).element = new TIntArrayList();
        TIntArrayList toVisit2 = new TIntArrayList();
        TIntHashSet rootsSet = new TIntHashSet();
        TIntHashSet frameRootsSet = new TIntHashSet();
        while (roots.hasNext()) {
            ObjectNavigator.RootObject rootObject = roots.next();
            int rootObjectId = (int)rootObject.getId();
            if (rootObject.getReason().getJavaFrame()) {
                frameRootsSet.add(rootObjectId);
                continue;
            }
            AnalyzeGraph.addIdToSetIfOrphan$default(this, rootsSet, rootObjectId, 0, 4, null);
        }
        classStore.forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)new Function1<ClassDefinition, Unit>(this, rootsSet){
            final /* synthetic */ AnalyzeGraph this$0;
            final /* synthetic */ TIntHashSet $rootsSet;

            public final void invoke(@NotNull ClassDefinition classDefinition) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
                AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, this.$rootsSet, (int)classDefinition.getId(), 0, 4, null);
                Object[] $this$forEach$iv = classDefinition.getStaticFields();
                boolean $i$f$forEach = false;
                StaticField[] staticFieldArray = $this$forEach$iv;
                int n2 = staticFieldArray.length;
                for (n = 0; n < n2; ++n) {
                    StaticField element$iv;
                    StaticField staticField = element$iv = staticFieldArray[n];
                    boolean bl = false;
                    AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, this.$rootsSet, (int)staticField.getObjectId(), 0, 4, null);
                }
                $this$forEach$iv = classDefinition.getConstantFields();
                $i$f$forEach = false;
                staticFieldArray = $this$forEach$iv;
                n2 = staticFieldArray.length;
                for (n = 0; n < n2; ++n) {
                    StaticField element$iv;
                    StaticField objectId = element$iv = staticFieldArray[n];
                    boolean bl = false;
                    AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, this.$rootsSet, (int)objectId, 0, 4, null);
                }
            }
            {
                this.this$0 = analyzeGraph;
                this.$rootsSet = tIntHashSet;
                super(1);
            }
        }));
        ((TIntArrayList)toVisit.element).add(rootsSet.toArray());
        rootsSet.clear();
        rootsSet.compact();
        int leafCounter = 0;
        StringBuilder rootObjectId = result2;
        String string = "Roots count: " + ((TIntArrayList)toVisit.element).size();
        boolean bl = false;
        StringBuilder stringBuilder = rootObjectId.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        rootObjectId = result2;
        string = "Classes count: " + classStore.size();
        bl = false;
        StringBuilder stringBuilder2 = rootObjectId.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        progress2.setText2("Traversing instance graph");
        HashMap strongRefHistogramEntries = new HashMap();
        HashMap reachableNonStrongHistogramEntries = new HashMap();
        TIntIntHashMap softReferenceIdToParentMap = new TIntIntHashMap();
        TIntIntHashMap weakReferenceIdToParentMap = new TIntIntHashMap();
        int visitedInstancesCount = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        TLongArrayList references = new TLongArrayList();
        int visitedCount = 0;
        int strongRefVisitedCount = 0;
        int softWeakVisitedCount = 0;
        long finalizableBytes = 0L;
        long softBytes = 0L;
        long weakBytes = 0L;
        WalkGraphPhase phase = WalkGraphPhase.StrongReferencesNonLocalVariables;
        TIntArrayList cleanerObjects = new TIntArrayList();
        ClassDefinition sunMiscCleanerClass = classStore.getClassIfExists("sun.misc.Cleaner");
        ClassDefinition finalizerClass = classStore.getClassIfExists("java.lang.ref.Finalizer");
        boolean onlyStrongReferences = this.config.getTraverseOptions().getOnlyStrongReferences();
        while (!((TIntArrayList)toVisit.element).isEmpty()) {
            int n2 = 0;
            n = ((TIntArrayList)toVisit.element).size();
            while (n2 < n) {
                void i2;
                id22 = ((TIntArrayList)toVisit.element).get((int)i2);
                nav.goTo(id22, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                ClassDefinition currentObjectClass4222 = nav.getClass();
                if ((Intrinsics.areEqual((Object)currentObjectClass4222, (Object)sunMiscCleanerClass) || Intrinsics.areEqual((Object)currentObjectClass4222, (Object)finalizerClass)) && phase.compareTo((Enum)WalkGraphPhase.CleanerFinalizerReferences) < 0) {
                    if (!onlyStrongReferences) {
                        cleanerObjects.add(id22);
                    }
                } else {
                    Object object;
                    ++visitedInstancesCount;
                    TIntHashSet tIntHashSet = this.nominatedInstances.get(currentObjectClass4222);
                    Boolean bl2 = tIntHashSet != null ? Boolean.valueOf(tIntHashSet.add(id22)) : null;
                    boolean isLeaf = true;
                    nav.copyReferencesTo(references);
                    boolean currentObjectIsArray = currentObjectClass4222.isArray();
                    if (phase.compareTo((Enum)WalkGraphPhase.SoftReferences) < 0 && nav.getSoftReferenceId() != 0L) {
                        if (!onlyStrongReferences) {
                            softReferenceIdToParentMap.put((int)nav.getSoftReferenceId(), id22);
                        }
                        references.set(nav.getSoftWeakReferenceIndex(), 0L);
                    }
                    if (phase.compareTo((Enum)WalkGraphPhase.WeakReferences) < 0 && nav.getWeakReferenceId() != 0L) {
                        if (!onlyStrongReferences) {
                            weakReferenceIdToParentMap.put((int)nav.getWeakReferenceId(), id22);
                        }
                        references.set(nav.getSoftWeakReferenceIndex(), 0L);
                    }
                    int n3 = 0;
                    int n4 = references.size();
                    while (n3 < n4) {
                        void j;
                        int referenceId = (int)references.get((int)j);
                        if (this.addIdToListAndSetParentIfOrphan(toVisit2, referenceId, id22)) {
                            if (!currentObjectIsArray && j <= 254) {
                                refIndexList.set(referenceId, (int)(j + true));
                            }
                            isLeaf = false;
                        }
                        ++j;
                    }
                    visitedList.set(visitedCount++, id22);
                    int size = nav.getObjectSize();
                    int sizeDivBy4 = (size + 3) / 4;
                    if (sizeDivBy4 == 0) {
                        sizeDivBy4 = 1;
                    }
                    sizesList.set(id22, sizeDivBy4);
                    HashMap histogramEntries = null;
                    if (phase == WalkGraphPhase.StrongReferencesNonLocalVariables || phase == WalkGraphPhase.StrongReferencesLocalVariables) {
                        histogramEntries = strongRefHistogramEntries;
                        if (isLeaf) {
                            ++leafCounter;
                        }
                        ++strongRefVisitedCount;
                    } else {
                        histogramEntries = reachableNonStrongHistogramEntries;
                        if (phase == WalkGraphPhase.CleanerFinalizerReferences) {
                            finalizableBytes += (long)size;
                        } else if (phase == WalkGraphPhase.SoftReferences) {
                            softBytes += (long)size;
                        } else {
                            boolean bl3 = phase == WalkGraphPhase.WeakReferences;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            if (_Assertions.ENABLED && !bl3) {
                                boolean bl6 = false;
                                String string2 = "Assertion failed";
                                throw (Throwable)((Object)new AssertionError((Object)string2));
                            }
                            weakBytes += (long)size;
                        }
                        ++softWeakVisitedCount;
                    }
                    Map $this$getOrPut$iv = histogramEntries;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(currentObjectClass4222);
                    if (value$iv == null) {
                        boolean bl7 = false;
                        HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry(currentObjectClass4222);
                        $this$getOrPut$iv.put(currentObjectClass4222, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((HistogramVisitor.InternalHistogramEntry)object).addInstance(size);
                }
                ++i2;
            }
            progress2.setFraction(1.0 * (double)visitedInstancesCount / (double)nav.getInstanceCount());
            ((TIntArrayList)toVisit.element).resetQuick();
            TIntArrayList tmp22 = (TIntArrayList)toVisit.element;
            toVisit.element = toVisit2;
            toVisit2 = tmp22;
            block11: while (((TIntArrayList)toVisit.element).size() == 0 && phase != WalkGraphPhase.Finished) {
                phase = WalkGraphPhase.values()[phase.ordinal() + 1];
                switch (AnalyzeGraph$WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                    case 1: {
                        frameRootsSet.forEach(new TIntProcedure(this, (Ref.ObjectRef)toVisit){
                            final /* synthetic */ AnalyzeGraph this$0;
                            final /* synthetic */ Ref.ObjectRef $toVisit;

                            public final boolean execute(int id2) {
                                AnalyzeGraph.access$addIdToListAndSetParentIfOrphan(this.this$0, (TIntArrayList)this.$toVisit.element, id2, id2);
                                return true;
                            }
                            {
                                this.this$0 = analyzeGraph;
                                this.$toVisit = objectRef;
                            }
                        });
                        continue block11;
                    }
                    case 2: {
                        ((TIntArrayList)toVisit.element).add(cleanerObjects.toNativeArray());
                        cleanerObjects.clear();
                        continue block11;
                    }
                    case 3: {
                        softReferenceIdToParentMap.forEachEntry(new TIntIntProcedure(this, (Ref.ObjectRef)toVisit){
                            final /* synthetic */ AnalyzeGraph this$0;
                            final /* synthetic */ Ref.ObjectRef $toVisit;

                            public final boolean execute(int softId, int parentId) {
                                AnalyzeGraph.access$addIdToListAndSetParentIfOrphan(this.this$0, (TIntArrayList)this.$toVisit.element, softId, parentId);
                                return true;
                            }
                            {
                                this.this$0 = analyzeGraph;
                                this.$toVisit = objectRef;
                            }
                        });
                        softReferenceIdToParentMap.clear();
                        softReferenceIdToParentMap.compact();
                        continue block11;
                    }
                    case 4: {
                        weakReferenceIdToParentMap.forEachEntry(new TIntIntProcedure(this, (Ref.ObjectRef)toVisit){
                            final /* synthetic */ AnalyzeGraph this$0;
                            final /* synthetic */ Ref.ObjectRef $toVisit;

                            public final boolean execute(int weakId, int parentId) {
                                AnalyzeGraph.access$addIdToListAndSetParentIfOrphan(this.this$0, (TIntArrayList)this.$toVisit.element, weakId, parentId);
                                return true;
                            }
                            {
                                this.this$0 = analyzeGraph;
                                this.$toVisit = objectRef;
                            }
                        });
                        weakReferenceIdToParentMap.clear();
                        weakReferenceIdToParentMap.compact();
                        continue block11;
                    }
                }
            }
        }
        boolean tmp22 = cleanerObjects.isEmpty();
        n = 0;
        id22 = 0;
        if (_Assertions.ENABLED && !tmp22) {
            boolean currentObjectClass4222 = false;
            String currentObjectClass4222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)currentObjectClass4222));
        }
        tmp22 = softReferenceIdToParentMap.isEmpty();
        n = 0;
        id22 = 0;
        if (_Assertions.ENABLED && !tmp22) {
            boolean currentObjectClass4222 = false;
            String currentObjectClass4222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)currentObjectClass4222));
        }
        tmp22 = weakReferenceIdToParentMap.isEmpty();
        n = 0;
        id22 = 0;
        if (_Assertions.ENABLED && !tmp22) {
            boolean currentObjectClass4222 = false;
            String currentObjectClass4222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)currentObjectClass4222));
        }
        Object tmp22 = result2;
        String string3 = "Finalizable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(finalizableBytes);
        id22 = 0;
        StringBuilder stringBuilder3 = ((StringBuilder)tmp22).append(string3);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        tmp22 = result2;
        string3 = "Soft-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(softBytes);
        id22 = 0;
        StringBuilder stringBuilder4 = ((StringBuilder)tmp22).append(string3);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        tmp22 = result2;
        string3 = "Weak-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(weakBytes);
        id22 = 0;
        StringBuilder stringBuilder5 = ((StringBuilder)tmp22).append(string3);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        Collection collection2 = strongRefHistogramEntries.values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"strongRefHistogramEntries\n        .values");
        tmp22 = collection2;
        AnalyzeGraph analyzeGraph = this;
        boolean $i$f$map = false;
        void id22 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HistogramVisitor.InternalHistogramEntry sizeDivBy4 = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl8 = false;
            histogramEntry = it.asHistogramEntry();
            collection.add(histogramEntry);
        }
        collection = (List)destination$iv$iv22;
        $this$map$iv = collection;
        boolean $i$f$sortedByDescending = false;
        $this$mapTo$iv$iv = $this$sortedByDescending$iv;
        boolean destination$iv$iv22 = false;
        Comparator $i$f$mapTo22 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        collection = CollectionsKt.sortedWith((Iterable)$this$mapTo$iv$iv, (Comparator)$i$f$mapTo22);
        long l = strongRefVisitedCount;
        Collection<HistogramEntry> collection3 = collection;
        analyzeGraph.strongRefHistogram = new Histogram((List<HistogramEntry>)collection3, l);
        Collection collection4 = reachableNonStrongHistogramEntries.values();
        Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"reachableNonStrongHistogramEntries\n        .values");
        $this$sortedByDescending$iv = collection4;
        analyzeGraph = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HistogramVisitor.InternalHistogramEntry it = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection = destination$iv$iv32;
            boolean bl9 = false;
            histogramEntry = it.asHistogramEntry();
            collection.add(histogramEntry);
        }
        collection = (List)destination$iv$iv32;
        $this$map$iv = collection;
        $i$f$sortedByDescending = false;
        $this$mapTo$iv$iv = $this$sortedByDescending$iv;
        boolean destination$iv$iv32 = false;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        collection = CollectionsKt.sortedWith((Iterable)$this$mapTo$iv$iv, (Comparator)comparator2);
        long l2 = softWeakVisitedCount;
        Collection<HistogramEntry> collection5 = collection;
        analyzeGraph.softWeakRefHistogram = new Histogram((List<HistogramEntry>)collection5, l2);
        Stopwatch stopwatchUpdateSizes = Stopwatch.createStarted();
        for (int index = visitedCount - 1; index >= 0; --index) {
            int parentId;
            int id3 = visitedList.get(index);
            if (id3 == (parentId = this.parentList.get(id3))) continue;
            IntList intList = sizesList;
            int n5 = parentId;
            intList.set(n5, intList.get(n5) + sizesList.get(id3));
        }
        stopwatchUpdateSizes.stop();
        if (this.config.getMetaInfoOptions().getInclude()) {
            StringBuilder stringBuilder6 = result2;
            String string4 = "Analysis completed! Visited instances: " + visitedInstancesCount + ", time: " + stopwatch;
            boolean bl10 = false;
            StringBuilder stringBuilder7 = stringBuilder6.append(string4);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
            stringBuilder6 = result2;
            string4 = "Update sizes time: " + stopwatchUpdateSizes;
            bl10 = false;
            StringBuilder stringBuilder8 = stringBuilder6.append(string4);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder8);
            stringBuilder6 = result2;
            string4 = "Leaves found: " + leafCounter;
            bl10 = false;
            StringBuilder stringBuilder9 = stringBuilder6.append(string4);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder9, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder9);
        }
        String string5 = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"result.toString()");
        return string5;
    }

    private final boolean addIdToListAndSetParentIfOrphan(TIntArrayList list2, int id2, int parentId) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L) {
            this.setParentForObjectId(id2, parentId);
            list2.add(id2);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToListAndSetParentIfOrphan$default(AnalyzeGraph analyzeGraph, TIntArrayList tIntArrayList, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToListAndSetParentIfOrphan(tIntArrayList, n, n2);
    }

    private final boolean addIdToSetIfOrphan(TIntHashSet set, int id2, int parentId) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L && set.add(id2)) {
            this.setParentForObjectId(id2, parentId);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToSetIfOrphan$default(AnalyzeGraph analyzeGraph, TIntHashSet tIntHashSet, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToSetIfOrphan(tIntHashSet, n, n2);
    }

    private final Histogram getAndClearStrongRefHistogram() {
        Histogram result2 = this.strongRefHistogram;
        this.strongRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw (Throwable)new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    private final Histogram getAndClearSoftWeakHistogram() {
        Histogram result2 = this.softWeakRefHistogram;
        this.softWeakRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw (Throwable)new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    public AnalyzeGraph(@NotNull AnalysisContext analysisContext) {
        Intrinsics.checkParameterIsNotNull((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
        this.parentList = this.analysisContext.getParentList();
        this.nominatedInstances = new HashMap();
        this.config = this.analysisContext.getConfig();
    }

    public static final /* synthetic */ boolean access$addIdToListAndSetParentIfOrphan(AnalyzeGraph $this, TIntArrayList list2, int id2, int parentId) {
        return $this.addIdToListAndSetParentIfOrphan(list2, id2, parentId);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph$WalkGraphPhase;", "", "(Ljava/lang/String;I)V", "StrongReferencesNonLocalVariables", "StrongReferencesLocalVariables", "SoftReferences", "WeakReferences", "CleanerFinalizerReferences", "Finished", "intellij.platform.ide.impl"})
    public static final class WalkGraphPhase
    extends Enum<WalkGraphPhase> {
        public static final /* enum */ WalkGraphPhase StrongReferencesNonLocalVariables;
        public static final /* enum */ WalkGraphPhase StrongReferencesLocalVariables;
        public static final /* enum */ WalkGraphPhase SoftReferences;
        public static final /* enum */ WalkGraphPhase WeakReferences;
        public static final /* enum */ WalkGraphPhase CleanerFinalizerReferences;
        public static final /* enum */ WalkGraphPhase Finished;
        private static final /* synthetic */ WalkGraphPhase[] $VALUES;

        static {
            WalkGraphPhase[] walkGraphPhaseArray = new WalkGraphPhase[6];
            WalkGraphPhase[] walkGraphPhaseArray2 = walkGraphPhaseArray;
            walkGraphPhaseArray[0] = StrongReferencesNonLocalVariables = new WalkGraphPhase();
            walkGraphPhaseArray[1] = StrongReferencesLocalVariables = new WalkGraphPhase();
            walkGraphPhaseArray[2] = SoftReferences = new WalkGraphPhase();
            walkGraphPhaseArray[3] = WeakReferences = new WalkGraphPhase();
            walkGraphPhaseArray[4] = CleanerFinalizerReferences = new WalkGraphPhase();
            walkGraphPhaseArray[5] = Finished = new WalkGraphPhase();
            $VALUES = walkGraphPhaseArray;
        }

        public static WalkGraphPhase[] values() {
            return (WalkGraphPhase[])$VALUES.clone();
        }

        public static WalkGraphPhase valueOf(String string) {
            return Enum.valueOf(WalkGraphPhase.class, string);
        }
    }
}

