/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.IconDescriptionBundleEP;
import com.intellij.ui.IconManager;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class CoreIconManager
implements IconManager {
    private static final List<IconLayer> ourIconLayers = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final int FLAGS_LOCKED = 2048;
    private static final Logger LOG = Logger.getInstance(CoreIconManager.class);

    @NotNull
    public Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            CoreIconManager.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            CoreIconManager.$$$reportNull$$$0(1);
        }
        Icon icon = IconLoader.getIcon((String)path, (Class)aClass);
        IconWithToolTip iconWithToolTip = IconWithToolTip.create(icon, new IconDescriptionLoader(path));
        if (iconWithToolTip == null) {
            CoreIconManager.$$$reportNull$$$0(2);
        }
        return iconWithToolTip;
    }

    @NotNull
    public Icon createEmptyIcon(@NotNull Icon icon) {
        if (icon == null) {
            CoreIconManager.$$$reportNull$$$0(3);
        }
        EmptyIcon emptyIcon = EmptyIcon.create((Icon)icon);
        if (emptyIcon == null) {
            CoreIconManager.$$$reportNull$$$0(4);
        }
        return emptyIcon;
    }

    @NotNull
    public <T> Icon createDeferredIcon(@NotNull Icon base, T param, @NotNull Function<? super T, ? extends Icon> f) {
        if (base == null) {
            CoreIconManager.$$$reportNull$$$0(5);
        }
        if (f == null) {
            CoreIconManager.$$$reportNull$$$0(6);
        }
        Icon icon = IconDeferrer.getInstance().defer(base, param, t -> (Icon)f.apply(t));
        if (icon == null) {
            CoreIconManager.$$$reportNull$$$0(7);
        }
        return icon;
    }

    @NotNull
    public Icon getAnalyzeIcon() {
        Icon icon = IconUtil.getAnalyzeIcon();
        if (icon == null) {
            CoreIconManager.$$$reportNull$$$0(8);
        }
        return icon;
    }

    public void registerIconLayer(int flagMask, @NotNull Icon icon) {
        if (icon == null) {
            CoreIconManager.$$$reportNull$$$0(9);
        }
        for (IconLayer iconLayer : ourIconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        ourIconLayers.add(new IconLayer(flagMask, icon));
    }

    @NotNull
    public RowIcon createRowIcon(int iconCount, RowIcon.Alignment alignment) {
        return new com.intellij.ui.RowIcon(iconCount, alignment);
    }

    @NotNull
    public RowIcon createRowIcon(Icon ... icons) {
        if (icons == null) {
            CoreIconManager.$$$reportNull$$$0(10);
        }
        return new com.intellij.ui.RowIcon(icons);
    }

    @NotNull
    public com.intellij.ui.RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon, int flags) {
        if (instance == null) {
            CoreIconManager.$$$reportNull$$$0(11);
        }
        SmartList layersFromProviders = new SmartList();
        for (Object provider : IconLayerProvider.EP_NAME.getExtensionList()) {
            Icon layerIcon = provider.getLayerIcon(instance, BitUtil.isSet((int)flags, (int)2048));
            if (layerIcon == null) continue;
            layersFromProviders.add(layerIcon);
        }
        if (flags != 0 || !layersFromProviders.isEmpty()) {
            SmartList iconLayers = new SmartList();
            for (IconLayer l : ourIconLayers) {
                if (!BitUtil.isSet((int)flags, (int)l.flagMask)) continue;
                iconLayers.add(l.icon);
            }
            iconLayers.addAll(layersFromProviders);
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon, 0);
            for (int i = 0; i < iconLayers.size(); ++i) {
                Icon icon1 = (Icon)iconLayers.get(i);
                layeredIcon.setIcon(icon1, i + 1);
            }
            icon = layeredIcon;
        }
        com.intellij.ui.RowIcon baseIcon = new com.intellij.ui.RowIcon(2);
        baseIcon.setIcon(icon, 0);
        com.intellij.ui.RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            CoreIconManager.$$$reportNull$$$0(12);
        }
        return rowIcon;
    }

    @NotNull
    public Icon createOffsetIcon(@NotNull Icon icon) {
        if (icon == null) {
            CoreIconManager.$$$reportNull$$$0(13);
        }
        return new OffsetIcon(icon);
    }

    @NotNull
    public Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            CoreIconManager.$$$reportNull$$$0(14);
        }
        if (color == null) {
            CoreIconManager.$$$reportNull$$$0(15);
        }
        Icon icon = IconUtil.colorize(g, source, color);
        if (icon == null) {
            CoreIconManager.$$$reportNull$$$0(16);
        }
        return icon;
    }

    @NotNull
    public Icon createLayered(Icon ... icons) {
        if (icons == null) {
            CoreIconManager.$$$reportNull$$$0(17);
        }
        return new LayeredIcon(icons);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CoreIconManager";
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CoreIconManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeferredIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyzeIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayeredIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "colorize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDeferredIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerIconLayer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRowIcon";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLayeredIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createOffsetIcon";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "colorize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createLayered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IconDescriptionLoader
    implements Supplier<String> {
        private final String myPath;
        private String myResult;
        private boolean myCalculated;

        private IconDescriptionLoader(String path) {
            this.myPath = path;
        }

        @Override
        public String get() {
            if (!this.myCalculated) {
                this.myResult = this.findIconDescription();
                this.myCalculated = true;
            }
            return this.myResult;
        }

        private String findIconDescription() {
            String basePath = StringUtil.trimStart((String)StringUtil.trimEnd((String)this.myPath, (String)".svg"), (String)"/");
            String key = "icon." + basePath.replace('/', '.') + ".tooltip";
            Ref result = new Ref();
            IconDescriptionBundleEP.EP_NAME.processWithPluginDescriptor((ep, descriptor) -> {
                ResourceBundle bundle;
                String description;
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = descriptor == null ? null : descriptor.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((description = AbstractBundle.messageOrNull((ResourceBundle)(bundle = DynamicBundle.INSTANCE.getResourceBundle(ep.resourceBundle, classLoader)), (String)key, (Object[])new Object[0])) != null) {
                    result.set((Object)description);
                }
            });
            if (result.get() == null && Registry.is((String)"ide.icon.tooltips.trace.missing")) {
                LOG.info("Icon tooltip requested but not found for " + this.myPath);
            }
            return (String)result.get();
        }
    }

    private static class IconLayer {
        private final int flagMask;
        @NotNull
        private final Icon icon;

        private IconLayer(int flagMask, @NotNull Icon icon) {
            if (icon == null) {
                IconLayer.$$$reportNull$$$0(0);
            }
            BitUtil.assertOneBitMask((int)flagMask);
            this.flagMask = flagMask;
            this.icon = icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/CoreIconManager$IconLayer", "<init>"));
        }
    }
}

