export default class SettingsScreen extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('settings/settingsScreen.css');this.contentElement.classList.add('settings-window-main');this.contentElement.classList.add('vbox');const settingsLabelElement=createElement('div');const settingsTitleElement=UI.createShadowRootWithCoreStyles(settingsLabelElement,'settings/settingsScreen.css').createChild('div','settings-window-title');UI.ARIAUtils.markAsHeading(settingsTitleElement,1);settingsTitleElement.textContent=ls`Settings`;this._tabbedLocation=UI.viewManager.createTabbedLocation(()=>SettingsScreen._showSettingsScreen(),'settings-view');const tabbedPane=this._tabbedLocation.tabbedPane();tabbedPane.leftToolbar().appendToolbarItem(new UI.ToolbarItem(settingsLabelElement));tabbedPane.setShrinkableTabs(false);tabbedPane.makeVerticalTabLayout();const shortcutsView=new UI.SimpleView(ls`Shortcuts`);UI.shortcutsScreen.createShortcutsTabView().show(shortcutsView.element);this._tabbedLocation.appendView(shortcutsView);tabbedPane.show(this.contentElement);this.element.addEventListener('keydown',this._keyDown.bind(this),false);this._developerModeCounter=0;this.setDefaultFocusedElement(this.contentElement);}
static _showSettingsScreen(name){const settingsScreen=(self.runtime.sharedInstance(SettingsScreen));if(settingsScreen.isShowing()){return;}
const dialog=new UI.Dialog();dialog.contentElement.tabIndex=-1;dialog.addCloseButton();dialog.setOutsideClickCallback(()=>{});dialog.setPointerEventsBehavior(UI.GlassPane.PointerEventsBehavior.PierceGlassPane);dialog.setOutsideTabIndexBehavior(UI.Dialog.OutsideTabIndexBehavior.PreserveMainViewTabIndex);settingsScreen.show(dialog.contentElement);dialog.show();settingsScreen._selectTab(name||'preferences');}
resolveLocation(locationName){return this._tabbedLocation;}
_selectTab(name){UI.viewManager.showView(name);}
_keyDown(event){const shiftKeyCode=16;if(event.keyCode===shiftKeyCode&&++this._developerModeCounter>5){this.contentElement.classList.add('settings-developer-mode');}}}
class SettingsTab extends UI.VBox{constructor(name,id){super();this.element.classList.add('settings-tab-container');if(id){this.element.id=id;}
const header=this.element.createChild('header');header.createChild('h1').createTextChild(name);this.containerElement=this.element.createChild('div','settings-container-wrapper').createChild('div','settings-tab settings-content settings-container');}
_appendSection(name){const block=this.containerElement.createChild('div','settings-block');if(name){UI.ARIAUtils.markAsGroup(block);const title=block.createChild('div','settings-section-title');title.textContent=name;UI.ARIAUtils.markAsHeading(title,2);UI.ARIAUtils.setAccessibleName(block,name);}
return block;}}
export class GenericSettingsTab extends SettingsTab{constructor(){super(Common.UIString('Preferences'),'preferences-tab-content');const explicitSectionOrder=['','Appearance','Sources','Elements','Network','Performance','Console','Extensions'];this._nameToSection=new Map();for(const sectionName of explicitSectionOrder){this._sectionElement(sectionName);}
self.runtime.extensions('setting').forEach(this._addSetting.bind(this));self.runtime.extensions(UI.SettingUI).forEach(this._addSettingUI.bind(this));this._appendSection().appendChild(UI.createTextButton(Common.UIString('Restore defaults and reload'),restoreAndReload));function restoreAndReload(){Common.settings.clearAll();Components.reload();}}
static isSettingVisible(extension){const descriptor=extension.descriptor();if(!('title'in descriptor)){return false;}
if(!('category'in descriptor)){return false;}
return true;}
_addSetting(extension){if(!GenericSettingsTab.isSettingVisible(extension)){return;}
const sectionElement=this._sectionElement(extension.descriptor()['category']);const setting=Common.moduleSetting(extension.descriptor()['settingName']);const settingControl=UI.SettingsUI.createControlForSetting(setting);if(settingControl){sectionElement.appendChild(settingControl);}}
_addSettingUI(extension){const descriptor=extension.descriptor();const sectionName=descriptor['category']||'';extension.instance().then(appendCustomSetting.bind(this));function appendCustomSetting(object){const settingUI=(object);const element=settingUI.settingElement();if(element){this._sectionElement(sectionName).appendChild(element);}}}
_sectionElement(sectionName){let sectionElement=this._nameToSection.get(sectionName);if(!sectionElement){const uiSectionName=sectionName&&Common.UIString(sectionName);sectionElement=this._appendSection(uiSectionName);this._nameToSection.set(sectionName,sectionElement);}
return sectionElement;}}
export class ExperimentsSettingsTab extends SettingsTab{constructor(){super(Common.UIString('Experiments'),'experiments-tab-content');const experiments=Root.Runtime.experiments.allConfigurableExperiments();if(experiments.length){const experimentsSection=this._appendSection();experimentsSection.appendChild(this._createExperimentsWarningSubsection());for(let i=0;i<experiments.length;++i){experimentsSection.appendChild(this._createExperimentCheckbox(experiments[i]));}}}
_createExperimentsWarningSubsection(){const subsection=createElement('div');const warning=subsection.createChild('span','settings-experiments-warning-subsection-warning');warning.textContent=Common.UIString('WARNING:');subsection.createTextChild(' ');const message=subsection.createChild('span','settings-experiments-warning-subsection-message');message.textContent=Common.UIString('These experiments could be dangerous and may require restart.');return subsection;}
_createExperimentCheckbox(experiment){const label=UI.CheckboxLabel.create(Common.UIString(experiment.title),experiment.isEnabled());const input=label.checkboxElement;input.name=experiment.name;function listener(){experiment.setEnabled(input.checked);}
input.addEventListener('click',listener,false);const p=createElement('p');p.className=experiment.hidden&&!experiment.isEnabled()?'settings-experiment-hidden':'';p.appendChild(label);return p;}}
export class ActionDelegate{handleAction(context,actionId){switch(actionId){case'settings.show':SettingsScreen._showSettingsScreen();return true;case'settings.documentation':Host.InspectorFrontendHost.openInNewTab('https://developers.google.com/web/tools/chrome-devtools/');return true;case'settings.shortcuts':SettingsScreen._showSettingsScreen(Common.UIString('Shortcuts'));return true;}
return false;}}
export class Revealer{reveal(object){console.assert(object instanceof Common.Setting);const setting=(object);let success=false;self.runtime.extensions('setting').forEach(revealModuleSetting);self.runtime.extensions(UI.SettingUI).forEach(revealSettingUI);self.runtime.extensions('view').forEach(revealSettingsView);return success?Promise.resolve():Promise.reject();function revealModuleSetting(extension){if(!GenericSettingsTab.isSettingVisible(extension)){return;}
if(extension.descriptor()['settingName']===setting.name){Host.InspectorFrontendHost.bringToFront();SettingsScreen._showSettingsScreen();success=true;}}
function revealSettingUI(extension){const settings=extension.descriptor()['settings'];if(settings&&settings.indexOf(setting.name)!==-1){Host.InspectorFrontendHost.bringToFront();SettingsScreen._showSettingsScreen();success=true;}}
function revealSettingsView(extension){const location=extension.descriptor()['location'];if(location!=='settings-view'){return;}
const settings=extension.descriptor()['settings'];if(settings&&settings.indexOf(setting.name)!==-1){Host.InspectorFrontendHost.bringToFront();SettingsScreen._showSettingsScreen(extension.descriptor()['id']);success=true;}}}}
self.Settings=self.Settings||{};Settings=Settings||{};Settings.SettingsScreen=SettingsScreen;Settings.SettingsScreen.ActionDelegate=ActionDelegate;Settings.SettingsScreen.Revealer=Revealer;Settings.GenericSettingsTab=GenericSettingsTab;Settings.ExperimentsSettingsTab=ExperimentsSettingsTab;