/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

public class PrimUtils {
    public static void sort(int start, int end, int[] array, IntComparator comparator) {
        int temp;
        int d;
        int b;
        int length = end - start;
        if (length < 7) {
            for (int i = start + 1; i < end; ++i) {
                for (int j = i; j > start && comparator.lessThan(array[j], array[j - 1]); --j) {
                    int temp2 = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = temp2;
                }
            }
            return;
        }
        int middle = start + end >>> 1;
        if (length > 7) {
            int bottom = start;
            int top = end - 1;
            if (length > 40) {
                bottom = PrimUtils.med3(array, bottom, bottom + (length >>= 3), bottom + (length << 1), comparator);
                middle = PrimUtils.med3(array, middle - length, middle, middle + length, comparator);
                top = PrimUtils.med3(array, top - (length << 1), top - length, top, comparator);
            }
            middle = PrimUtils.med3(array, bottom, middle, top, comparator);
        }
        int partionValue = array[middle];
        int a = b = start;
        int c = d = end - 1;
        while (true) {
            if (b <= c && !comparator.lessThan(partionValue, array[b])) {
                if (comparator.equals(array[b], partionValue)) {
                    temp = array[a];
                    array[a++] = array[b];
                    array[b] = temp;
                }
                ++b;
                continue;
            }
            while (c >= b && !comparator.lessThan(array[c], partionValue)) {
                if (comparator.equals(array[c], partionValue)) {
                    temp = array[c];
                    array[c] = array[d];
                    array[d--] = temp;
                }
                --c;
            }
            if (b > c) break;
            temp = array[b];
            array[b++] = array[c];
            array[c--] = temp;
        }
        length = a - start < b - a ? a - start : b - a;
        int l = start;
        int h = b - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = d - c < end - 1 - d ? d - c : end - 1 - d;
        l = b;
        h = end - length;
        while (length-- > 0) {
            temp = array[l];
            array[l++] = array[h];
            array[h++] = temp;
        }
        length = b - a;
        if (length > 0) {
            PrimUtils.sort(start, start + length, array, comparator);
        }
        if ((length = d - c) > 0) {
            PrimUtils.sort(end - length, end, array, comparator);
        }
    }

    private static int med3(int[] array, int a, int b, int c, IntComparator comparator) {
        int x = array[a];
        int y = array[b];
        int z = array[c];
        return comparator.lessThan(x, y) ? (comparator.lessThan(y, z) ? b : (comparator.lessThan(x, z) ? c : a)) : (comparator.lessThan(z, y) ? b : (comparator.lessThan(z, x) ? c : a));
    }

    public static abstract class IntComparator {
        public abstract int compare(int var1, int var2);

        public boolean lessThan(int a, int b) {
            return this.compare(a, b) < 0;
        }

        public boolean equals(int a, int b) {
            return this.compare(a, b) == 0;
        }
    }
}

