/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.FileType;
import com.drew.lang.ByteTrie;
import com.drew.lang.annotations.NotNull;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.HashMap;

public class FileTypeDetector {
    private static final ByteTrie<FileType> _root = new ByteTrie();
    private static final HashMap<String, FileType> _ftypMap;

    private FileTypeDetector() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    @NotNull
    public static FileType detectFileType(@NotNull BufferedInputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("Stream must support mark/reset");
        }
        int maxByteCount = Math.max(16, _root.getMaxDepth());
        inputStream.mark(maxByteCount);
        byte[] bytes = new byte[maxByteCount];
        int bytesRead = inputStream.read(bytes);
        if (bytesRead == -1) {
            throw new IOException("Stream ended before file's magic number could be determined.");
        }
        inputStream.reset();
        FileType fileType = _root.find(bytes);
        assert (fileType != null);
        if (fileType == FileType.Unknown) {
            String eightCC = new String(bytes, 4, 8);
            FileType t = _ftypMap.get(eightCC);
            if (t != null) {
                return t;
            }
        } else if (fileType == FileType.Riff) {
            String fourCC = new String(bytes, 8, 4);
            if (fourCC.equals("WAVE")) {
                return FileType.Wav;
            }
            if (fourCC.equals("AVI ")) {
                return FileType.Avi;
            }
            if (fourCC.equals("WEBP")) {
                return FileType.WebP;
            }
        }
        return fileType;
    }

    static {
        _root.setDefaultValue(FileType.Unknown);
        _root.addPath(FileType.Jpeg, new byte[][]{{-1, -40}});
        _root.addPath(FileType.Tiff, "II".getBytes(), {42, 0});
        _root.addPath(FileType.Tiff, "MM".getBytes(), {0, 42});
        _root.addPath(FileType.Psd, new byte[][]{"8BPS".getBytes()});
        _root.addPath(FileType.Png, new byte[][]{{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82}});
        _root.addPath(FileType.Bmp, new byte[][]{"BM".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"BA".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"CI".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"CP".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"IC".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"PT".getBytes()});
        _root.addPath(FileType.Gif, new byte[][]{"GIF87a".getBytes()});
        _root.addPath(FileType.Gif, new byte[][]{"GIF89a".getBytes()});
        _root.addPath(FileType.Ico, new byte[][]{{0, 0, 1, 0}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 0, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 2, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 3, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 5, 1}});
        _root.addPath(FileType.Riff, new byte[][]{"RIFF".getBytes()});
        _root.addPath(FileType.Arw, "II".getBytes(), {42, 0, 8, 0});
        _root.addPath(FileType.Crw, "II".getBytes(), {26, 0, 0, 0}, "HEAPCCDR".getBytes());
        _root.addPath(FileType.Cr2, "II".getBytes(), {42, 0, 16, 0, 0, 0, 67, 82});
        _root.addPath(FileType.Orf, "IIRO".getBytes(), {8, 0});
        _root.addPath(FileType.Orf, "MMOR".getBytes(), {0, 0});
        _root.addPath(FileType.Orf, "IIRS".getBytes(), {8, 0});
        _root.addPath(FileType.Raf, new byte[][]{"FUJIFILMCCD-RAW".getBytes()});
        _root.addPath(FileType.Rw2, "II".getBytes(), {85, 0});
        _root.addPath(FileType.Eps, new byte[][]{"%!PS".getBytes()});
        _root.addPath(FileType.Eps, new byte[][]{{-59, -48, -45, -58}});
        _ftypMap = new HashMap();
        _ftypMap.put("ftypmoov", FileType.Mov);
        _ftypMap.put("ftypwide", FileType.Mov);
        _ftypMap.put("ftypmdat", FileType.Mov);
        _ftypMap.put("ftypfree", FileType.Mov);
        _ftypMap.put("ftypqt  ", FileType.Mov);
        _ftypMap.put("ftypavc1", FileType.Mp4);
        _ftypMap.put("ftypiso2", FileType.Mp4);
        _ftypMap.put("ftypisom", FileType.Mp4);
        _ftypMap.put("ftypM4A ", FileType.Mp4);
        _ftypMap.put("ftypM4B ", FileType.Mp4);
        _ftypMap.put("ftypM4P ", FileType.Mp4);
        _ftypMap.put("ftypM4V ", FileType.Mp4);
        _ftypMap.put("ftypM4VH", FileType.Mp4);
        _ftypMap.put("ftypM4VP", FileType.Mp4);
        _ftypMap.put("ftypmmp4", FileType.Mp4);
        _ftypMap.put("ftypmp41", FileType.Mp4);
        _ftypMap.put("ftypmp42", FileType.Mp4);
        _ftypMap.put("ftypmp71", FileType.Mp4);
        _ftypMap.put("ftypMSNV", FileType.Mp4);
        _ftypMap.put("ftypNDAS", FileType.Mp4);
        _ftypMap.put("ftypNDSC", FileType.Mp4);
        _ftypMap.put("ftypNDSH", FileType.Mp4);
        _ftypMap.put("ftypNDSM", FileType.Mp4);
        _ftypMap.put("ftypNDSP", FileType.Mp4);
        _ftypMap.put("ftypNDSS", FileType.Mp4);
        _ftypMap.put("ftypNDXC", FileType.Mp4);
        _ftypMap.put("ftypNDXH", FileType.Mp4);
        _ftypMap.put("ftypNDXM", FileType.Mp4);
        _ftypMap.put("ftypNDXP", FileType.Mp4);
        _ftypMap.put("ftypNDXS", FileType.Mp4);
        _ftypMap.put("ftypmif1", FileType.Heif);
        _ftypMap.put("ftypmsf1", FileType.Heif);
        _ftypMap.put("ftypheic", FileType.Heif);
        _ftypMap.put("ftypheix", FileType.Heif);
        _ftypMap.put("ftyphevc", FileType.Heif);
        _ftypMap.put("ftyphevx", FileType.Heif);
        _root.addPath(FileType.Aac, new byte[][]{{-1, -15}});
        _root.addPath(FileType.Aac, new byte[][]{{-1, -7}});
        _root.addPath(FileType.Asf, new byte[][]{{48, 38, -78, 117, -114, 102, -49, 17, -90, -39, 0, -86, 0, 98, -50, 108}});
        _root.addPath(FileType.Cfbf, new byte[][]{{-48, -49, 17, -32, -95, -79, 26, -31, 0}});
        _root.addPath(FileType.Flv, new byte[][]{{70, 76, 86}});
        _root.addPath(FileType.Indd, new byte[][]{{6, 6, -19, -11, -40, 29, 70, -27, -67, 49, -17, -25, -2, 116, -73, 29}});
        _root.addPath(FileType.Mxf, new byte[][]{{6, 14, 43, 52, 2, 5, 1, 1, 13, 1, 2, 1, 1, 2}});
        _root.addPath(FileType.Qxp, new byte[][]{{0, 0, 73, 73, 88, 80, 82, 51}});
        _root.addPath(FileType.Qxp, new byte[][]{{0, 0, 77, 77, 88, 80, 82, 51}});
        _root.addPath(FileType.Ram, new byte[][]{{114, 116, 115, 112, 58, 47, 47}});
        _root.addPath(FileType.Rtf, new byte[][]{{123, 92, 114, 116, 102, 49}});
        _root.addPath(FileType.Sit, new byte[][]{{83, 73, 84, 33, 0}});
        _root.addPath(FileType.Sit, new byte[][]{{83, 116, 117, 102, 102, 73, 116, 32, 40, 99, 41, 49, 57, 57, 55, 45}});
        _root.addPath(FileType.Sitx, new byte[][]{{83, 116, 117, 102, 102, 73, 116, 33}});
        _root.addPath(FileType.Swf, new byte[][]{"CWS".getBytes()});
        _root.addPath(FileType.Swf, new byte[][]{"FWS".getBytes()});
        _root.addPath(FileType.Swf, new byte[][]{"ZWS".getBytes()});
        _root.addPath(FileType.Vob, new byte[][]{{0, 0, 1, -70}});
        _root.addPath(FileType.Zip, new byte[][]{"PK".getBytes()});
    }
}

