/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.DoubleConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

class DoubleStreamReplaceFunction
extends DoubleValueStream.AbstractDoubleValueStream {
    private final DoubleValueStream baseExpr;
    private final DoubleValue compExpr;
    private final DoubleValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public DoubleStreamReplaceFunction(DoubleValueStream baseExpr, DoubleValue compExpr, DoubleValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        double compValue = this.compExpr.getDouble();
        if (this.compExpr.exists()) {
            double fillValue = this.fillExpr.getDouble();
            boolean fillExists = this.fillExpr.exists();
            this.baseExpr.streamDoubles(value -> {
                if (value == compValue) {
                    if (fillExists) {
                        cons.accept(fillValue);
                    }
                } else {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamDoubles(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

