/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Sets {
    public static HashSet newHashSet() {
        return new HashSet();
    }

    public static HashSet newHashSetWithExpectedSize(int n) {
        return new HashSet(Maps.capacity(n));
    }

    public static Set newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    static int hashCodeImpl(Set set) {
        int n = 0;
        for (Object e : set) {
            n += e != null ? e.hashCode() : 0;
            n = ~(~n);
        }
        return n;
    }

    static boolean equalsImpl(Set set, @NullableDecl Object object) {
        if (set == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set2 = (Set)object;
            try {
                return set.size() == set2.size() && set.containsAll(set2);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }
        return false;
    }

    static boolean removeAllImpl(Set set, Iterator iterator) {
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= set.remove(iterator.next());
        }
        return bl;
    }

    static boolean removeAllImpl(Set set, Collection collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection);
        }
        return Sets.removeAllImpl(set, collection.iterator());
    }
}

