/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Optionality;

public class SqlJsonObjectAggAggFunction
extends SqlAggFunction {
    private final SqlJsonConstructorNullClause nullClause;

    public SqlJsonObjectAggAggFunction(String name, SqlJsonConstructorNullClause nullClause) {
        super(name, null, SqlKind.JSON_OBJECTAGG, ReturnTypes.VARCHAR_2000, null, OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM, false, false, Optionality.FORBIDDEN);
        this.nullClause = Objects.requireNonNull(nullClause);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startFunCall("JSON_OBJECTAGG");
        writer.keyword("KEY");
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.keyword("VALUE");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.nullClause.sql);
        writer.endFunCall(frame);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            ((SqlValidatorImpl)validator).setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public String toString() {
        return this.getName() + String.format(Locale.ROOT, "<%s>", new Object[]{this.nullClause});
    }

    public SqlJsonObjectAggAggFunction with(SqlJsonConstructorNullClause nullClause) {
        return this.nullClause == nullClause ? this : new SqlJsonObjectAggAggFunction(this.getName(), nullClause);
    }

    public SqlJsonConstructorNullClause getNullClause() {
        return this.nullClause;
    }
}

