/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.ToleratedUpdateError;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TolerantUpdateProcessor
extends UpdateRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String UNKNOWN_ID = "(unknown)";
    private final NamedList<Object> header;
    private final int maxErrors;
    private SchemaField uniqueKeyField;
    private final SolrQueryRequest req;
    private ZkController zkController;
    private final List<ToleratedUpdateError> knownErrors = new ArrayList<ToleratedUpdateError>();
    private Set<ToleratedUpdateError> knownDBQErrors = new HashSet<ToleratedUpdateError>();
    private final FirstErrTracker firstErrTracker = new FirstErrTracker();
    private final DistributedUpdateProcessor.DistribPhase distribPhase;

    public TolerantUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next, int maxErrors, DistributedUpdateProcessor.DistribPhase distribPhase) {
        super(next);
        assert (maxErrors >= -1);
        this.header = rsp.getResponseHeader();
        this.maxErrors = ToleratedUpdateError.getEffectiveMaxErrors((int)maxErrors);
        this.req = req;
        this.distribPhase = distribPhase;
        assert (!DistributedUpdateProcessor.DistribPhase.FROMLEADER.equals((Object)distribPhase));
        this.zkController = this.req.getCore().getCoreContainer().getZkController();
        this.uniqueKeyField = this.req.getCore().getLatestSchema().getUniqueKeyField();
        assert (null != this.uniqueKeyField) : "Factory didn't enforce uniqueKey field?";
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        block2: {
            BytesRef id = null;
            try {
                id = cmd.getIndexedId();
                super.processAdd(cmd);
            }
            catch (Throwable t) {
                this.firstErrTracker.caught(t);
                this.knownErrors.add(new ToleratedUpdateError(ToleratedUpdateError.CmdType.ADD, this.getPrintableId(id), t.getMessage()));
                if (this.knownErrors.size() <= this.maxErrors) break block2;
                this.firstErrTracker.throwFirst();
            }
        }
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        block3: {
            try {
                super.processDelete(cmd);
            }
            catch (Throwable t) {
                this.firstErrTracker.caught(t);
                ToleratedUpdateError err = new ToleratedUpdateError(cmd.isDeleteById() ? ToleratedUpdateError.CmdType.DELID : ToleratedUpdateError.CmdType.DELQ, cmd.isDeleteById() ? cmd.id : cmd.query, t.getMessage());
                this.knownErrors.add(err);
                if (ToleratedUpdateError.CmdType.DELQ.equals((Object)err.getType())) {
                    this.knownDBQErrors.add(err);
                }
                if (this.knownErrors.size() <= this.maxErrors) break block3;
                this.firstErrTracker.throwFirst();
            }
        }
    }

    @Override
    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        try {
            super.processMergeIndexes(cmd);
        }
        catch (Throwable t) {
            this.firstErrTracker.caught(t);
            throw t;
        }
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        try {
            super.processCommit(cmd);
        }
        catch (Throwable t) {
            this.firstErrTracker.caught(t);
            throw t;
        }
    }

    @Override
    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        try {
            super.processRollback(cmd);
        }
        catch (Throwable t) {
            this.firstErrTracker.caught(t);
            throw t;
        }
    }

    @Override
    public void finish() throws IOException {
        try {
            super.finish();
        }
        catch (DistributedUpdateProcessor.DistributedUpdatesAsyncException duae) {
            this.firstErrTracker.caught((Throwable)((Object)duae));
            for (SolrCmdDistributor.Error error : duae.errors) {
                if (!(error.e instanceof SolrException)) {
                    log.error("async update exception is not SolrException, no metadata to process", (Throwable)error.e);
                    continue;
                }
                SolrException remoteErr = (SolrException)((Object)error.e);
                NamedList remoteErrMetadata = remoteErr.getMetadata();
                if (null == remoteErrMetadata) {
                    log.warn("remote error has no metadata to aggregate: {} {}", (Object)remoteErr.getMessage(), (Object)remoteErr);
                    continue;
                }
                for (int i = 0; i < remoteErrMetadata.size(); ++i) {
                    ToleratedUpdateError err = ToleratedUpdateError.parseMetadataIfToleratedUpdateError((String)remoteErrMetadata.getName(i), (String)((String)remoteErrMetadata.getVal(i)));
                    if (null == err) continue;
                    if (ToleratedUpdateError.CmdType.DELQ.equals((Object)err.getType())) {
                        if (this.knownDBQErrors.contains(err)) continue;
                        this.knownDBQErrors.add(err);
                    }
                    this.knownErrors.add(err);
                }
            }
        }
        this.header.add("errors", (Object)ToleratedUpdateError.formatForResponseHeader(this.knownErrors));
        this.header.add("maxErrors", (Object)ToleratedUpdateError.getUserFriendlyMaxErrors((int)this.maxErrors));
        this.firstErrTracker.annotate(this.knownErrors);
        if ((DistributedUpdateProcessor.DistribPhase.TOLEADER.equals((Object)this.distribPhase) ? 0 : this.maxErrors) < this.knownErrors.size()) {
            this.firstErrTracker.throwFirst();
        }
    }

    private String getPrintableId(BytesRef ref) {
        if (ref == null) {
            return UNKNOWN_ID;
        }
        return this.uniqueKeyField.getType().indexedToReadable(ref, new CharsRefBuilder()).toString();
    }

    private static final class FirstErrTracker {
        SolrException first = null;
        boolean thrown = false;

        public void caught(Throwable t) {
            assert (null != t);
            if (null == this.first) {
                this.first = t instanceof SolrException ? (SolrException)t : new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Tolerantly Caught Exception: " + t.getMessage(), t);
            }
        }

        public void throwFirst() throws SolrException {
            assert (null != this.first) : "caught was never called?";
            if (!this.thrown) {
                this.thrown = true;
                throw this.first;
            }
        }

        public void annotate(List<ToleratedUpdateError> errors) {
            if (null == this.first) {
                return;
            }
            assert (null != errors) : "how do we have an exception to annotate w/o any errors?";
            NamedList firstErrMetadata = this.first.getMetadata();
            if (null == firstErrMetadata) {
                firstErrMetadata = new NamedList();
                this.first.setMetadata(firstErrMetadata);
            } else {
                for (int i = 0; i < firstErrMetadata.size(); ++i) {
                    if (null == ToleratedUpdateError.parseMetadataIfToleratedUpdateError((String)firstErrMetadata.getName(i), (String)((String)firstErrMetadata.getVal(i)))) continue;
                    firstErrMetadata.remove(i);
                    --i;
                }
            }
            for (ToleratedUpdateError te : errors) {
                firstErrMetadata.add(te.getMetadataKey(), (Object)te.getMetadataValue());
            }
        }

        public SolrException getFirst() {
            return this.first;
        }
    }
}

