/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners.antxml;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.Transform;

final class XmlStringTransformer
implements Transform {
    private final StringBuilder buffer = new StringBuilder();

    XmlStringTransformer() {
    }

    @Override
    public String read(String string) {
        return string;
    }

    public String write(String string) {
        if (!XmlStringTransformer.isMappableXmlText(string)) {
            return this.remap(string);
        }
        return string;
    }

    private String remap(CharSequence charSequence) {
        this.buffer.setLength(0);
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Character.codePointAt(charSequence, n2);
            if (n3 >= 32 && n3 <= 55295 || n3 < 32 && (n3 == 9 || n3 == 10 || n3 == 13) || n3 >= 57344 && n3 <= 65533 || n3 >= 65536 && n3 <= 0x10FFFF) {
                this.buffer.appendCodePoint(n3);
            } else {
                this.buffer.append("\ufffd");
            }
            n2 = Character.offsetByCodePoints(charSequence, n2, 1);
        }
        return this.buffer.toString();
    }

    private static boolean isMappableXmlText(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Character.codePointAt(charSequence, n2);
            if (!(n3 >= 32 && n3 <= 55295 || n3 < 32 && (n3 == 9 || n3 == 10 || n3 == 13) || n3 >= 57344 && n3 <= 65533 || n3 >= 65536 && n3 <= 0x10FFFF)) {
                return false;
            }
            n2 = Character.offsetByCodePoints(charSequence, n2, 1);
        }
        return true;
    }
}

