/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.mirrors;

import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class FailureMirror {
    private String message;
    private String trace;
    private String throwableString;
    private String throwableClass;
    private boolean assertionViolation;
    private boolean assumptionViolation;
    private Description description;

    public FailureMirror(Description description, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.message = string;
        this.trace = string2;
        this.throwableString = string3;
        this.throwableClass = string4;
        this.assertionViolation = bl;
        this.assumptionViolation = bl2;
        this.description = description;
    }

    public FailureMirror(Failure failure) {
        this.message = failure.getMessage();
        this.description = failure.getDescription();
        this.trace = failure.getTrace();
        Throwable throwable = failure.getException();
        this.assertionViolation = throwable instanceof AssertionError;
        this.assumptionViolation = throwable instanceof AssumptionViolatedException;
        this.throwableString = throwable.toString();
        this.throwableClass = throwable.getClass().getName();
    }

    public String getMessage() {
        return this.message;
    }

    public String getThrowableString() {
        return this.throwableString;
    }

    public Description getDescription() {
        return this.description;
    }

    public String getTrace() {
        return this.trace;
    }

    public boolean isAssumptionViolation() {
        return this.assumptionViolation;
    }

    public boolean isAssertionViolation() {
        return this.assertionViolation;
    }

    public boolean isErrorViolation() {
        return !this.isAssertionViolation() && !this.isAssumptionViolation();
    }

    public String getThrowableClass() {
        return this.throwableClass;
    }
}

