/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.AfterEffectB;
import org.apache.lucene.search.similarities.AfterEffectL;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicModelG;
import org.apache.lucene.search.similarities.BasicModelIF;
import org.apache.lucene.search.similarities.BasicModelIn;
import org.apache.lucene.search.similarities.BasicModelIne;
import org.apache.lucene.search.similarities.DFRSimilarity;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.NormalizationH1;
import org.apache.lucene.search.similarities.NormalizationH2;
import org.apache.lucene.search.similarities.NormalizationH3;
import org.apache.lucene.search.similarities.NormalizationZ;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.SimilarityFactory;

public class DFRSimilarityFactory
extends SimilarityFactory {
    private boolean discountOverlaps;
    private BasicModel basicModel;
    private AfterEffect afterEffect;
    private Normalization normalization;

    @Override
    public void init(SolrParams params) {
        super.init(params);
        this.discountOverlaps = params.getBool("discountOverlaps", true);
        this.basicModel = this.parseBasicModel(params.get("basicModel"));
        this.afterEffect = this.parseAfterEffect(params.get("afterEffect"));
        this.normalization = DFRSimilarityFactory.parseNormalization(params.get("normalization"), params.get("c"), params.get("mu"), params.get("z"));
    }

    private BasicModel parseBasicModel(String expr) {
        if ("G".equals(expr)) {
            return new BasicModelG();
        }
        if ("I(F)".equals(expr)) {
            return new BasicModelIF();
        }
        if ("I(n)".equals(expr)) {
            return new BasicModelIn();
        }
        if ("I(ne)".equals(expr)) {
            return new BasicModelIne();
        }
        throw new RuntimeException("Invalid basicModel: " + expr);
    }

    private AfterEffect parseAfterEffect(String expr) {
        if ("B".equals(expr)) {
            return new AfterEffectB();
        }
        if ("L".equals(expr)) {
            return new AfterEffectL();
        }
        throw new RuntimeException("Invalid afterEffect: " + expr);
    }

    static Normalization parseNormalization(String expr, String c, String mu, String z) {
        if (mu != null && !"H3".equals(expr)) {
            throw new RuntimeException("parameter mu only makes sense for normalization H3");
        }
        if (z != null && !"Z".equals(expr)) {
            throw new RuntimeException("parameter z only makes sense for normalization Z");
        }
        if (c != null && !"H1".equals(expr) && !"H2".equals(expr)) {
            throw new RuntimeException("parameter c only makese sense for normalizations H1 and H2");
        }
        if ("H1".equals(expr)) {
            return c != null ? new NormalizationH1(Float.parseFloat(c)) : new NormalizationH1();
        }
        if ("H2".equals(expr)) {
            return c != null ? new NormalizationH2(Float.parseFloat(c)) : new NormalizationH2();
        }
        if ("H3".equals(expr)) {
            return mu != null ? new NormalizationH3(Float.parseFloat(mu)) : new NormalizationH3();
        }
        if ("Z".equals(expr)) {
            return z != null ? new NormalizationZ(Float.parseFloat(z)) : new NormalizationZ();
        }
        if ("none".equals(expr)) {
            return new Normalization.NoNormalization();
        }
        throw new RuntimeException("Invalid normalization: " + expr);
    }

    @Override
    public Similarity getSimilarity() {
        DFRSimilarity sim = new DFRSimilarity(this.basicModel, this.afterEffect, this.normalization);
        sim.setDiscountOverlaps(this.discountOverlaps);
        return sim;
    }
}

