/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.RetryUtil;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardLeaderElectionContextBase
extends ElectionContext {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrZkClient zkClient;
    protected String shardId;
    protected String collection;
    protected LeaderElector leaderElector;
    protected ZkStateReader zkStateReader;
    protected ZkController zkController;
    private Integer leaderZkNodeParentVersion;
    private final Object lock = new Object();

    public ShardLeaderElectionContextBase(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkController zkController) {
        super(coreNodeName, "/collections/" + collection + "/leader_elect/" + shardId, ZkStateReader.getShardLeadersPath((String)collection, (String)shardId), props, zkController.getZkClient());
        this.leaderElector = leaderElector;
        this.zkStateReader = zkController.getZkStateReader();
        this.zkClient = this.zkStateReader.getZkClient();
        this.zkController = zkController;
        this.shardId = shardId;
        this.collection = collection;
        String parent = new Path(this.leaderPath).getParent().toString();
        ZkCmdExecutor zcmd = new ZkCmdExecutor(30000);
        log.info("make sure parent is created {}", (Object)parent);
        try {
            zcmd.ensureExists(parent, (byte[])null, CreateMode.PERSISTENT, this.zkClient, 2);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelElection() throws InterruptedException, KeeperException {
        super.cancelElection();
        Object object = this.lock;
        synchronized (object) {
            if (this.leaderZkNodeParentVersion != null) {
                try {
                    log.debug("Removing leader registration node on cancel: {} {}", (Object)this.leaderPath, (Object)this.leaderZkNodeParentVersion);
                    ArrayList<Op> ops = new ArrayList<Op>(2);
                    ops.add(Op.check((String)new Path(this.leaderPath).getParent().toString(), (int)this.leaderZkNodeParentVersion));
                    ops.add(Op.delete((String)this.leaderPath, (int)-1));
                    this.zkClient.multi(ops, true);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    SolrException.log((Logger)log, (Throwable)e);
                }
                this.leaderZkNodeParentVersion = null;
            } else {
                log.info("No version found for ephemeral leader parent node, won't remove previous leader registration.");
            }
        }
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStartMs) throws KeeperException, InterruptedException, IOException {
        Replica leader;
        String parent = new Path(this.leaderPath).getParent().toString();
        try {
            RetryUtil.retryOnThrowable(KeeperException.NodeExistsException.class, (long)60000L, (long)5000L, () -> {
                Object object = this.lock;
                synchronized (object) {
                    log.info("Creating leader registration node {} after winning as {}", (Object)this.leaderPath, (Object)this.leaderSeqPath);
                    ArrayList<Op> ops = new ArrayList<Op>(2);
                    ops.add(Op.check((String)this.leaderSeqPath, (int)-1));
                    ops.add(Op.create((String)this.leaderPath, (byte[])Utils.toJSON((Object)this.leaderProps), (List)this.zkClient.getZkACLProvider().getACLsToAdd(this.leaderPath), (CreateMode)CreateMode.EPHEMERAL));
                    ops.add(Op.setData((String)parent, null, (int)-1));
                    List results = this.zkClient.multi(ops, true);
                    for (OpResult result : results) {
                        if (result.getType() != 5) continue;
                        OpResult.SetDataResult dresult = (OpResult.SetDataResult)result;
                        Stat stat = dresult.getStat();
                        this.leaderZkNodeParentVersion = stat.getVersion();
                        return;
                    }
                    assert (this.leaderZkNodeParentVersion != null);
                }
            });
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Will not register as leader because it seems the election is no longer taking place.");
            return;
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not register as the leader because creating the ephemeral registration node in ZooKeeper failed", t);
        }
        assert (this.shardId != null);
        boolean isAlreadyLeader = false;
        if (this.zkStateReader.getClusterState() != null && this.zkStateReader.getClusterState().getCollection(this.collection).getSlice(this.shardId).getReplicas().size() < 2 && (leader = this.zkStateReader.getLeader(this.collection, this.shardId)) != null && leader.getBaseUrl().equals(this.leaderProps.get("base_url")) && leader.getCoreName().equals(this.leaderProps.get("core"))) {
            isAlreadyLeader = true;
        }
        if (!isAlreadyLeader) {
            ZkNodeProps m = ZkNodeProps.fromKeyVals((Object[])new Object[]{"operation", OverseerAction.LEADER.toLower(), "shard", this.shardId, "collection", this.collection, "base_url", this.leaderProps.get("base_url"), "core", this.leaderProps.get("core"), "state", Replica.State.ACTIVE.toString()});
            assert (this.zkController != null);
            assert (this.zkController.getOverseer() != null);
            this.zkController.getOverseer().offerStateUpdate(Utils.toJSON((Object)m));
        }
    }

    public LeaderElector getLeaderElector() {
        return this.leaderElector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getLeaderZkNodeParentVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.leaderZkNodeParentVersion;
        }
    }
}

