/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.ssl;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.data.Parameter;
import org.restlet.engine.ssl.DefaultSslContext;
import org.restlet.engine.ssl.SslContextFactory;
import org.restlet.util.Series;

public class DefaultSslContextFactory
extends SslContextFactory {
    private volatile String[] disabledCipherSuites = null;
    private volatile String[] disabledProtocols = null;
    private volatile String[] enabledCipherSuites = null;
    private volatile String[] enabledProtocols = null;
    private volatile String keyManagerAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm", "SunX509");
    private volatile char[] keyStoreKeyPassword = System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")) != null ? System.getProperty("javax.net.ssl.keyPassword", System.getProperty("javax.net.ssl.keyStorePassword")).toCharArray() : null;
    private volatile char[] keyStorePassword;
    private volatile String keyStorePath;
    private volatile String keyStoreProvider;
    private volatile String keyStoreType;
    private volatile boolean needClientAuthentication;
    private volatile String protocol;
    private volatile String secureRandomAlgorithm;
    private volatile String trustManagerAlgorithm;
    private volatile char[] trustStorePassword;
    private volatile String trustStorePath;
    private volatile String trustStoreProvider;
    private volatile String trustStoreType;
    private volatile boolean wantClientAuthentication;

    public DefaultSslContextFactory() {
        char[] cArray = this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword") != null ? System.getProperty("javax.net.ssl.keyStorePassword").toCharArray() : null;
        this.keyStorePath = System.getProperty("javax.net.ssl.keyStore", System.getProperty("user.home") != null ? (System.getProperty("user.home").endsWith("/") ? System.getProperty("user.home") + ".keystore" : System.getProperty("user.home") + "/.keystore") : null);
        this.keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
        this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
        this.needClientAuthentication = false;
        this.protocol = "TLS";
        this.secureRandomAlgorithm = null;
        this.trustManagerAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm", "SunX509");
        this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword").toCharArray() : null;
        this.trustStorePath = System.getProperty("javax.net.ssl.trustStore");
        this.trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
        this.trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
        this.wantClientAuthentication = false;
    }

    protected final DefaultSslContextFactory clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLContext createSslContext() throws Exception {
        SSLContext result = null;
        KeyManagerFactory kmf = null;
        if (this.keyStorePath != null || this.keyStoreProvider != null || this.keyStoreType != null) {
            KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
            try (FileInputStream keyStoreInputStream = null;){
                keyStoreInputStream = this.keyStorePath != null && !"NONE".equals(this.keyStorePath) ? new FileInputStream(this.keyStorePath) : null;
                keyStore.load(keyStoreInputStream, this.keyStorePassword);
            }
            kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
            kmf.init(keyStore, this.keyStoreKeyPassword);
        }
        TrustManagerFactory tmf = null;
        if (this.trustStorePath != null || this.trustStoreProvider != null || this.trustStoreType != null) {
            KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
            try (FileInputStream trustStoreInputStream = null;){
                trustStoreInputStream = this.trustStorePath != null && !"NONE".equals(this.trustStorePath) ? new FileInputStream(this.trustStorePath) : null;
                trustStore.load(trustStoreInputStream, this.trustStorePassword);
            }
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            tmf.init(trustStore);
        }
        SSLContext sslContext = SSLContext.getInstance(this.protocol);
        SecureRandom sr = null;
        if (this.secureRandomAlgorithm != null) {
            sr = SecureRandom.getInstance(this.secureRandomAlgorithm);
        }
        sslContext.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, sr);
        result = this.createWrapper(sslContext);
        return result;
    }

    protected SSLContext createWrapper(SSLContext sslContext) {
        return new DefaultSslContext(this, sslContext);
    }

    public String[] getDisabledCipherSuites() {
        return this.disabledCipherSuites;
    }

    public String[] getDisabledProtocols() {
        return this.disabledProtocols;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public char[] getKeyStoreKeyPassword() {
        return this.keyStoreKeyPassword;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public String[] getSelectedCipherSuites(String[] supportedCipherSuites) {
        HashSet<String> resultSet = new HashSet<String>();
        if (supportedCipherSuites != null) {
            for (String supportedCipherSuite : supportedCipherSuites) {
                if (this.getEnabledCipherSuites() != null && !Arrays.asList(this.getEnabledCipherSuites()).contains(supportedCipherSuite) || this.getDisabledCipherSuites() != null && Arrays.asList(this.getDisabledCipherSuites()).contains(supportedCipherSuite)) continue;
                resultSet.add(supportedCipherSuite);
            }
        }
        String[] result = new String[resultSet.size()];
        return resultSet.toArray(result);
    }

    public String[] getSelectedSslProtocols(String[] supportedProtocols) {
        HashSet<String> resultSet = new HashSet<String>();
        if (supportedProtocols != null) {
            for (String supportedProtocol : supportedProtocols) {
                if (this.getEnabledProtocols() != null && !Arrays.asList(this.getEnabledProtocols()).contains(supportedProtocol) || this.getDisabledProtocols() != null && Arrays.asList(this.getDisabledProtocols()).contains(supportedProtocol)) continue;
                resultSet.add(supportedProtocol);
            }
        }
        String[] result = new String[resultSet.size()];
        return resultSet.toArray(result);
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Override
    public void init(Series<Parameter> helperParameters) {
        String[] disabledCipherSuitesArray = helperParameters.getValuesArray("disabledCipherSuites");
        HashSet<String> disabledCipherSuites = new HashSet<String>();
        for (String disabledCipherSuiteSeries : disabledCipherSuitesArray) {
            for (String disabledCipherSuite : disabledCipherSuiteSeries.split(" ")) {
                disabledCipherSuites.add(disabledCipherSuite);
            }
        }
        if (disabledCipherSuites.size() > 0) {
            disabledCipherSuitesArray = new String[disabledCipherSuites.size()];
            disabledCipherSuites.toArray(disabledCipherSuitesArray);
            this.setDisabledCipherSuites(disabledCipherSuitesArray);
        } else {
            this.setDisabledCipherSuites(null);
        }
        String[] disabledProtocolsArray = helperParameters.getValuesArray("disabledProtocols");
        HashSet<String> disabledProtocols = new HashSet<String>();
        for (String disabledProtocolsSeries : disabledProtocolsArray) {
            for (String disabledProtocol : disabledProtocolsSeries.split(" ")) {
                disabledProtocols.add(disabledProtocol);
            }
        }
        if (disabledProtocols.size() > 0) {
            disabledProtocolsArray = new String[disabledProtocols.size()];
            disabledProtocols.toArray(disabledProtocolsArray);
            this.setDisabledProtocols(disabledProtocolsArray);
        } else {
            this.setDisabledProtocols(null);
        }
        String[] enabledCipherSuitesArray = helperParameters.getValuesArray("enabledCipherSuites");
        HashSet<String> enabledCipherSuites = new HashSet<String>();
        for (String enabledCipherSuiteSeries : enabledCipherSuitesArray) {
            for (String enabledCipherSuite : enabledCipherSuiteSeries.split(" ")) {
                enabledCipherSuites.add(enabledCipherSuite);
            }
        }
        if (enabledCipherSuites.size() > 0) {
            enabledCipherSuitesArray = new String[enabledCipherSuites.size()];
            enabledCipherSuites.toArray(enabledCipherSuitesArray);
            this.setEnabledCipherSuites(enabledCipherSuitesArray);
        } else {
            this.setEnabledCipherSuites(null);
        }
        String[] enabledProtocolsArray = helperParameters.getValuesArray("enabledProtocols");
        HashSet<String> enabledProtocols = new HashSet<String>();
        for (String enabledProtocolSeries : enabledProtocolsArray) {
            for (String enabledProtocol : enabledProtocolSeries.split(" ")) {
                enabledProtocols.add(enabledProtocol);
            }
        }
        if (enabledProtocols.size() > 0) {
            enabledProtocolsArray = new String[enabledProtocols.size()];
            enabledProtocols.toArray(enabledProtocolsArray);
            this.setEnabledProtocols(enabledProtocolsArray);
        } else {
            this.setEnabledProtocols(null);
        }
        this.setKeyManagerAlgorithm(helperParameters.getFirstValue("keyManagerAlgorithm", true, System.getProperty("ssl.KeyManagerFactory.algorithm", "SunX509")));
        this.setKeyStorePassword(helperParameters.getFirstValue("keyStorePassword", true, System.getProperty("javax.net.ssl.keyStorePassword", "")));
        this.setKeyStoreKeyPassword(helperParameters.getFirstValue("keyPassword", true, System.getProperty("javax.net.ssl.keyPassword")));
        if (this.keyStoreKeyPassword == null) {
            this.keyStoreKeyPassword = this.keyStorePassword;
        }
        this.setKeyStorePath(helperParameters.getFirstValue("keyStorePath", true, System.getProperty("javax.net.ssl.keyStore")));
        this.setKeyStoreType(helperParameters.getFirstValue("keyStoreType", true, System.getProperty("javax.net.ssl.keyStoreType")));
        this.setNeedClientAuthentication(Boolean.parseBoolean(helperParameters.getFirstValue("needClientAuthentication", true, "false")));
        this.setProtocol(helperParameters.getFirstValue("protocol", true, "TLS"));
        this.setSecureRandomAlgorithm(helperParameters.getFirstValue("secureRandomAlgorithm", true));
        this.setTrustManagerAlgorithm(helperParameters.getFirstValue("trustManagerAlgorithm", true, System.getProperty("ssl.TrustManagerFactory.algorithm", "SunX509")));
        this.setTrustStorePassword(helperParameters.getFirstValue("trustStorePassword", true, System.getProperty("javax.net.ssl.trustStorePassword")));
        this.setTrustStorePath(helperParameters.getFirstValue("trustStorePath", true, System.getProperty("javax.net.ssl.trustStore")));
        this.setTrustStoreType(helperParameters.getFirstValue("trustStoreType", true, System.getProperty("javax.net.ssl.trustStoreType")));
        this.setWantClientAuthentication(Boolean.parseBoolean(helperParameters.getFirstValue("wantClientAuthentication", true, "false")));
    }

    public boolean isNeedClientAuthentication() {
        return this.needClientAuthentication;
    }

    public boolean isWantClientAuthentication() {
        return this.wantClientAuthentication;
    }

    public void setDisabledCipherSuites(String[] disabledCipherSuites) {
        this.disabledCipherSuites = disabledCipherSuites;
    }

    public void setDisabledProtocols(String[] disabledProtocols) {
        this.disabledProtocols = disabledProtocols;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public void setKeyStoreKeyPassword(char[] keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword;
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = keyStoreKeyPassword != null ? keyStoreKeyPassword.toCharArray() : null;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setNeedClientAuthentication(boolean needClientAuthentication) {
        this.needClientAuthentication = needClientAuthentication;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setWantClientAuthentication(boolean wantClientAuthentication) {
        this.wantClientAuthentication = wantClientAuthentication;
    }
}

