
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was LibAlkimiaConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

find_package(KDE4 REQUIRED)
find_package(GMP REQUIRED)

include("${CMAKE_CURRENT_LIST_DIR}/LibAlkimiaTargets.cmake")

set_and_check( LIBALKIMIA_INCLUDE_DIR "/usr/local/include/kde4")

set( LIBALKIMIA_INCLUDE_DIRS ${LIBALKIMIA_INCLUDE_DIR} ${GMP_INCLUDE_DIR} )

set( LIBALKIMIA_LIBRARIES
  Alkimia::alkimia
  ${QT_QTCORE_LIBRARY}
  ${QT_QTDBUS_LIBRARY}
  ${GMP_LIBRARIES}
)

message(STATUS "Found LibAlkimia: ${CMAKE_CURRENT_LIST_DIR}/LibAlkimiaConfig.cmake (found version \"5.0.0\")")
