/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TRANSLATE_H
#define _TRANSLATE_H

#include <translate-common.h>
#include <translate-pair.h>
#include <translate-service.h>
#include <translate-session.h>
#include <translate-util.h>

G_BEGIN_DECLS

#define TRANSLATE_MAJOR_VERSION		0
#define TRANSLATE_MINOR_VERSION		99
#define TRANSLATE_MICRO_VERSION		0

extern const unsigned int		translate_major_version;
extern const unsigned int		translate_minor_version;
extern const unsigned int		translate_micro_version;

#define TRANSLATE_ERROR			(translate_error_quark())
#define TRANSLATE_INIT_ERROR		(translate_init_error_quark())

typedef enum
{
  TRANSLATE_ERROR_FAILED,
  TRANSLATE_ERROR_CANCELLED
} TranslateError;

typedef enum
{
  TRANSLATE_INIT_ERROR_MULTI_THREADING_NOT_SUPPORTED
} TranslateInitError;

GQuark		   translate_error_quark	(void);
GQuark		   translate_init_error_quark	(void);

/**
 * TranslateModuleInitFunc:
 * @err: a location to report errors, or %NULL.
 *
 * Specifies the type of the module initialization function.
 *
 * A libtranslate module must contain a function named
 * translate_module_init(), which is called when the module is loaded.
 *
 * Return value: the function should return %FALSE if the module could
 * not be initialized. In such case it should also set @err, which is
 * printed by libtranslate.
 **/
typedef gboolean (*TranslateModuleInitFunc)	(GError		 **err);

extern gboolean	   translate_initialized;
gboolean	   translate_init		(GError		 **err);

gboolean	   translate_add_service	(TranslateService *service);
TranslateService  *translate_get_service	(const char	  *name);
GSList		  *translate_get_services	(void);

gboolean	   translate_add_language	(const char	  *tag,
						 const char	  *name);
const char	  *translate_get_language_name	(const char	  *tag);

void		   translate_set_proxy		(const char	  *uri);
char		  *translate_get_proxy		(void);

G_END_DECLS

#endif /* _TRANSLATE_H */
