/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.query;

import ca.sqlpower.query.Item;
import ca.sqlpower.query.Join;
import ca.sqlpower.query.Query;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.UUID;

public class SQLJoin
implements Join {
    private final Item leftColumn;
    private final Item rightColumn;
    private boolean leftColumnOuterJoin;
    private boolean rightColumnOuterJoin;
    private String comparator;
    private String name;
    private String uuid;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Query parent;

    public SQLJoin(Item leftColumn, Item rightColumn) {
        this.leftColumn = leftColumn;
        this.rightColumn = rightColumn;
        this.comparator = "=";
        this.leftColumnOuterJoin = false;
        this.rightColumnOuterJoin = false;
        this.uuid = "w" + UUID.randomUUID().toString();
    }

    @Override
    public Item getLeftColumn() {
        return this.leftColumn;
    }

    @Override
    public Item getRightColumn() {
        return this.rightColumn;
    }

    @Override
    public String getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(String comparator) {
        String oldComparator = this.comparator;
        this.comparator = comparator;
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "comparator", oldComparator, comparator));
    }

    @Override
    public boolean isLeftColumnOuterJoin() {
        return this.leftColumnOuterJoin;
    }

    @Override
    public void setLeftColumnOuterJoin(boolean isLeftColumnOuterJoin) {
        boolean oldVal = this.leftColumnOuterJoin;
        this.leftColumnOuterJoin = isLeftColumnOuterJoin;
        if (this.parent != null) {
            this.parent.startCompoundEdit("Changing join " + this.name + " for left column outer join to " + this.leftColumnOuterJoin);
        }
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "leftColumnOuterJoin", oldVal, this.leftColumnOuterJoin));
        if (this.parent != null) {
            this.parent.endCompoundEdit();
        }
    }

    @Override
    public boolean isRightColumnOuterJoin() {
        return this.rightColumnOuterJoin;
    }

    @Override
    public void setRightColumnOuterJoin(boolean isRightColumnOuterJoin) {
        boolean oldVal = this.rightColumnOuterJoin;
        this.rightColumnOuterJoin = isRightColumnOuterJoin;
        if (this.parent != null) {
            this.parent.startCompoundEdit("Changing join " + this.name + " for right column outer join to " + this.rightColumnOuterJoin);
        }
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "rightColumnOuterJoin", oldVal, this.rightColumnOuterJoin));
        if (this.parent != null) {
            this.parent.endCompoundEdit();
        }
    }

    @Override
    public void addJoinChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removeJoinChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void removeAllListeners() {
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.pcs.firePropertyChange("name", oldName, name);
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public SQLJoin createCopy(Item leftItemCopy, Item rightItemCopy) {
        SQLJoin join = new SQLJoin(leftItemCopy, rightItemCopy);
        join.setComparator(this.getComparator());
        join.setLeftColumnOuterJoin(this.isLeftColumnOuterJoin());
        join.setRightColumnOuterJoin(this.isRightColumnOuterJoin());
        join.setName(this.getName());
        return join;
    }

    public void setParent(Query parent) {
        this.parent = parent;
    }

    public Query getParent() {
        return this.parent;
    }

    public static enum Comparators {
        EQUAL_TO("="),
        GREATER_THAN(">"),
        LESS_THAN("<"),
        GREATER_EQUAL(">="),
        LESS_EQUAL("<="),
        NOT_EQUAL("<>"),
        BETWEEN("BETWEEN"),
        LIKE("LIKE"),
        NOT("NOT"),
        IN("IN");

        private String comparator;

        private Comparators(String op) {
            this.comparator = op;
        }

        public String getComparator() {
            return this.comparator;
        }
    }
}

