/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topics.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class TopicDialogPanel
extends JPanel {
    private JButton bgColourButton;
    private JLabel bgColourLabel;
    private JLabel descLabel;
    private JTextField descTextField;
    private JButton fgColourButton;
    private JLabel fgColourLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private Color fgColor;
    private Color bgColor;

    public TopicDialogPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.descLabel = new JLabel();
        this.descTextField = new JTextField();
        this.fgColourLabel = new JLabel();
        this.fgColourButton = new JButton();
        this.bgColourLabel = new JLabel();
        this.bgColourButton = new JButton();
        this.nameLabel.setBackground(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color"));
        this.nameLabel.setHorizontalAlignment(11);
        this.nameLabel.setText(NbBundle.getMessage(TopicDialogPanel.class, (String)"name"));
        this.descLabel.setBackground(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color"));
        this.descLabel.setHorizontalAlignment(11);
        this.descLabel.setText(NbBundle.getMessage(TopicDialogPanel.class, (String)"description"));
        this.fgColourLabel.setHorizontalAlignment(4);
        this.fgColourLabel.setText(NbBundle.getMessage(TopicDialogPanel.class, (String)"colour.text"));
        this.fgColourButton.setText(NbBundle.getMessage(TopicDialogPanel.class, (String)"colour.choose"));
        this.fgColourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TopicDialogPanel.this.textColourActionPerformed(evt);
            }
        });
        this.bgColourLabel.setHorizontalAlignment(4);
        this.bgColourLabel.setText(NbBundle.getMessage(TopicDialogPanel.class, (String)"colour.back"));
        this.bgColourButton.setText(NbBundle.getMessage(TopicDialogPanel.class, (String)"colour.choose"));
        this.bgColourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TopicDialogPanel.this.bgColourActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.nameLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.descLabel, -1, 83, Short.MAX_VALUE).add(1, (Component)this.fgColourLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.descTextField, -1, 314, Short.MAX_VALUE).add(2, (Component)this.nameTextField, -1, 314, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fgColourButton).addPreferredGap(0).add((Component)this.bgColourLabel, -2, 122, -2).addPreferredGap(0).add((Component)this.bgColourButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameTextField, -2, 22, -2).add((Component)this.nameLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descLabel).add((Component)this.descTextField, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fgColourButton).add((Component)this.fgColourLabel, -2, 18, -2).add((Component)this.bgColourLabel).add((Component)this.bgColourButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void bgColourActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, NbBundle.getMessage(TopicDialogPanel.class, (String)"choose.background.colour"), this.getBgColor());
        if (c != null) {
            this.setBgColor(c);
        }
    }

    private void textColourActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, NbBundle.getMessage(TopicDialogPanel.class, (String)"choose.text.colour"), this.getFgColor());
        if (c != null) {
            this.setFgColor(c);
        }
    }

    public void setTopicName(String name) {
        this.nameTextField.setText(name);
    }

    public String getTopicName() {
        return this.nameTextField.getText();
    }

    public void setDescription(String desc) {
        this.descTextField.setText(desc);
    }

    public String getDescription() {
        return this.descTextField.getText();
    }

    public void focus() {
        this.requestFocusInWindow();
        this.nameTextField.requestFocusInWindow();
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(Color fgColor) {
        this.fgColor = fgColor == null ? Color.BLACK : fgColor;
        this.nameTextField.setForeground(fgColor);
        this.descTextField.setForeground(fgColor);
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor == null ? Color.BLACK : bgColor;
        this.nameTextField.setBackground(bgColor);
        this.descTextField.setBackground(bgColor);
    }
}

