/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.dates;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class DatesPrefs {
    private static final Logger LOG = Logger.getLogger("tr.prefs.dates");
    public static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/dates");
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final String KEY_WEEK_FIRST_DAY = "week.first.day";
    private static final int DEF_WEEK_FIRST_DAY = Calendar.getInstance().getFirstDayOfWeek();
    public static final int MMDDYY = 0;
    public static final int DDMMYY = 1;
    public static final String KEY_DATE_ORDER = "date.order";
    private static final int DEF_DATE_ORDER = Locale.getDefault().getCountry().equals(Locale.US.getCountry()) ? 0 : 1;
    public static final int DF_LONG = 0;
    public static final int DF_MEDIUM = 2;
    public static final int DF_SHORT = 1;
    public static final String[][] DateFormats = new String[][]{{"EEE MMM d yyyy", "M/d/yy", "MM/dd/yyyy"}, {"EEE d MMM yyyy", "d/M/yy", "dd/MM/yyyy"}};

    public static final String formatLong(Date date) {
        int order = DatesPrefs.getDateOrder();
        SimpleDateFormat df = new SimpleDateFormat(DateFormats[order][0]);
        return df.format(date);
    }

    public static final String formatMedium(Date date) {
        int order = DatesPrefs.getDateOrder();
        SimpleDateFormat df = new SimpleDateFormat(DateFormats[order][2]);
        return df.format(date);
    }

    public static final String formatShort(Date date) {
        return DatesPrefs.format(date, 1);
    }

    private static final String format(Date date, int type) {
        int order = DatesPrefs.getDateOrder();
        SimpleDateFormat df = new SimpleDateFormat(DateFormats[order][type]);
        return df.format(date);
    }

    public static final int getFirstDayOfWeek() {
        return prefs.getInt(KEY_WEEK_FIRST_DAY, DEF_WEEK_FIRST_DAY);
    }

    public static final void setFirstDayOfWeek(int value) {
        if (value == 1 || value == 2) {
            prefs.putInt(KEY_WEEK_FIRST_DAY, value);
            DatesPrefs.flush();
        }
    }

    public static final int getDateOrder() {
        return prefs.getInt(KEY_DATE_ORDER, DEF_DATE_ORDER);
    }

    public static final void setDateOrder(int value) {
        if (value == 1 || value == 0) {
            prefs.putInt(KEY_DATE_ORDER, value);
            DatesPrefs.flush();
        }
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Date preferences error. " + ex.getMessage());
        }
    }
}

