/*
 * Decompiled with CFR 0.152.
 */
package tr.datastore;

import java.util.logging.Logger;
import tr.datastore.DataStore;
import tr.model.Data;
import tr.model.DataLookup;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;

public abstract class AbstractDataStore
extends ObservableImpl
implements DataStore,
Observer {
    private static final Logger LOG = Logger.getLogger("tr.datastore");
    private Data data;
    private boolean loaded;

    protected AbstractDataStore() {
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        LOG.fine("Start");
        if (this.data != null) {
            this.data.removeObserver((Observer)this);
        }
        this.data = data;
        DataLookup.instance().setData(data);
        if (data == null) {
            this.loaded = false;
        } else {
            this.loaded = true;
            data.resetObservers();
            data.addObserver((Observer)this);
        }
        this.notifyObservers(this);
    }

    public abstract void load() throws Exception;

    public abstract void store() throws Exception;

    public void setChanged(boolean changed) {
        if (this.data == null) {
            return;
        }
        if (this.data.hasChanged() != changed) {
            this.data.setChanged(changed);
        }
    }

    public boolean hasChanged() {
        if (this.data == null) {
            return false;
        }
        return this.data.hasChanged();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void update(Observable observable, Object arguement) {
        this.notifyObservers(observable, arguement);
    }
}

