/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTokenizer {
    private String delimiter;
    private boolean singleDelimiter;
    private char maxDelimiter;
    private List<String> tokens;
    protected String text;
    protected int position;
    protected int maxPosition;

    public SimpleTokenizer(String text, String delimiter) {
        this(text, delimiter, false);
    }

    public SimpleTokenizer(String text, String delimiter, boolean singleDelimiter) {
        this.setText(text);
        this.setDelimiter(delimiter);
        this.singleDelimiter = singleDelimiter;
    }

    public void setText(String text) {
        this.text = text;
        this.position = 0;
        this.maxPosition = text.length();
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.maxDelimiter = '\u0000';
        for (int i = 0; i < delimiter.length(); ++i) {
            char c = delimiter.charAt(i);
            if (this.maxDelimiter >= c) continue;
            this.maxDelimiter = c;
        }
    }

    public boolean hasMoreTokens() {
        return this.position <= this.maxPosition;
    }

    public String nextToken() {
        if (this.position > this.maxPosition) {
            throw new NoSuchElementException();
        }
        if (this.position == this.maxPosition) {
            ++this.position;
            return "";
        }
        return this.parseToken();
    }

    protected String parseToken() {
        if (this.singleDelimiter || this.delimiter.length() == 1) {
            return this.parseUsingSingleDelimiter();
        }
        return this.parseUsingMultipleDelimiters();
    }

    private String parseUsingSingleDelimiter() {
        String token = null;
        int delimiterPosition = 0;
        delimiterPosition = this.delimiter.length() == 1 ? this.text.indexOf(this.delimiter.charAt(0), this.position) : this.text.indexOf(this.delimiter, this.position);
        if (delimiterPosition == -1) {
            token = this.text.substring(this.position, this.maxPosition);
            this.position = this.maxPosition + 1;
        } else {
            token = this.text.substring(this.position, delimiterPosition);
            this.position = delimiterPosition + this.delimiter.length();
        }
        return token;
    }

    private String parseUsingMultipleDelimiters() {
        String token = null;
        int start = this.position;
        boolean searchingForDelimiter = true;
        while (this.position < this.maxPosition) {
            char c = this.text.charAt(this.position);
            if (c <= this.maxDelimiter && this.delimiter.indexOf(c) >= 0) {
                searchingForDelimiter = false;
                break;
            }
            ++this.position;
        }
        if (searchingForDelimiter) {
            token = this.text.substring(start, this.maxPosition);
            this.position = this.maxPosition + 1;
        } else {
            token = this.text.substring(start, this.position);
            ++this.position;
        }
        return token;
    }

    public String nextToken(int tokenCount) {
        while (--tokenCount > 0) {
            this.nextToken();
        }
        return this.nextToken();
    }

    public String getRemainder() {
        return this.hasMoreTokens() ? this.text.substring(this.position) : "";
    }

    public List<String> getAllTokens() {
        this.tokens = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            this.tokens.add(this.nextToken());
        }
        return this.tokens;
    }
}

