/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapConfiguration
extends AbstractConfiguration
implements Cloneable {
    protected Map<String, Object> map;
    private boolean trimmingDisabled;

    public MapConfiguration(Map<String, Object> map) {
        this.map = map;
    }

    public MapConfiguration(Properties props) {
        this.map = MapConfiguration.convertPropertiesToMap(props);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean isTrimmingDisabled() {
        return this.trimmingDisabled;
    }

    public void setTrimmingDisabled(boolean trimmingDisabled) {
        this.trimmingDisabled = trimmingDisabled;
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.map.get(key);
        if (value instanceof String && !this.isDelimiterParsingDisabled()) {
            List<String> list = PropertyConverter.split((String)value, this.getListDelimiter(), !this.isTrimmingDisabled());
            return list.size() > 1 ? list : list.get(0);
        }
        return value;
    }

    @Override
    protected void addPropertyDirect(String key, Object value) {
        Object previousValue = this.getProperty(key);
        if (previousValue == null) {
            this.map.put(key, value);
        } else if (previousValue instanceof List) {
            ((List)previousValue).add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(previousValue);
            list.add(value);
            this.map.put(key, list);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    protected void clearPropertyDirect(String key) {
        this.map.remove(key);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object clone() {
        try {
            Map clonedMap;
            MapConfiguration copy = (MapConfiguration)super.clone();
            copy.clearConfigurationListeners();
            copy.map = clonedMap = (Map)ConfigurationUtils.clone(this.map);
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }

    private static Map<String, Object> convertPropertiesToMap(Properties props) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (!(e.getKey() instanceof String)) continue;
            map.put((String)e.getKey(), e.getValue());
        }
        return map;
    }
}

