/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarHeader;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarHeaders {
    public static String TABLE_NAME = "headers";
    private List<HarHeader> headers = new ArrayList<HarHeader>();

    public HarHeaders() {
    }

    public HarHeaders(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("[ missing after \"headers\" element " + jp.getCurrentName(), jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            this.addHeader(new HarHeader(jp, warnings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarHeaders(HarDatabaseConfig config, long requestId, boolean isRequest) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,name,value,comment FROM " + tableName + " WHERE ref_id=? AND is_request=?");
            ps.setLong(1, requestId);
            ps.setInt(2, isRequest ? 1 : 0);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addHeader(new HarHeader(config, rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4)));
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeArrayFieldStart("headers");
        for (HarHeader header : this.headers) {
            header.writeHar(g);
        }
        g.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long requestId, HarDatabaseConfig config, boolean isRequest, long logId) throws SQLException {
        Connection c = config.getConnection();
        String headerTableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(headerTableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + headerTableName + " (id " + config.getDbAutoGeneratedId() + ",name " + config.getStringDbType() + ",value " + config.getStringDbType() + ",comment " + config.getStringDbType() + ",is_request " + config.getSmallIntDbType() + ",ref_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(headerTableName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        PreparedStatement headerPs = c.prepareStatement("INSERT INTO " + headerTableName + " (name,value,comment,is_request,ref_id) VALUES (?,?,?,?,?)", 1);
        try {
            for (HarHeader header : this.headers) {
                header.writeJDBC(config, requestId, headerPs, isRequest, logId);
            }
        }
        finally {
            try {
                if (headerPs != null) {
                    headerPs.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId, boolean isRequest) throws SQLException {
        String headersTableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(headersTableName)) {
            return;
        }
        Connection c = config.getConnection();
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + headersTableName + " WHERE ref_id IN (SELECT id FROM " + config.getTablePrefix() + (isRequest ? "request" : "response") + " WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?))");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, headersTableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void addHeader(HarHeader header) {
        this.headers.add(header);
    }

    public List<HarHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HarHeader> headers) {
        this.headers = headers;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("  \"headers\": [");
        if (this.headers != null) {
            boolean first = true;
            for (HarHeader header : this.headers) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(header);
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

