/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public abstract class TextAction
extends AbstractAction {
    public TextAction(String name) {
        super(name);
    }

    protected final JTextComponent getTextComponent(ActionEvent event) {
        Object source;
        JTextComponent target = null;
        if (event != null && (source = event.getSource()) instanceof JTextComponent) {
            target = (JTextComponent)source;
        }
        if (target == null) {
            target = this.getFocusedComponent();
        }
        return target;
    }

    public static final Action[] augmentList(Action[] list1, Action[] list2) {
        Object name;
        Action a;
        HashMap<Object, Action> actions = new HashMap<Object, Action>();
        int i = 0;
        while (i < list1.length) {
            a = list1[i];
            name = a.getValue("Name");
            actions.put(name != null ? name : "", a);
            ++i;
        }
        i = 0;
        while (i < list2.length) {
            a = list2[i];
            name = a.getValue("Name");
            actions.put(name != null ? name : "", a);
            ++i;
        }
        Action[] augmented = new Action[actions.size()];
        int i2 = 0;
        Iterator it = actions.values().iterator();
        while (it.hasNext()) {
            augmented[i2] = (Action)it.next();
            ++i2;
        }
        return augmented;
    }

    protected final JTextComponent getFocusedComponent() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focused = kfm.getPermanentFocusOwner();
        JTextComponent textComp = null;
        if (focused instanceof JTextComponent) {
            textComp = (JTextComponent)focused;
        }
        return textComp;
    }

    static abstract class HorizontalMovementAction
    extends TextAction {
        int dir;

        HorizontalMovementAction(String name, int direction) {
            super(name);
            this.dir = direction;
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            try {
                if (t != null) {
                    int offs = Utilities.getNextVisualPositionFrom(t, t.getCaretPosition(), this.dir);
                    Caret c = t.getCaret();
                    this.actionPerformedImpl(c, offs);
                    c.setMagicCaretPosition(t.modelToView(offs).getLocation());
                }
            }
            catch (BadLocationException ble) {
                throw (InternalError)new InternalError("Illegal offset").initCause(ble);
            }
        }

        protected abstract void actionPerformedImpl(Caret var1, int var2) throws BadLocationException;
    }

    static abstract class VerticalMovementAction
    extends TextAction {
        int dir;

        VerticalMovementAction(String name, int direction) {
            super(name);
            this.dir = direction;
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            try {
                if (t != null) {
                    int pos;
                    Caret c = t.getCaret();
                    Point mcp = c.getMagicCaretPosition();
                    if (mcp != null) {
                        mcp.y = t.modelToView((int)c.getDot()).y;
                        pos = t.viewToModel(mcp);
                    } else {
                        pos = c.getDot();
                    }
                    pos = Utilities.getNextVisualPositionFrom(t, t.getCaretPosition(), this.dir);
                    if (pos > -1) {
                        this.actionPerformedImpl(c, pos);
                    }
                }
            }
            catch (BadLocationException ble) {
                throw (InternalError)new InternalError("Illegal offset").initCause(ble);
            }
        }

        protected abstract void actionPerformedImpl(Caret var1, int var2) throws BadLocationException;
    }
}

