/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PolicyMappings
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.33");
    private final Map mappings;

    public PolicyMappings(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue maps = der.read();
        if (!maps.isConstructed()) {
            throw new IOException("malformed PolicyMappings");
        }
        int len = 0;
        HashMap<OID, OID> _mappings = new HashMap<OID, OID>();
        while (len < maps.getLength()) {
            DERValue map = der.read();
            if (!map.isConstructed()) {
                throw new IOException("malformed PolicyMapping");
            }
            DERValue val = der.read();
            if (val.getTag() != 6) {
                throw new IOException("malformed PolicyMapping");
            }
            OID issuerPolicy = (OID)val.getValue();
            val = der.read();
            if (val.getTag() != 6) {
                throw new IOException("malformed PolicyMapping");
            }
            OID subjectPolicy = (OID)val.getValue();
            _mappings.put(issuerPolicy, subjectPolicy);
            len += map.getEncodedLength();
        }
        this.mappings = Collections.unmodifiableMap(_mappings);
    }

    public OID getSubjectDomainPolicy(OID issuerDomainPolicy) {
        return (OID)this.mappings.get(issuerDomainPolicy);
    }

    public String toString() {
        return String.valueOf(PolicyMappings.class.getName()) + " [ " + this.mappings + " ]";
    }
}

