/*
 * Decompiled with CFR 0.152.
 */
package tr.view.contexts.screen;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.openide.util.actions.SystemAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.context.Context;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.contexts.DeleteContextAction;
import tr.view.contexts.EditContextAction;
import tr.view.contexts.dialog.ContextDialog;
import tr.view.contexts.screen.ContextNode;
import tr.view.contexts.screen.ContextNodeProvider;
import tr.view.contexts.screen.ContextsTableFormat;

public class ContextsPanel
extends JPanel
implements ListSelectionListener,
Observer {
    private final Data data;
    private final ContextNodeProvider contextProvider;
    private JXTable contextTable;
    private ContextsTableFormat contextTableFormat;
    private Collection<Context> contextList;
    private EventList<Context> contextEventList;
    private EventSelectionModel<Context> selectionModel;
    private EventTableModel<Context> contextEventTableModel;
    private ListSelectionModel tableSelectionModel;
    private SortedList<Context> contextSortedList;
    private TableComparatorChooser<Context> tableSorter;
    private ContextDialog contextDialog;

    public ContextsPanel(ContextNodeProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        this.initTable();
        this.initPanel();
    }

    private void initTable() {
        if (this.data == null) {
            return;
        }
        this.contextList = this.data.getContextManager().list();
        this.contextEventList = new BasicEventList();
        this.contextEventList.addAll(this.contextList);
        this.data.getContextManager().addObserver((Observer)this);
        this.contextSortedList = new SortedList(this.contextEventList);
        this.contextSortedList.setMode(1);
        this.contextTableFormat = new ContextsTableFormat();
        this.contextEventTableModel = new EventTableModel(this.contextSortedList, (TableFormat)this.contextTableFormat);
        this.contextTable = new JXTable(this.contextEventTableModel);
        this.contextTable.getTableHeader().setDefaultRenderer(new JTableHeader().getDefaultRenderer());
        this.contextTable.getSelectionMapper().setEnabled(false);
        this.contextTable.setSortable(false);
        this.contextTable.setSelectionMode(0);
        this.contextTable.setColumnControlVisible(true);
        this.contextTable.setColumnSelectionAllowed(false);
        this.contextTable.setCellSelectionEnabled(false);
        this.contextTable.setRowSelectionAllowed(true);
        this.contextTable.setShowGrid(false);
        this.contextTable.setShowHorizontalLines(false);
        this.contextTable.setShowVerticalLines(false);
        this.selectionModel = new EventSelectionModel(this.contextSortedList);
        this.selectionModel.addListSelectionListener((ListSelectionListener)this);
        this.selectionModel.setSelectionMode(2);
        this.selectionModel.setEnabled(true);
        this.contextTable.setSelectionModel(this.selectionModel);
        for (int c = 0; c < this.contextTableFormat.getColumnCount(); ++c) {
            this.contextTable.getColumnModel().getColumn(c).setPreferredWidth(this.contextTableFormat.getColumnWidth(c));
        }
        this.contextTable.setDefaultRenderer(Context.class, (TableCellRenderer)new ContextsTableFormat.ContextRenderer());
        this.tableSorter = new TableComparatorChooser((JTable)this.contextTable, this.contextSortedList, true);
        this.contextTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ContextsPanel.this.edit();
                } else if (e.getKeyCode() == 127) {
                    e.consume();
                    ContextsPanel.this.delete();
                }
            }
        });
        this.contextTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContextsPanel.this.edit();
                }
            }
        });
    }

    public Preferences getPreferences() {
        return new Preferences(this);
    }

    public void setPreferences(Preferences preferences) {
        if (preferences != null) {
            preferences.restore(this);
        }
    }

    private void initPanel() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView((Component)this.contextTable);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.add((Component)scrollPane, "Center");
    }

    private void edit() {
        ((EditContextAction)SystemAction.get(EditContextAction.class)).actionPerformed(null);
    }

    private void delete() {
        ((DeleteContextAction)SystemAction.get(DeleteContextAction.class)).actionPerformed(null);
    }

    private ContextDialog getContextDialog() {
        this.contextDialog = new ContextDialog(this.data);
        return this.contextDialog;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Vector<ContextNode> nodes = new Vector<ContextNode>();
        for (Context context : this.selectionModel.getSelected()) {
            nodes.add(new ContextNode((Manager<Context>)this.data.getContextManager(), context));
        }
        this.contextProvider.provide(nodes);
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Manager.EventAdd) {
            Manager.EventAdd event = (Manager.EventAdd)object;
            Lock lock = this.contextEventList.getReadWriteLock().writeLock();
            lock.lock();
            this.contextEventList.add((Object)((Context)event.item));
            lock.unlock();
        } else if (object instanceof Manager.EventRemove) {
            Manager.EventRemove event = (Manager.EventRemove)object;
            Lock lock = this.contextEventList.getReadWriteLock().writeLock();
            lock.lock();
            this.contextEventList.remove(event.item);
            lock.unlock();
        } else if (observable instanceof Context) {
            Lock lock = this.contextEventList.getReadWriteLock().writeLock();
            lock.lock();
            Context item = (Context)observable;
            int index = this.contextEventList.indexOf((Object)item);
            if (index > -1) {
                this.contextEventList.set(index, (Object)item);
            }
            lock.unlock();
        }
        this.contextTable.invalidate();
        this.contextTable.repaint();
    }

    static class Preferences
    implements Serializable {
        private static final long serialVersionUID = 6587787564L;
        private final int[] modelIndex;
        private final int[] columnWidth;
        private final boolean[] columnVisible;
        private final int[] columnOrder;
        private final List<Integer> sortingColumns;
        private final List<Boolean> sortingReverse;

        private Preferences(ContextsPanel panel) {
            int i;
            JXTable table = panel.contextTable;
            this.modelIndex = new int[table.getColumnCount(true)];
            this.columnWidth = new int[table.getColumnCount(true)];
            this.columnVisible = new boolean[table.getColumnCount(true)];
            this.columnOrder = new int[table.getColumnCount(false)];
            List columns = table.getColumns(true);
            for (i = 0; i < columns.size(); ++i) {
                TableColumn c = (TableColumn)columns.get(i);
                this.modelIndex[i] = c.getModelIndex();
                this.columnWidth[i] = c.getWidth();
                this.columnVisible[i] = table.getColumnExt(c.getIdentifier()).isVisible();
            }
            for (i = 0; i < table.getColumnCount(); ++i) {
                this.columnOrder[i] = table.getColumn(i).getModelIndex();
            }
            this.sortingColumns = panel.tableSorter.getSortingColumns();
            this.sortingReverse = new Vector<Boolean>();
            for (Integer column : this.sortingColumns) {
                this.sortingReverse.add(new Boolean(panel.tableSorter.isColumnReverse(column.intValue())));
            }
        }

        private void restore(ContextsPanel panel) {
            int i;
            if (panel == null) {
                return;
            }
            if (panel.contextTable == null) {
                return;
            }
            if (panel.contextTableFormat == null) {
                return;
            }
            for (int i2 = 0; i2 < this.modelIndex.length; ++i2) {
                String id = panel.contextTableFormat.getColumnName(this.modelIndex[i2]);
                TableColumnExt tce = panel.contextTable.getColumnExt((Object)id);
                if (panel.contextTableFormat.isResizable(this.modelIndex[i2])) {
                    tce.setPreferredWidth(this.columnWidth[i2]);
                } else {
                    int w = panel.contextTableFormat.getColumnWidth(this.modelIndex[i2]);
                    tce.setMaxWidth(w);
                    tce.setMinWidth(w);
                }
                tce.setVisible(this.columnVisible[i2]);
            }
            Object[] ids = new Object[this.columnOrder.length];
            for (i = 0; i < ids.length; ++i) {
                ids[i] = panel.contextTableFormat.getColumnName(this.columnOrder[i]);
            }
            panel.contextTable.setColumnSequence(ids);
            panel.tableSorter.clearComparator();
            for (i = 0; i < this.sortingColumns.size(); ++i) {
                int column = this.sortingColumns.get(i);
                boolean reverse = this.sortingReverse.get(i);
                panel.tableSorter.appendComparator(column, 0, reverse);
            }
        }
    }
}

