/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import org.openide.actions.UndoAction;
import org.openide.awt.UndoRedo;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class RedoAction
extends CallableSystemAction {
    private static String SWING_DEFAULT_LABEL = UIManager.getString("AbstractUndoableEdit.redoText");

    public boolean isEnabled() {
        UndoAction.initializeUndoRedo();
        return super.isEnabled();
    }

    public String getName() {
        String string = UndoAction.getUndoRedo().getRedoPresentationName();
        if (string != null && SWING_DEFAULT_LABEL != null && string.startsWith(SWING_DEFAULT_LABEL)) {
            string = string.substring(SWING_DEFAULT_LABEL.length()).trim();
        }
        if (string == null || string.trim().length() == 0) {
            return NbBundle.getMessage(RedoAction.class, (String)"RedoSimple");
        }
        return NbBundle.getMessage(RedoAction.class, (String)"RedoWithParameter", (Object)string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RedoAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/redo.gif";
    }

    public void performAction() {
        try {
            UndoRedo undoRedo = UndoAction.getUndoRedo();
            if (undoRedo.canRedo()) {
                undoRedo.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            Exceptions.printStackTrace((Throwable)cannotRedoException);
        }
        UndoAction.updateStatus();
    }

    protected boolean asynchronous() {
        return false;
    }
}

