/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public class AutoupdateCatalogCache {
    private File cacheDir;
    private Exception storedException;
    private static AutoupdateCatalogCache INSTANCE;
    private Logger err = Logger.getLogger(this.getClass().getName());

    public static AutoupdateCatalogCache getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AutoupdateCatalogCache();
            INSTANCE.initCacheDirectory();
        }
        return INSTANCE;
    }

    private synchronized File getCatalogCache() {
        assert (this.cacheDir != null && this.cacheDir.exists());
        return this.cacheDir;
    }

    private void initCacheDirectory() {
        assert (this.cacheDir == null) : "Do initCacheDirectory only once!";
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            this.cacheDir = new File(new File(new File(string, "var"), "cache"), "catalogcache");
        } else {
            File file = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            this.cacheDir = new File(file, "catalogcache");
        }
        this.cacheDir.mkdirs();
        this.err.log(Level.FINE, "getCacheDirectory: " + this.cacheDir.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL writeCatalogToCache(String string, URL uRL) throws IOException {
        String string2 = string.intern();
        synchronized (string2) {
            File file;
            File file2;
            URL uRL2;
            block7: {
                uRL2 = null;
                file2 = this.getCatalogCache();
                assert (file2 != null && file2.exists()) : "Cache directory must exist.";
                file = new File(file2, string);
                this.copy(uRL, file);
                try {
                    uRL2 = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
            assert (new File(file2, string).exists()) : "Cache " + file + " exists.";
            this.err.log(Level.FINER, "Cache file " + file + " was wrote from original URL " + uRL);
            return uRL2;
        }
    }

    public synchronized URL getCatalogURL(String string) {
        File file = this.getCatalogCache();
        assert (file != null && file.exists()) : "Cache directory must exist.";
        File file2 = new File(file, string);
        if (file2 != null && file2.exists()) {
            URL uRL;
            block4: {
                uRL = null;
                try {
                    uRL = file2.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
            return uRL;
        }
        return null;
    }

    private void copy(final URL uRL, final File file) throws IOException {
        this.err.log(Level.INFO, "Processing URL: " + uRL);
        String string = "";
        while (string.length() < 3) {
            string = string + file.getName();
        }
        final File file2 = File.createTempFile(string, null, file.getParentFile());
        file2.deleteOnExit();
        this.storeException(null);
        NetworkAccess.NetworkListener networkListener = new NetworkAccess.NetworkListener(){

            public void streamOpened(InputStream inputStream) {
                AutoupdateCatalogCache.this.err.log(Level.FINE, "Successfully read URI " + uRL);
                AutoupdateCatalogCache.this.doCopy(uRL, inputStream, file, file2);
            }

            public void accessCanceled() {
                AutoupdateCatalogCache.this.err.log(Level.FINE, "Processing " + uRL + " was cancelled.");
                AutoupdateCatalogCache.this.storeException(new IOException("Processing " + uRL + " was cancelled."));
            }

            public void accessTimeOut() {
                AutoupdateCatalogCache.this.err.log(Level.FINE, "Timeout when processing " + uRL);
                AutoupdateCatalogCache.this.storeException(new IOException("Timeout when processing " + uRL));
            }

            public void notifyException(Exception exception) {
                AutoupdateCatalogCache.this.err.log(Level.INFO, "Reading URL " + uRL + " failed (" + exception + ")");
                AutoupdateCatalogCache.this.storeException(exception);
            }
        };
        NetworkAccess.Task task = NetworkAccess.createNetworkAcessTask(uRL, AutoupdateSettings.getOpenConnectionTimeout(), networkListener);
        task.waitFinished();
        this.notifyException();
    }

    private void notifyException() throws IOException {
        if (this.isExceptionStored()) {
            throw new IOException(this.getStoredException().getLocalizedMessage());
        }
    }

    private boolean isExceptionStored() {
        return this.storedException != null;
    }

    private void storeException(Exception exception) {
        this.storedException = exception;
    }

    private Exception getStoredException() {
        return this.storedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doCopy(URL uRL, InputStream inputStream, File file, File file2) {
        block36: {
            BufferedOutputStream bufferedOutputStream = null;
            int n = 0;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            while ((n = inputStream.read()) != -1) {
                ((OutputStream)bufferedOutputStream).write(n);
            }
            Object var9_7 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).flush();
                }
                if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                }
                AutoupdateCatalogCache autoupdateCatalogCache = this;
                synchronized (autoupdateCatalogCache) {
                    if (file.exists() && !file.delete()) {
                        block35: {
                            this.err.log(Level.INFO, "Cannot delete cache " + file);
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                if ($assertionsDisabled) break block35;
                                throw new AssertionError((Object)interruptedException);
                            }
                        }
                        file.delete();
                    }
                    if (!file2.renameTo(file)) {
                        this.err.log(Level.INFO, "Cannot rename temp " + file2 + " to cache " + file);
                    }
                    break block36;
                }
            }
            catch (IOException iOException) {
                this.err.log(Level.INFO, "Closing streams failed.", iOException);
            }
            break block36;
            {
                catch (IOException iOException) {
                    this.err.log(Level.INFO, "Writing content of URL " + uRL + " failed.", iOException);
                    Object var9_8 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (bufferedOutputStream != null) {
                            ((OutputStream)bufferedOutputStream).flush();
                        }
                        if (bufferedOutputStream != null) {
                            ((OutputStream)bufferedOutputStream).close();
                        }
                        AutoupdateCatalogCache autoupdateCatalogCache = this;
                        synchronized (autoupdateCatalogCache) {
                            if (file.exists() && !file.delete()) {
                                block37: {
                                    this.err.log(Level.INFO, "Cannot delete cache " + file);
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        if ($assertionsDisabled) break block37;
                                        throw new AssertionError((Object)interruptedException);
                                    }
                                }
                                file.delete();
                            }
                            if (!file2.renameTo(file)) {
                                this.err.log(Level.INFO, "Cannot rename temp " + file2 + " to cache " + file);
                            }
                            break block36;
                        }
                    }
                    catch (IOException iOException2) {
                        this.err.log(Level.INFO, "Closing streams failed.", iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (bufferedOutputStream != null) {
                        ((OutputStream)bufferedOutputStream).flush();
                    }
                    if (bufferedOutputStream != null) {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                    AutoupdateCatalogCache autoupdateCatalogCache = this;
                    synchronized (autoupdateCatalogCache) {
                        if (file.exists() && !file.delete()) {
                            block38: {
                                this.err.log(Level.INFO, "Cannot delete cache " + file);
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {
                                    if ($assertionsDisabled) break block38;
                                    throw new AssertionError((Object)interruptedException);
                                }
                            }
                            file.delete();
                        }
                        if (!file2.renameTo(file)) {
                            this.err.log(Level.INFO, "Cannot rename temp " + file2 + " to cache " + file);
                        }
                    }
                }
                catch (IOException iOException) {
                    this.err.log(Level.INFO, "Closing streams failed.", iOException);
                }
                throw throwable;
            }
        }
    }
}

