/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class RouteCoverageXmlParser {
    private RouteCoverageXmlParser() {
    }

    public static Document parseXml(final CamelContext camelContext, InputStream is) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        final Document doc = docBuilder.newDocument();
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void setDocumentLocator(Locator locator) {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element el = doc.createElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                String id = el.getAttribute("id");
                if (id != null) {
                    try {
                        ManagedProcessorMBean processor;
                        if ("route".equals(qName)) {
                            ManagedRouteMBean route = camelContext.getManagedRoute(id, ManagedRouteMBean.class);
                            if (route != null) {
                                long total = route.getExchangesTotal();
                                el.setAttribute("exchangesTotal", "" + total);
                                long totalTime = route.getTotalProcessingTime();
                                el.setAttribute("totalProcessingTime", "" + totalTime);
                            }
                        } else if (!"from".equals(qName) && (processor = camelContext.getManagedProcessor(id, ManagedProcessorMBean.class)) != null) {
                            long total = processor.getExchangesTotal();
                            el.setAttribute("exchangesTotal", "" + total);
                            long totalTime = processor.getTotalProcessingTime();
                            el.setAttribute("totalProcessingTime", "" + totalTime);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                el.removeAttribute("customId");
                elementStack.push(el);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedEl = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    doc.appendChild(closedEl);
                } else {
                    Element parentEl = (Element)elementStack.peek();
                    parentEl.appendChild(closedEl);
                }
            }

            @Override
            public void characters(char[] ch, int start2, int length) throws SAXException {
                textBuffer.append(ch, start2, length);
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element el = (Element)elementStack.peek();
                    Text textNode = doc.createTextNode(textBuffer.toString());
                    el.appendChild(textNode);
                    textBuffer.delete(0, textBuffer.length());
                }
            }
        };
        parser.parse(is, handler);
        return doc;
    }
}

