/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DirectFieldAccessor
extends AbstractPropertyAccessor {
    private final Object rootObject;
    private final Map<String, FieldAccessor> fieldMap = new HashMap<String, FieldAccessor>();

    public DirectFieldAccessor(Object rootObject) {
        Assert.notNull(rootObject, "Root object must not be null");
        this.rootObject = rootObject;
        this.typeConverterDelegate = new TypeConverterDelegate(this, rootObject);
        this.registerDefaultEditors();
        this.setExtractOldValueForEditor(true);
    }

    public final Object getRootInstance() {
        return this.rootObject;
    }

    public final Class<?> getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    @Override
    public boolean isReadableProperty(String propertyName) throws BeansException {
        return this.hasProperty(propertyName);
    }

    @Override
    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.hasProperty(propertyName);
    }

    @Override
    public Class<?> getPropertyType(String propertyPath) throws BeansException {
        FieldAccessor fieldAccessor = this.getFieldAccessor(propertyPath);
        if (fieldAccessor != null) {
            return fieldAccessor.getField().getType();
        }
        return null;
    }

    @Override
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        FieldAccessor fieldAccessor = this.getFieldAccessor(propertyName);
        if (fieldAccessor != null) {
            return new TypeDescriptor(fieldAccessor.getField());
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String propertyName) throws BeansException {
        FieldAccessor fieldAccessor = this.getFieldAccessor(propertyName);
        if (fieldAccessor == null) {
            throw new NotReadablePropertyException(this.getRootClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        return fieldAccessor.getValue();
    }

    @Override
    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        FieldAccessor fieldAccessor = this.getFieldAccessor(propertyName);
        if (fieldAccessor == null) {
            throw new NotWritablePropertyException(this.getRootClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        Field field = fieldAccessor.getField();
        Object oldValue = null;
        try {
            oldValue = fieldAccessor.getValue();
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(field.getName(), oldValue, newValue, field.getType(), new TypeDescriptor(field));
            fieldAccessor.setValue(convertedValue);
        }
        catch (ConverterNotFoundException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.getRootInstance(), propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field.getType(), (Throwable)ex);
        }
        catch (ConversionException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.getRootInstance(), propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field.getType(), (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.getRootInstance(), propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field.getType(), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.getRootInstance(), propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field.getType(), (Throwable)ex);
        }
    }

    private boolean hasProperty(String propertyPath) {
        Assert.notNull(propertyPath, "PropertyPath must not be null");
        return this.getFieldAccessor(propertyPath) != null;
    }

    private FieldAccessor getFieldAccessor(String propertyPath) {
        FieldAccessor fieldAccessor = this.fieldMap.get(propertyPath);
        if (fieldAccessor == null) {
            fieldAccessor = this.doGetFieldAccessor(propertyPath, this.getRootClass());
            this.fieldMap.put(propertyPath, fieldAccessor);
        }
        return fieldAccessor;
    }

    private FieldAccessor doGetFieldAccessor(String propertyPath, Class<?> targetClass) {
        StringTokenizer st = new StringTokenizer(propertyPath, ".");
        FieldAccessor accessor = null;
        Class<?> parentType = targetClass;
        while (st.hasMoreTokens()) {
            String localProperty = st.nextToken();
            Field field = ReflectionUtils.findField(parentType, localProperty);
            if (field == null) {
                return null;
            }
            accessor = accessor == null ? this.root(propertyPath, localProperty, field) : accessor.child(localProperty, field);
            parentType = field.getType();
        }
        return accessor;
    }

    private FieldAccessor root(String canonicalName, String actualName, Field field) {
        return new FieldAccessor(null, canonicalName, actualName, field);
    }

    private class FieldAccessor {
        private final List<FieldAccessor> parents;
        private final String canonicalName;
        private final String actualName;
        private final Field field;

        public FieldAccessor(FieldAccessor parent, String canonicalName, String actualName, Field field) {
            Assert.notNull(canonicalName, "Expression must no be null");
            Assert.notNull(field, "Field must no be null");
            this.parents = this.buildParents(parent);
            this.canonicalName = canonicalName;
            this.actualName = actualName;
            this.field = field;
        }

        public FieldAccessor child(String actualName, Field field) {
            return new FieldAccessor(this, this.canonicalName, this.actualName + "." + actualName, field);
        }

        public Field getField() {
            return this.field;
        }

        public Object getValue() {
            Object localTarget = this.getLocalTarget(DirectFieldAccessor.this.getRootInstance());
            return this.getParentValue(localTarget);
        }

        public void setValue(Object value) {
            Object localTarget = this.getLocalTarget(DirectFieldAccessor.this.getRootInstance());
            try {
                this.field.set(localTarget, value);
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(localTarget.getClass(), this.canonicalName, "Field is not accessible", ex);
            }
        }

        private Object getParentValue(Object target) {
            try {
                ReflectionUtils.makeAccessible(this.field);
                return this.field.get(target);
            }
            catch (IllegalAccessException ex) {
                throw new InvalidPropertyException(target.getClass(), this.canonicalName, "Field is not accessible", ex);
            }
        }

        private Object getLocalTarget(Object rootTarget) {
            Object localTarget = rootTarget;
            for (FieldAccessor parent : this.parents) {
                localTarget = this.autoGrowIfNecessary(parent, parent.getParentValue(localTarget));
                if (localTarget != null) continue;
                throw new NullValueInNestedPathException(DirectFieldAccessor.this.getRootClass(), parent.actualName, "Cannot access indexed value of property referenced in indexed property path '" + this.getField().getName() + "': returned null");
            }
            return localTarget;
        }

        private Object newValue() {
            Class<?> type = this.getField().getType();
            try {
                return type.newInstance();
            }
            catch (Exception ex) {
                throw new NullValueInNestedPathException(DirectFieldAccessor.this.getRootClass(), this.actualName, "Could not instantiate property type [" + type.getName() + "] to auto-grow nested property path: " + ex);
            }
        }

        private Object autoGrowIfNecessary(FieldAccessor accessor, Object value) {
            if (value == null && DirectFieldAccessor.this.isAutoGrowNestedPaths()) {
                Object defaultValue = accessor.newValue();
                accessor.setValue(defaultValue);
                return defaultValue;
            }
            return value;
        }

        private List<FieldAccessor> buildParents(FieldAccessor parent) {
            ArrayList<FieldAccessor> parents = new ArrayList<FieldAccessor>();
            if (parent != null) {
                parents.addAll(parent.parents);
                parents.add(parent);
            }
            return parents;
        }
    }
}

