/*	$OpenBSD: timer.c,v 1.1 2016/07/19 16:54:26 reyk Exp $	*/

/*
 * Copyright (c) 2010-2016 Reyk Floeter <reyk@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/queue.h>
#include <sys/socket.h>
#include <sys/uio.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <event.h>

#include "switchd.h"

void	 timer_callback(int, short, void *);

void
timer_set(struct switchd *sc, struct timer *tmr,
    void (*cb)(struct switchd *, void *), void *arg)
{
	tmr->tmr_sc = sc;
	tmr->tmr_cb = cb;
	tmr->tmr_cbarg = arg;
	evtimer_set(&tmr->tmr_ev, timer_callback, tmr);
}

void
timer_add(struct switchd *sc, struct timer *tmr, int timeout)
{
	struct timeval		 tv = { timeout };

	if (evtimer_initialized(&tmr->tmr_ev) &&
	    evtimer_pending(&tmr->tmr_ev, NULL))
		evtimer_del(&tmr->tmr_ev);

	evtimer_add(&tmr->tmr_ev, &tv);
}

void
timer_del(struct switchd *sc, struct timer *tmr)
{
	if (tmr->tmr_sc == sc && tmr->tmr_cb &&
	    evtimer_initialized(&tmr->tmr_ev))
		evtimer_del(&tmr->tmr_ev);
}

void
timer_callback(int fd, short event, void *arg)
{
	struct timer	*tmr = arg;

	if (tmr->tmr_cb)
		tmr->tmr_cb(tmr->tmr_sc, tmr->tmr_cbarg);
}
