/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLAttribute;
import net.n3.nanoxml.XMLWriter;

public class XMLElement
implements IXMLElement,
Serializable {
    static final long serialVersionUID = -2383376380548624920L;
    public static final int NO_LINE = -1;
    private IXMLElement parent;
    private ArrayList attributes = new ArrayList();
    private ArrayList<IXMLElement> children = new ArrayList(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String string) {
        this(string, null, null, -1);
    }

    public XMLElement(String string, String string2, int n) {
        this(string, null, string2, n);
    }

    public XMLElement(String string, String string2) {
        this(string, string2, null, -1);
    }

    public XMLElement(String string, String string2, String string3, int n) {
        int n2;
        this.fullName = string;
        this.name = string2 == null ? string : ((n2 = string.indexOf(58)) >= 0 ? string.substring(n2 + 1) : string);
        this.namespace = string2;
        this.content = null;
        this.lineNr = n;
        this.systemID = string3;
        this.parent = null;
    }

    @Override
    public IXMLElement createPCDataElement() {
        return new XMLElement();
    }

    @Override
    public IXMLElement createElement(String string) {
        return new XMLElement(string);
    }

    @Override
    public IXMLElement createElement(String string, String string2, int n) {
        return new XMLElement(string, string2, n);
    }

    @Override
    public IXMLElement createElement(String string, String string2) {
        return new XMLElement(string, string2);
    }

    @Override
    public IXMLElement createElement(String string, String string2, String string3, int n) {
        return new XMLElement(string, string2, string3, n);
    }

    @Override
    public IXMLElement getParent() {
        return this.parent;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.fullName = string;
        this.namespace = null;
    }

    @Override
    public void setName(String string, String string2) {
        int n = string.indexOf(58);
        this.name = string2 == null || n < 0 ? string : string.substring(n + 1);
        this.fullName = string;
        this.namespace = string2;
    }

    @Override
    public void addChild(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2;
        if (iXMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (iXMLElement.getName() == null && !this.children.isEmpty() && (iXMLElement2 = this.children.get(this.children.size() - 1)).getName() == null) {
            iXMLElement2.setContent(iXMLElement2.getContent() + iXMLElement.getContent());
            return;
        }
        ((XMLElement)iXMLElement).parent = this;
        this.children.add(iXMLElement);
    }

    public void insertChild(IXMLElement iXMLElement, int n) {
        IXMLElement iXMLElement2;
        if (iXMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (iXMLElement.getName() == null && !this.children.isEmpty() && (iXMLElement2 = this.children.get(this.children.size() - 1)).getName() == null) {
            iXMLElement2.setContent(iXMLElement2.getContent() + iXMLElement.getContent());
            return;
        }
        ((XMLElement)iXMLElement).parent = this;
        this.children.add(n, iXMLElement);
    }

    @Override
    public void removeChild(IXMLElement iXMLElement) {
        if (iXMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.remove(iXMLElement);
    }

    @Override
    public void removeChildAtIndex(int n) {
        this.children.remove(n);
    }

    public Iterator iterateChildren() {
        return this.children.iterator();
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    public ArrayList getChildren() {
        return this.children;
    }

    @Override
    public IXMLElement getChildAtIndex(int n) throws ArrayIndexOutOfBoundsException {
        return this.children.get(n);
    }

    @Override
    public IXMLElement getFirstChildNamed(String string) {
        for (IXMLElement iXMLElement : this.children) {
            String string2 = iXMLElement.getFullName();
            if (string2 == null || !string2.equals(string)) continue;
            return iXMLElement;
        }
        return null;
    }

    @Override
    public IXMLElement getFirstChildNamed(String string, String string2) {
        for (IXMLElement iXMLElement : this.children) {
            String string3 = iXMLElement.getName();
            boolean bl = string3 != null && string3.equals(string);
            string3 = iXMLElement.getNamespace();
            bl = string3 == null ? (bl &= string == null) : (bl &= string3.equals(string2));
            if (!bl) continue;
            return iXMLElement;
        }
        return null;
    }

    public ArrayList getChildrenNamed(String string) {
        ArrayList<IXMLElement> arrayList = new ArrayList<IXMLElement>(this.children.size());
        for (IXMLElement iXMLElement : this.children) {
            String string2 = iXMLElement.getFullName();
            if (string2 == null || !string2.equals(string)) continue;
            arrayList.add(iXMLElement);
        }
        return arrayList;
    }

    public ArrayList getChildrenNamed(String string, String string2) {
        ArrayList<IXMLElement> arrayList = new ArrayList<IXMLElement>(this.children.size());
        for (IXMLElement iXMLElement : this.children) {
            String string3 = iXMLElement.getName();
            boolean bl = string3 != null && string3.equals(string);
            string3 = iXMLElement.getNamespace();
            bl = string3 == null ? (bl &= string == null) : (bl &= string3.equals(string2));
            if (!bl) continue;
            arrayList.add(iXMLElement);
        }
        return arrayList;
    }

    private XMLAttribute findAttribute(String string) {
        for (XMLAttribute xMLAttribute : this.attributes) {
            if (!xMLAttribute.getFullName().equals(string)) continue;
            return xMLAttribute;
        }
        return null;
    }

    private XMLAttribute findAttribute(String string, String string2) {
        for (XMLAttribute xMLAttribute : this.attributes) {
            boolean bl = xMLAttribute.getName().equals(string);
            bl = string2 == null ? (bl &= xMLAttribute.getNamespace() == null) : (bl &= string2.equals(xMLAttribute.getNamespace()));
            if (!bl) continue;
            return xMLAttribute;
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    @Override
    public String getAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            return string2;
        }
        return xMLAttribute.getValue();
    }

    @Override
    public String getAttribute(String string, String string2, String string3) {
        XMLAttribute xMLAttribute = this.findAttribute(string, string2);
        if (xMLAttribute == null) {
            return string3;
        }
        return xMLAttribute.getValue();
    }

    @Override
    public double getDoubleAttribute(String string, String string2, double d) {
        XMLAttribute xMLAttribute = this.findAttribute(string, string2);
        if (xMLAttribute == null) {
            return d;
        }
        try {
            return Double.parseDouble(xMLAttribute.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    @Override
    public int getAttribute(String string, int n) {
        String string2 = this.getAttribute(string, Integer.toString(n));
        return Integer.parseInt(string2);
    }

    @Override
    public int getAttribute(String string, String string2, int n) {
        String string3 = this.getAttribute(string, string2, Integer.toString(n));
        return Integer.parseInt(string3);
    }

    @Override
    public Object getAttribute(String string, String string2, Map map, String string3) {
        String string4 = this.getAttribute(string, string2, null);
        if (string4 == null || !map.containsKey(string4)) {
            return map.get(string3);
        }
        return map.get(string4);
    }

    @Override
    public String getAttributeType(String string) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getType();
    }

    @Override
    public String getAttributeNamespace(String string) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getNamespace();
    }

    @Override
    public String getAttributeType(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string, string2);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getType();
    }

    @Override
    public void setAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string);
        if (xMLAttribute == null) {
            xMLAttribute = new XMLAttribute(string, string, null, string2, "CDATA");
            this.attributes.add(xMLAttribute);
        } else {
            xMLAttribute.setValue(string2);
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3) {
        int n = string.indexOf(58);
        String string4 = string.substring(n + 1);
        XMLAttribute xMLAttribute = this.findAttribute(string4, string2);
        if (xMLAttribute == null) {
            xMLAttribute = new XMLAttribute(string, string4, string2, string3, "CDATA");
            this.attributes.add(xMLAttribute);
        } else {
            xMLAttribute.setValue(string3);
        }
    }

    @Override
    public void removeAttribute(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute xMLAttribute = (XMLAttribute)this.attributes.get(i);
            if (!xMLAttribute.getFullName().equals(string)) continue;
            this.attributes.remove(i);
            return;
        }
    }

    @Override
    public void removeAttribute(String string, String string2) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute xMLAttribute = (XMLAttribute)this.attributes.get(i);
            boolean bl = xMLAttribute.getName().equals(string);
            bl = string2 == null ? (bl &= xMLAttribute.getNamespace() == null) : (bl &= xMLAttribute.getNamespace().equals(string2));
            if (!bl) continue;
            this.attributes.remove(i);
            return;
        }
    }

    public Iterator iterateAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (XMLAttribute xMLAttribute : this.attributes) {
            arrayList.add(xMLAttribute.getFullName());
        }
        return arrayList.iterator();
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.findAttribute(string) != null;
    }

    @Override
    public boolean hasAttribute(String string, String string2) {
        return this.findAttribute(string, string2) != null;
    }

    @Override
    public Properties getAttributes() {
        Properties properties = new Properties();
        for (XMLAttribute xMLAttribute : this.attributes) {
            properties.put(xMLAttribute.getFullName(), xMLAttribute.getValue());
        }
        return properties;
    }

    @Override
    public Properties getAttributesInNamespace(String string) {
        Properties properties = new Properties();
        for (XMLAttribute xMLAttribute : this.attributes) {
            if (string == null) {
                if (xMLAttribute.getNamespace() != null) continue;
                properties.put(xMLAttribute.getName(), xMLAttribute.getValue());
                continue;
            }
            if (!string.equals(xMLAttribute.getNamespace())) continue;
            properties.put(xMLAttribute.getName(), xMLAttribute.getValue());
        }
        return properties;
    }

    @Override
    public String getSystemID() {
        return this.systemID;
    }

    @Override
    public int getLineNr() {
        return this.lineNr;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String string) {
        this.content = string;
    }

    @Override
    public boolean equals(Object object) {
        try {
            return this.equalsXMLElement((IXMLElement)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean equalsXMLElement(IXMLElement iXMLElement) {
        Object object;
        Object object2;
        if (!this.name.equals(iXMLElement.getName())) {
            return false;
        }
        if (this.attributes.size() != iXMLElement.getAttributeCount()) {
            return false;
        }
        for (XMLAttribute xMLAttribute : this.attributes) {
            if (!iXMLElement.hasAttribute(xMLAttribute.getName(), xMLAttribute.getNamespace())) {
                return false;
            }
            object2 = iXMLElement.getAttribute(xMLAttribute.getName(), xMLAttribute.getNamespace(), null);
            if (!xMLAttribute.getValue().equals(object2)) {
                return false;
            }
            object = iXMLElement.getAttributeType(xMLAttribute.getName(), xMLAttribute.getNamespace());
            if (xMLAttribute.getType().equals(object)) continue;
            return false;
        }
        if (this.children.size() != iXMLElement.getChildrenCount()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            object2 = this.getChildAtIndex(i);
            if (object2.equalsXMLElement((IXMLElement)(object = iXMLElement.getChildAtIndex(i)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        XMLWriter xMLWriter = new XMLWriter(charArrayWriter);
        try {
            xMLWriter.write(this);
        }
        catch (IOException iOException) {
            InternalError internalError = new InternalError("toString failed");
            internalError.initCause(iOException);
            throw internalError;
        }
        return charArrayWriter.toString();
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            for (IXMLElement iXMLElement : this.children) {
                iXMLElement.dispose();
            }
        }
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
    }
}

