<?php

/*
 * Chive - web based MySQL database management
 * Copyright (C) 2010 Fusonic GmbH
 *
 * This file is part of Chive.
 *
 * Chive is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Chive is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


require_once(dirname(__FILE__) . '/models/DataType.php');
require_once(dirname(__FILE__) . '/models/StorageEngine.php');

// Data types
$types = CJSON::encode(DataType::$types);
$file = file_get_contents(dirname(__FILE__) . '/../js/dataType.js');
$file = preg_replace('/types: .+?$/m', 'types: ' . $types . ',', $file);
file_put_contents(dirname(__FILE__) . '/../js/dataType.js', $file);

// Storage engines
$engines = CJSON::encode(StorageEngine::$engines);
$file = file_get_contents(dirname(__FILE__) . '/../js/storageEngine.js');
$file = preg_replace('/engines: .+?$/m', 'engines: ' . $engines . ',', $file);
file_put_contents(dirname(__FILE__) . '/../js/storageEngine.js', $file);

?>