/***************************************************************************
                          cuserlist.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CUSERLIST_H
#define CUSERLIST_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

class CThreadStringList;
class CMessageNickList;
class CMessageMyInfo;
class CMessageSearchResult;

class DLL_EXPORT CUserList : public CObject {

public:
	/** */
	CUserList();
	/** */
	virtual ~CUserList();

	/** */
	void Clear();
	
	/** user list functions */
	void InitUserList( CMessageNickList * NickList );
	/** */
	void InitOperatorList( CMessageNickList * NickList );
	/** */
	bool AppendUser( CString & nick, bool getinfo = TRUE );
	/** */
	void RemoveUser( CString & nick );
	/** */
	bool UpdateUser( CMessageMyInfo * pMyInfo );
	/** */
	bool IsUserOnline( CString & nick );
	/** */
	bool IsAdmin( const CString & nick ) const;
	/** */
	eUserClientVersion GetUserClientVersion( const CString & nick ) const;
	/** */
	bool GetUserMyInfo( CString nick, CMessageMyInfo * p );
	/** */
	bool UpdateUserSlots( CMessageSearchResult * pSearchResult );
	/** */
	bool SetUserTransferInfo( CString nick, CDCMessage * msg );
	/** */
	ulonglong ShareSize() { return m_nShareSize; };

private:
	/** */
	CThreadStringList * m_pUserList;
	/** */
	ulonglong m_nShareSize;
};

#endif
