/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordParam;
import org.parosproxy.paros.db.TableParam;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableParam
extends SqlAbstractTable
implements TableParam {
    private static final String TABLE_NAME = DbSQL.getSQL("param.table_name");
    private static final String PARAMID = DbSQL.getSQL("param.field.paramid");
    private static final String SITE = DbSQL.getSQL("param.field.site");
    private static final String TYPE = DbSQL.getSQL("param.field.type");
    private static final String NAME = DbSQL.getSQL("param.field.name");
    private static final String USED = DbSQL.getSQL("param.field.used");
    private static final String FLAGS = DbSQL.getSQL("param.field.flags");
    private static final String VALUES = DbSQL.getSQL("param.field.vals");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.executeAndClose(conn.prepareStatement(DbSQL.getSQL("param.ps.addtable")));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized RecordParam read(long urlId) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<RecordParam> getAll() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAll = null;
        try {
            psGetAll = DbSQL.getSingleton().getPreparedStatement("param.ps.getall");
            ArrayList<RecordParam> result = new ArrayList<RecordParam>();
            try (ResultSet rs = psGetAll.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordParam(rs.getLong(PARAMID), rs.getString(SITE), rs.getString(TYPE), rs.getString(NAME), rs.getInt(USED), rs.getString(FLAGS), rs.getString(VALUES)));
                }
            }
            ArrayList<RecordParam> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAll);
        }
    }

    @Override
    public synchronized RecordParam insert(String site, String type, String name, int used, String flags, String values) throws DatabaseException {
        SqlPreparedStatementWrapper psInsert = null;
        try {
            long id;
            psInsert = DbSQL.getSingleton().getPreparedStatement("param.ps.insert");
            psInsert.getPs().setString(1, site);
            psInsert.getPs().setString(2, type);
            psInsert.getPs().setString(3, name);
            psInsert.getPs().setInt(4, used);
            psInsert.getPs().setString(5, flags);
            psInsert.getPs().setString(6, values);
            psInsert.getPs().executeUpdate();
            try (ResultSet rs = psInsert.getLastInsertedId();){
                rs.next();
                id = rs.getLong(1);
            }
            RecordParam recordParam = this.read(id);
            return recordParam;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsert);
        }
    }

    @Override
    public synchronized void update(long paramId, int used, String flags, String values) throws DatabaseException {
        SqlPreparedStatementWrapper psUpdate = null;
        try {
            psUpdate = DbSQL.getSingleton().getPreparedStatement("param.ps.update");
            psUpdate.getPs().setInt(1, used);
            psUpdate.getPs().setString(2, flags);
            psUpdate.getPs().setString(3, values);
            psUpdate.getPs().setLong(4, paramId);
            psUpdate.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psUpdate);
        }
    }

    private RecordParam build(ResultSet rs) throws DatabaseException {
        try {
            RecordParam rt = null;
            if (rs.next()) {
                rt = new RecordParam(rs.getLong(PARAMID), rs.getString(SITE), rs.getString(TYPE), rs.getString(NAME), rs.getInt(USED), rs.getString(FLAGS), rs.getString(VALUES));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

