/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.CharacterEntityReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.NumericCharacterReference;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StreamedSource;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    static int MAX_ENTITY_REFERENCE_LENGTH;
    private static final int TAB_LENGTH = 4;

    CharacterReference(Source source, int n, int n2, int n3) {
        super(source, n, n2);
        this.codePoint = n3;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public final void appendCharTo(Appendable appendable) throws IOException {
        this.appendCharTo(appendable, Config.ConvertNonBreakingSpaces);
    }

    private void appendCharTo(Appendable appendable, boolean bl) throws IOException {
        if (Character.isSupplementaryCodePoint(this.codePoint)) {
            appendable.append(CharacterReference.getHighSurrogate(this.codePoint));
            appendable.append(CharacterReference.getLowSurrogate(this.codePoint));
        } else {
            char c = this.getChar();
            if (c == '\u00a0' && bl) {
                appendable.append(' ');
            } else {
                appendable.append(c);
            }
        }
    }

    public boolean isTerminated() {
        return this.source.charAt(this.end - 1) == ';';
    }

    public static String encode(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        try {
            return CharacterReference.appendEncode(new StringBuilder(charSequence.length() * 2), charSequence, false).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String encode(char c) {
        try {
            return CharacterReference.appendEncode(new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH), c).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        try {
            return CharacterReference.appendEncode(new StringBuilder(charSequence.length() * 2), charSequence, true).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String decode(CharSequence charSequence) {
        return CharacterReference.decode(charSequence, false, Config.ConvertNonBreakingSpaces);
    }

    public static String decode(CharSequence charSequence, boolean bl) {
        return CharacterReference.decode(charSequence, bl, Config.ConvertNonBreakingSpaces);
    }

    static String decode(CharSequence charSequence, boolean bl, boolean bl2) {
        if (charSequence == null) {
            return null;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '&') continue;
            try {
                return CharacterReference.appendDecode(new StringBuilder(charSequence.length()), charSequence, i, bl, bl2).toString();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return ((Object)charSequence).toString();
    }

    public static String decodeCollapseWhiteSpace(CharSequence charSequence) {
        return CharacterReference.decodeCollapseWhiteSpace(charSequence, Config.ConvertNonBreakingSpaces);
    }

    static String decodeCollapseWhiteSpace(CharSequence charSequence, boolean bl) {
        return CharacterReference.decode(CharacterReference.appendCollapseWhiteSpace(new StringBuilder(charSequence.length()), charSequence), false, bl);
    }

    public static String reencode(CharSequence charSequence) {
        return CharacterReference.encode(CharacterReference.decode(charSequence, true));
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int n) {
        String string = null;
        if (n != 39) {
            string = CharacterEntityReference.getCharacterReferenceString(n);
        }
        if (string == null) {
            string = NumericCharacterReference.getCharacterReferenceString(n);
        }
        return string;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int n) {
        try {
            return CharacterReference.appendDecimalCharacterReferenceString(new StringBuilder(), n).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int n) {
        try {
            return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuilder(), n).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int n) {
        try {
            return CharacterReference.appendUnicodeText(new StringBuilder(), n).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static final Appendable appendUnicodeText(Appendable appendable, int n) throws IOException {
        appendable.append("U+");
        String string = Integer.toString(n, 16).toUpperCase();
        for (int i = 4 - string.length(); i > 0; --i) {
            appendable.append('0');
        }
        appendable.append(string);
        return appendable;
    }

    public static CharacterReference parse(CharSequence charSequence) {
        return CharacterReference.construct(new Source(charSequence, true), 0, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence charSequence) {
        CharacterReference characterReference = CharacterReference.parse(charSequence);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char c) {
        return c > '\u007f' || CharacterEntityReference.getName(c) != null && (c != '\'' || Config.IsApostropheEncoded);
    }

    public static Writer getEncodingFilterWriter(Writer writer) {
        return new EncodingFilterWriter(writer);
    }

    private static Appendable appendEncode(Appendable appendable, char c) throws IOException {
        if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(appendable, c, false)) {
            return appendable;
        }
        return appendable.append(c);
    }

    static Appendable appendEncode(Appendable appendable, CharSequence charSequence, boolean bl) throws IOException {
        int n;
        if (charSequence == null) {
            return appendable;
        }
        int n2 = 0;
        int n3 = charSequence.length();
        if (charSequence instanceof Segment) {
            Segment segment = (Segment)charSequence;
            n2 = n = segment.getBegin();
            n3 += n;
            charSequence = segment.source;
        }
        boolean bl2 = Config.IsApostropheEncoded;
        for (n = n2; n < n3; ++n) {
            int n4;
            char c = charSequence.charAt(n);
            if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(appendable, c, bl)) continue;
            int n5 = n + 1;
            if (c != ' ') {
                if (c != '\t') {
                    if (c == '\r' && n5 < n3 && charSequence.charAt(n5) == '\n') {
                        ++n;
                    }
                    appendable.append("<br />");
                    continue;
                }
                n4 = 4;
            } else {
                n4 = 1;
            }
            while (n5 < n3) {
                c = charSequence.charAt(n5);
                if (c == ' ') {
                    ++n4;
                } else {
                    if (c != '\t') break;
                    n4 += 4;
                }
                ++n5;
            }
            if (n4 == 1) {
                appendable.append(' ');
                continue;
            }
            if (n4 % 2 == 1) {
                appendable.append(' ');
            }
            while (n4 >= 2) {
                appendable.append("&nbsp; ");
                n4 -= 2;
            }
            n = n5 - 1;
        }
        return appendable;
    }

    private static final boolean appendEncodeCheckForWhiteSpaceFormatting(Appendable appendable, char c, boolean bl) throws IOException {
        String string = CharacterEntityReference.getName(c);
        if (string != null) {
            if (c == '\'') {
                if (Config.IsApostropheEncoded) {
                    appendable.append("&#39;");
                } else {
                    appendable.append(c);
                }
            } else {
                CharacterEntityReference.appendCharacterReferenceString(appendable, string);
            }
        } else if (c > '\u007f') {
            CharacterReference.appendDecimalCharacterReferenceString(appendable, c);
        } else if (!bl || !CharacterReference.isWhiteSpace(c)) {
            appendable.append(c);
        } else {
            return false;
        }
        return true;
    }

    static CharacterReference getPrevious(Source source, int n) {
        return CharacterReference.getPrevious(source, n, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    static CharacterReference getNext(Source source, int n) {
        return CharacterReference.getNext(source, n, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    private static CharacterReference getPrevious(Source source, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source.getParseText();
        n = parseText.lastIndexOf('&', n);
        while (n != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, n, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            n = parseText.lastIndexOf('&', n - 1);
        }
        return null;
    }

    private static CharacterReference getNext(Source source, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source.getParseText();
        n = parseText.indexOf('&', n);
        while (n != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, n, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            n = parseText.indexOf('&', n + 1);
        }
        return null;
    }

    static final Appendable appendHexadecimalCharacterReferenceString(Appendable appendable, int n) throws IOException {
        return appendable.append("&#x").append(Integer.toString(n, 16)).append(';');
    }

    static final Appendable appendDecimalCharacterReferenceString(Appendable appendable, int n) throws IOException {
        return appendable.append("&#").append(Integer.toString(n)).append(';');
    }

    static CharacterReference construct(Source source, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        try {
            if (source.getParseText().charAt(n) != '&') {
                return null;
            }
            return source.getParseText().charAt(n + 1) == '#' ? NumericCharacterReference.construct(source, n, unterminatedCharacterReferenceSettings) : CharacterEntityReference.construct(source, n, unterminatedCharacterReferenceSettings.characterEntityReferenceMaxCodePoint);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private static Appendable appendDecode(Appendable appendable, CharSequence charSequence, int n, boolean bl, boolean bl2) throws IOException {
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(bl);
        boolean bl3 = false;
        StreamedSource streamedSource = new StreamedSource(charSequence).setHandleTags(false).setSearchBegin(n);
        for (Segment segment : streamedSource) {
            if (segment instanceof CharacterReference) {
                ((CharacterReference)segment).appendCharTo(appendable, bl2);
                continue;
            }
            appendable.append(segment.toString());
        }
        return appendable;
    }

    private static char getHighSurrogate(int n) {
        return (char)(55232 + (n >> 10));
    }

    private static char getLowSurrogate(int n) {
        return (char)(56320 + (n & 0x3FF));
    }

    private static final class EncodingFilterWriter
    extends FilterWriter {
        StringBuilder sb = new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH);

        public EncodingFilterWriter(Writer writer) {
            super(writer);
        }

        public void write(char c) throws IOException {
            this.sb.setLength(0);
            CharacterReference.appendEncode(this.sb, c);
            if (this.sb.length() == 1) {
                this.out.write(this.sb.charAt(0));
            } else {
                this.out.append(this.sb);
            }
        }

        public void write(int n) throws IOException {
            this.write((char)n);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.write(cArray[i]);
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.write(string.charAt(i));
            }
        }
    }
}

