/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.reduction.DateMaxFunction;
import org.apache.solr.analytics.function.reduction.DoubleMaxFunction;
import org.apache.solr.analytics.function.reduction.FloatMaxFunction;
import org.apache.solr.analytics.function.reduction.IntMaxFunction;
import org.apache.solr.analytics.function.reduction.LongMaxFunction;
import org.apache.solr.analytics.function.reduction.StringMaxFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class MaxFunction {
    public static final String name = "max";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The max function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof DateValueStream) {
            return new DateMaxFunction((DateValueStream)param);
        }
        if (param instanceof IntValueStream) {
            return new IntMaxFunction((IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return new LongMaxFunction((LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return new FloatMaxFunction((FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleMaxFunction((DoubleValueStream)param);
        }
        if (param instanceof StringValueStream) {
            return new StringMaxFunction((StringValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The max function requires a comparable parameter. Incorrect parameter: " + params[0].getExpressionStr());
    };
}

