/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.calcite.util.CompatibleGuava11;

public interface Compatible {
    public static final Compatible INSTANCE = new Factory().create();

    public <K, V> Map<K, V> asMap(Set<K> var1, Function<? super K, V> var2);

    public <E> NavigableSet<E> navigableSet(ImmutableSortedSet<E> var1);

    public <K, V> NavigableMap<K, V> navigableMap(ImmutableSortedMap<K, V> var1);

    public <K, V> NavigableMap<K, V> immutableNavigableMap(NavigableMap<K, V> var1);

    @Deprecated
    public void setSchema(Connection var1, String var2);

    public String getParameterName(Method var1, int var2);

    public static class Factory {
        Compatible create() {
            return (Compatible)Proxy.newProxyInstance(Compatible.class.getClassLoader(), new Class[]{Compatible.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("asMap")) {
                        try {
                            Method guavaMethod = Maps.class.getMethod(method.getName(), method.getParameterTypes());
                            return guavaMethod.invoke(null, args);
                        }
                        catch (NoSuchMethodException e) {
                            Set set = (Set)args[0];
                            Function function = (Function)args[1];
                            return CompatibleGuava11.asMap(set, function);
                        }
                    }
                    if (method.getName().equals("navigableSet")) {
                        ImmutableSortedSet set = (ImmutableSortedSet)args[0];
                        return CompatibleGuava11.navigableSet(set);
                    }
                    if (method.getName().equals("navigableMap")) {
                        ImmutableSortedMap map = (ImmutableSortedMap)args[0];
                        return CompatibleGuava11.navigableMap(map);
                    }
                    if (method.getName().equals("immutableNavigableMap")) {
                        Map map = (Map)args[0];
                        ImmutableSortedMap sortedMap = ImmutableSortedMap.copyOf((Map)map);
                        return CompatibleGuava11.navigableMap(sortedMap);
                    }
                    if (method.getName().equals("setSchema")) {
                        Connection connection = (Connection)args[0];
                        String schema = (String)args[1];
                        Method method1 = connection.getClass().getMethod("setSchema", String.class);
                        return method1.invoke((Object)connection, schema);
                    }
                    if (method.getName().equals("getParameterName")) {
                        Method m = (Method)args[0];
                        int i = (Integer)args[1];
                        try {
                            Method method1 = m.getClass().getMethod("getParameters", new Class[0]);
                            Object parameters = method1.invoke((Object)m, new Object[0]);
                            Object parameter = Array.get(parameters, i);
                            Method method3 = parameter.getClass().getMethod("getName", new Class[0]);
                            return method3.invoke(parameter, new Object[0]);
                        }
                        catch (NoSuchMethodException e) {
                            return "arg" + i;
                        }
                    }
                    return null;
                }
            });
        }
    }
}

