/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.codahale.metrics.MetricRegistry;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.SolrException;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrCacheBase;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCache<K, V>
extends SolrCacheBase
implements SolrCache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LRUCache.class);
    public static final long DEFAULT_RAM_BYTES_USED = 192L;
    public static final long HASHTABLE_RAM_BYTES_PER_ENTRY = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2;
    static final long LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY = HASHTABLE_RAM_BYTES_PER_ENTRY + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    private CumulativeStats stats;
    private long lookups;
    private long hits;
    private long inserts;
    private long evictions;
    private long evictionsRamUsage;
    private long warmupTime = 0L;
    private Map<K, V> map;
    private String description = "LRU Cache";
    private MetricsMap cacheMap;
    private Set<String> metricNames = new HashSet<String>();
    private MetricRegistry registry;
    private long maxRamBytes = Long.MAX_VALUE;
    private long ramBytesUsed = 0L;

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        super.init(args, regenerator);
        String str = (String)args.get("size");
        final int limit = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("initialSize");
        int initialSize = Math.min(str == null ? 1024 : Integer.parseInt(str), limit);
        str = (String)args.get("maxRamMB");
        this.maxRamBytes = str == null ? Long.MAX_VALUE : (long)(Double.parseDouble(str) * 1024.0 * 1024.0);
        final long maxRamBytes = this.maxRamBytes;
        this.description = this.generateDescription(limit, initialSize);
        this.map = new LinkedHashMap<K, V>(initialSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > limit || LRUCache.this.ramBytesUsed > maxRamBytes) {
                    if (maxRamBytes != Long.MAX_VALUE && LRUCache.this.ramBytesUsed > maxRamBytes) {
                        long bytesToDecrement = 0L;
                        Iterator iterator = this.entrySet().iterator();
                        do {
                            Map.Entry entry;
                            if ((entry = iterator.next()).getKey() != null) {
                                bytesToDecrement = entry.getKey() instanceof Accountable ? (bytesToDecrement += ((Accountable)entry.getKey()).ramBytesUsed()) : (bytesToDecrement += 192L);
                            }
                            if (entry.getValue() != null) {
                                bytesToDecrement += ((Accountable)entry.getValue()).ramBytesUsed();
                            }
                            LRUCache.this.ramBytesUsed = LRUCache.this.ramBytesUsed - (bytesToDecrement += LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY);
                            iterator.remove();
                            LRUCache.this.evictions++;
                            LRUCache.this.evictionsRamUsage++;
                            ((LRUCache)LRUCache.this).stats.evictions.increment();
                            ((LRUCache)LRUCache.this).stats.evictionsRamUsage.increment();
                        } while (iterator.hasNext() && LRUCache.this.ramBytesUsed > maxRamBytes);
                        return false;
                    }
                    LRUCache.this.evictions++;
                    ((LRUCache)LRUCache.this).stats.evictions.increment();
                    return true;
                }
                return false;
            }
        };
        if (persistence == null) {
            persistence = new CumulativeStats();
        }
        this.stats = (CumulativeStats)persistence;
        return persistence;
    }

    private String generateDescription(int limit, int initialSize) {
        String description = "LRU Cache(maxSize=" + limit + ", initialSize=" + initialSize;
        if (this.isAutowarmingOn()) {
            description = description + ", " + this.getAutowarmDescription();
        }
        if (this.maxRamBytes != Long.MAX_VALUE) {
            description = description + ", maxRamMB=" + this.maxRamBytes / 1024L / 1024L;
        }
        description = description + ')';
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (this.getState() == SolrCache.State.LIVE) {
                this.stats.inserts.increment();
            }
            ++this.inserts;
            long keySize = 192L;
            if (this.maxRamBytes != Long.MAX_VALUE) {
                if (key != null && key instanceof Accountable) {
                    keySize = ((Accountable)key).ramBytesUsed();
                }
                long valueSize = 0L;
                if (value != null) {
                    if (value instanceof Accountable) {
                        Accountable accountable = (Accountable)value;
                        valueSize = accountable.ramBytesUsed();
                    } else {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cache: " + this.getName() + " is configured with maxRamBytes=" + RamUsageEstimator.humanReadableUnits((long)this.maxRamBytes) + " but its values do not implement org.apache.lucene.util.Accountable");
                    }
                }
                this.ramBytesUsed += keySize + valueSize + LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
            }
            V old = this.map.put(key, value);
            if (this.maxRamBytes != Long.MAX_VALUE && old != null) {
                long bytesToDecrement = ((Accountable)old).ramBytesUsed();
                bytesToDecrement += LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;
                if (key != null) {
                    if (key instanceof Accountable) {
                        Accountable aKey = (Accountable)key;
                        bytesToDecrement += aKey.ramBytesUsed();
                    } else {
                        bytesToDecrement += 192L;
                    }
                }
                this.ramBytesUsed -= bytesToDecrement;
            }
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Map<K, V> map = this.map;
        synchronized (map) {
            V val = this.map.get(key);
            if (this.getState() == SolrCache.State.LIVE) {
                ++this.lookups;
                this.stats.lookups.increment();
                if (val != null) {
                    ++this.hits;
                    this.stats.hits.increment();
                }
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.clear();
            this.ramBytesUsed = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache<K, V> old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        LRUCache other = (LRUCache)old;
        if (this.isAutowarmingOn()) {
            Object[] keys;
            Object[] vals = null;
            Map<K, V> map = other.map;
            synchronized (map) {
                int i;
                int sz = this.autowarm.getWarmCount(other.map.size());
                keys = new Object[sz];
                vals = new Object[sz];
                Iterator<Map.Entry<K, V>> iter = other.map.entrySet().iterator();
                int skip = other.map.size() - sz;
                for (i = 0; i < skip; ++i) {
                    iter.next();
                }
                for (i = 0; i < sz; ++i) {
                    Map.Entry<K, V> entry = iter.next();
                    keys[i] = entry.getKey();
                    vals[i] = entry.getValue();
                }
            }
            for (int i = 0; i < keys.length; ++i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, keys[i], vals[i]);
                    if (continueRegen) continue;
                    break;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + keys[i]), (Throwable)e);
                }
            }
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return LRUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registryName, String scope) {
        this.registry = manager.registry(registryName);
        this.cacheMap = new MetricsMap((detailed, res) -> {
            Map<K, V> map = this.map;
            synchronized (map) {
                res.put("lookups", this.lookups);
                res.put("hits", this.hits);
                res.put("hitratio", Float.valueOf(LRUCache.calcHitRatio(this.lookups, this.hits)));
                res.put("inserts", this.inserts);
                res.put("evictions", this.evictions);
                res.put("size", this.map.size());
                if (this.maxRamBytes != Long.MAX_VALUE) {
                    res.put("maxRamMB", this.maxRamBytes / 1024L / 1024L);
                    res.put("ramBytesUsed", this.ramBytesUsed());
                    res.put("evictionsRamUsage", this.evictionsRamUsage);
                }
            }
            res.put("warmupTime", this.warmupTime);
            long clookups = this.stats.lookups.longValue();
            long chits = this.stats.hits.longValue();
            res.put("cumulative_lookups", clookups);
            res.put("cumulative_hits", chits);
            res.put("cumulative_hitratio", Float.valueOf(LRUCache.calcHitRatio(clookups, chits)));
            res.put("cumulative_inserts", this.stats.inserts.longValue());
            res.put("cumulative_evictions", this.stats.evictions.longValue());
            if (this.maxRamBytes != Long.MAX_VALUE) {
                res.put("cumulative_evictionsRamUsage", this.stats.evictionsRamUsage.longValue());
            }
        });
        manager.registerGauge(this, registryName, this.cacheMap, true, scope, this.getCategory().toString());
    }

    MetricsMap getMetricsMap() {
        return this.cacheMap;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public String toString() {
        return this.name() + (this.cacheMap != null ? this.cacheMap.getValue().toString() : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ramBytesUsed() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return BASE_RAM_BYTES_USED + this.ramBytesUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Accountable> getChildResources() {
        if (this.maxRamBytes != Long.MAX_VALUE) {
            Map<K, V> map = this.map;
            synchronized (map) {
                return Accountables.namedAccountables((String)this.getName(), this.map);
            }
        }
        return Collections.emptyList();
    }

    private static class CumulativeStats {
        LongAdder lookups = new LongAdder();
        LongAdder hits = new LongAdder();
        LongAdder inserts = new LongAdder();
        LongAdder evictions = new LongAdder();
        LongAdder evictionsRamUsage = new LongAdder();

        private CumulativeStats() {
        }
    }
}

