/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CollectionApiMapping;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JsonSchemaValidator;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Template;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;

public class V1toV2ApiMapper {
    private static EnumMap<CollectionParams.CollectionAction, ActionInfo> mapping = new EnumMap(CollectionParams.CollectionAction.class);

    public static V2Request.Builder convert(CollectionAdminRequest request) {
        ActionInfo info = mapping.get((Object)request.action);
        if (info == null) {
            throw new RuntimeException("Unsupported action :" + (Object)((Object)request.action));
        }
        if (info.meta.getHttpMethod() == SolrRequest.METHOD.POST) {
            if (info.path == null) {
                info.setPath();
            }
            return info.convert(request.getParams());
        }
        return null;
    }

    static {
        for (CollectionApiMapping.Meta meta : CollectionApiMapping.Meta.values()) {
            if (meta.action == null) continue;
            mapping.put(meta.action, new ActionInfo(meta));
        }
    }

    private static class ActionInfo {
        CollectionApiMapping.Meta meta;
        String path;
        Template template;
        JsonSchemaValidator validator;

        ActionInfo(CollectionApiMapping.Meta meta) {
            this.meta = meta;
        }

        synchronized void setPath() {
            if (this.path == null) {
                ValidatingJsonMap m = Utils.getSpec(this.meta.getEndPoint().getSpecName()).getSpec();
                Object o = Utils.getObjectByPath((Object)m, false, "url/paths");
                String result = null;
                if (o instanceof List) {
                    for (Object s : (List)o) {
                        if (result != null && s.toString().length() >= result.length()) continue;
                        result = s.toString();
                    }
                } else if (o instanceof String) {
                    result = (String)o;
                }
                this.path = result;
                this.template = new Template(this.path, Template.BRACES_PLACEHOLDER_PATTERN);
                this.validator = new JsonSchemaValidator(m.getMap("commands", ValidatingJsonMap.NOT_NULL).getMap(this.meta.commandName, ValidatingJsonMap.NOT_NULL));
            }
        }

        public V2Request.Builder convert(SolrParams params) {
            String[] list = new String[this.template.variables.size()];
            MapWriter data = this.serializeToV2Format(params, list);
            Map o = data.toMap(new LinkedHashMap<String, Object>());
            return new V2Request.Builder(this.template.apply(s -> {
                int idx = this.template.variables.indexOf(s);
                return list[idx];
            })).withMethod(this.meta.getHttpMethod()).withPayload(o);
        }

        private MapWriter serializeToV2Format(SolrParams params, String[] list) {
            return ew -> ew.put(this.meta.commandName, ew1 -> {
                Iterator<String> iter = params.getParameterNamesIterator();
                HashMap<String, Map> subProperties = null;
                while (iter.hasNext()) {
                    String val;
                    String key = iter.next();
                    if ("action".equals(key)) continue;
                    Object substitute = this.meta.getReverseParamSubstitute(key);
                    int idx = this.template.variables.indexOf(substitute);
                    if (idx > -1) {
                        val = params.get(String.valueOf(substitute));
                        if (val == null) {
                            throw new RuntimeException("null value is not valid for " + key);
                        }
                        list[idx] = val;
                        continue;
                    }
                    if (substitute instanceof Pair) {
                        Pair p = (Pair)substitute;
                        if (subProperties == null) {
                            subProperties = new HashMap<String, Map>();
                        }
                        subProperties.computeIfAbsent((String)p.first(), s -> new HashMap()).put(p.second(), params.get(key));
                        continue;
                    }
                    val = params.get(key);
                    ew1.put(substitute.toString(), val);
                }
                if (subProperties != null) {
                    for (Map.Entry e : subProperties.entrySet()) {
                        ew1.put((String)e.getKey(), e.getValue());
                    }
                }
            });
        }
    }
}

