/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.RetrieveFieldsOptimizer;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DatePointField;
import org.apache.solr.schema.DoublePointField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatPointField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntPointField;
import org.apache.solr.schema.LongPointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrDocumentFetcher;

public class DocsStreamer
implements Iterator<SolrDocument> {
    public static final Set<Class> KNOWN_TYPES = new HashSet<Class>();
    private final ResultContext rctx;
    private final SolrDocumentFetcher docFetcher;
    private final DocList docs;
    private final DocTransformer transformer;
    private final DocIterator docIterator;
    private final RetrieveFieldsOptimizer retrieveFieldsOptimizer;
    private int idx = -1;

    public DocsStreamer(ResultContext rctx) {
        this.rctx = rctx;
        this.docs = rctx.getDocList();
        this.transformer = rctx.getReturnFields().getTransformer();
        this.docIterator = this.docs.iterator();
        this.docFetcher = rctx.getSearcher().getDocFetcher();
        this.retrieveFieldsOptimizer = RetrieveFieldsOptimizer.create(this.docFetcher, rctx.getReturnFields());
        this.retrieveFieldsOptimizer.optimize(this.docFetcher);
        if (this.transformer != null) {
            this.transformer.setContext(rctx);
        }
    }

    public int currentIndex() {
        return this.idx;
    }

    @Override
    public boolean hasNext() {
        return this.docIterator.hasNext();
    }

    @Override
    public SolrDocument next() {
        int id = this.docIterator.nextDoc();
        ++this.idx;
        SolrDocument sdoc = null;
        try {
            if (this.retrieveFieldsOptimizer.returnStoredFields()) {
                Document doc = this.docFetcher.doc(id, this.retrieveFieldsOptimizer.getStoredFields());
                sdoc = DocsStreamer.convertLuceneDocToSolrDoc(doc, this.rctx.getSearcher().getSchema());
            } else {
                sdoc = new SolrDocument();
            }
            if (this.retrieveFieldsOptimizer.returnDVFields()) {
                this.docFetcher.decorateDocValueFields((SolrDocumentBase)sdoc, id, this.retrieveFieldsOptimizer.getDvFields());
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading document with docId " + id, (Throwable)e);
        }
        if (this.transformer != null) {
            boolean doScore = this.rctx.wantsScores();
            try {
                if (doScore) {
                    this.transformer.transform(sdoc, id, this.docIterator.score());
                } else {
                    this.transformer.transform(sdoc, id);
                }
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error applying transformer", (Throwable)e);
            }
        }
        return sdoc;
    }

    public static SolrDocument convertLuceneDocToSolrDoc(Document doc, IndexSchema schema) {
        SolrDocument out = new SolrDocument();
        for (IndexableField f : doc.getFields()) {
            Object existing = out.get((Object)f.name());
            if (existing == null) {
                SchemaField sf = schema.getFieldOrNull(f.name());
                if (sf != null && sf.multiValued()) {
                    ArrayList<IndexableField> vals = new ArrayList<IndexableField>();
                    vals.add(f);
                    out.setField(f.name(), vals);
                    continue;
                }
                out.setField(f.name(), (Object)f);
                continue;
            }
            out.addField(f.name(), (Object)f);
        }
        return out;
    }

    @Override
    public void remove() {
    }

    public static Object getValue(SchemaField sf, IndexableField f) {
        FieldType ft = null;
        if (sf != null) {
            ft = sf.getType();
        }
        if (ft == null) {
            BytesRef bytesRef = f.binaryValue();
            if (bytesRef != null) {
                if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
                    return bytesRef.bytes;
                }
                byte[] bytes = new byte[bytesRef.length];
                System.arraycopy(bytesRef.bytes, bytesRef.offset, bytes, 0, bytesRef.length);
                return bytes;
            }
            return f.stringValue();
        }
        if (KNOWN_TYPES.contains(ft.getClass())) {
            return ft.toObject(f);
        }
        return ft.toExternal(f);
    }

    static {
        KNOWN_TYPES.add(BoolField.class);
        KNOWN_TYPES.add(StrField.class);
        KNOWN_TYPES.add(TextField.class);
        KNOWN_TYPES.add(TrieField.class);
        KNOWN_TYPES.add(TrieIntField.class);
        KNOWN_TYPES.add(TrieLongField.class);
        KNOWN_TYPES.add(TrieFloatField.class);
        KNOWN_TYPES.add(TrieDoubleField.class);
        KNOWN_TYPES.add(TrieDateField.class);
        KNOWN_TYPES.add(BinaryField.class);
        KNOWN_TYPES.add(IntPointField.class);
        KNOWN_TYPES.add(LongPointField.class);
        KNOWN_TYPES.add(DoublePointField.class);
        KNOWN_TYPES.add(FloatPointField.class);
        KNOWN_TYPES.add(DatePointField.class);
    }
}

